/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.common.persistence.RootPersistentEntity;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableACL
extends RootPersistentEntity {
    @JsonProperty
    private Map<String, TableBlackList> userTableBlackList = new HashMap<String, TableBlackList>();

    TableACL() {
    }

    public Map<String, TableBlackList> getUserTableBlackList() {
        return this.userTableBlackList;
    }

    public Set<String> getTableBlackList(String username) {
        TableBlackList tableBlackList = this.userTableBlackList.get(username);
        if (tableBlackList == null) {
            tableBlackList = new TableBlackList();
        }
        return tableBlackList.getTables();
    }

    public List<String> getUsersCannotQueryTheTbl(String table) {
        ArrayList<String> results = new ArrayList<String>();
        for (String user : this.userTableBlackList.keySet()) {
            TableBlackList tables = this.userTableBlackList.get(user);
            if (!tables.contains(table)) continue;
            results.add(user);
        }
        return results;
    }

    public TableACL add(String username, String table) {
        TableBlackList tableBlackList;
        if (this.userTableBlackList == null) {
            this.userTableBlackList = new HashMap<String, TableBlackList>();
        }
        if ((tableBlackList = this.userTableBlackList.get(username)) == null) {
            tableBlackList = new TableBlackList();
            this.userTableBlackList.put(username, tableBlackList);
        }
        this.checkACLExists(username, table, tableBlackList);
        tableBlackList.addTbl(table);
        return this;
    }

    public TableACL delete(String username, String table) {
        this.checkTableInBlackList(username, table);
        TableBlackList tableBlackList = this.userTableBlackList.get(username);
        tableBlackList.removeTbl(table);
        if (tableBlackList.isEmpty()) {
            this.userTableBlackList.remove(username);
        }
        return this;
    }

    public TableACL delete(String username) {
        this.checkUserHasACL(username);
        this.userTableBlackList.remove(username);
        return this;
    }

    public TableACL deleteByTbl(String table) {
        Iterator<Map.Entry<String, TableBlackList>> it = this.userTableBlackList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, TableBlackList> entry = it.next();
            TableBlackList tableBlackList = entry.getValue();
            tableBlackList.removeTbl(table);
            if (!tableBlackList.isEmpty()) continue;
            it.remove();
        }
        return this;
    }

    private void checkUserHasACL(String username) {
        if (this.userTableBlackList.get(username) == null || this.userTableBlackList.get(username).isEmpty()) {
            throw new RuntimeException("Operation fail, can not grant user table query permission.User:" + username + " already has permission!");
        }
    }

    private void checkACLExists(String username, String table, TableBlackList tableBlackList) {
        if (tableBlackList.contains(table)) {
            throw new RuntimeException("Operation fail, can not revoke user's table query permission.Table ACL " + table + ":" + username + " already exists!");
        }
    }

    private void checkTableInBlackList(String username, String table) {
        if (this.userTableBlackList == null || this.userTableBlackList.get(username) == null || !this.userTableBlackList.get(username).contains(table)) {
            throw new RuntimeException("Operation fail, can not grant user table query permission.Table ACL " + table + ":" + username + " is not found!");
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    static class TableBlackList {
        @JsonProperty
        Set<String> tables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

        TableBlackList() {
        }

        public int size() {
            return this.tables.size();
        }

        public boolean isEmpty() {
            return this.tables.isEmpty();
        }

        public boolean contains(String s) {
            return this.tables.contains(s);
        }

        void addTbl(String s) {
            this.tables.add(s);
        }

        void removeTbl(String s) {
            this.tables.remove(s);
        }

        public Set<String> getTables() {
            return this.tables;
        }
    }
}

