/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(MetadataManager.class);
    public static final Serializer<TableDesc> TABLE_SERIALIZER = new JsonSerializer<TableDesc>(TableDesc.class);
    public static final Serializer<TableExtDesc> TABLE_EXT_SERIALIZER = new JsonSerializer<TableExtDesc>(TableExtDesc.class);
    public static final Serializer<DataModelDesc> MODELDESC_SERIALIZER = new JsonSerializer<DataModelDesc>(DataModelDesc.class);
    public static final Serializer<ExternalFilterDesc> EXTERNAL_FILTER_DESC_SERIALIZER = new JsonSerializer<ExternalFilterDesc>(ExternalFilterDesc.class);
    private static final ConcurrentMap<KylinConfig, MetadataManager> CACHE = new ConcurrentHashMap<KylinConfig, MetadataManager>();
    private KylinConfig config;
    private CaseInsensitiveStringCache<TableDesc> srcTableMap;
    private CaseInsensitiveStringCache<TableExtDesc> srcTableExtMap;
    private CaseInsensitiveStringCache<DataModelDesc> dataModelDescMap;
    private CaseInsensitiveStringCache<ExternalFilterDesc> extFilterMap;

    public static MetadataManager getInstance(KylinConfig config) {
        MetadataManager r = (MetadataManager)CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<MetadataManager> clazz = MetadataManager.class;
        synchronized (MetadataManager.class) {
            r = (MetadataManager)CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new MetadataManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist, current keys: {}", (Object)StringUtils.join((Iterator)Iterators.transform(CACHE.keySet().iterator(), (Function)new Function<KylinConfig, String>(){

                        @Nullable
                        public String apply(@Nullable KylinConfig input) {
                            return String.valueOf(System.identityHashCode(input));
                        }
                    }), (String)","));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init MetadataManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private MetadataManager(KylinConfig config) throws IOException {
        this.init(config);
    }

    public void reload() {
        MetadataManager.clearCache();
        MetadataManager.getInstance(this.config);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public List<DataModelDesc> listDataModels() {
        return Lists.newArrayList(this.dataModelDescMap.values());
    }

    public List<TableDesc> listAllTables(String prj) {
        return Lists.newArrayList(this.getAllTablesMap(prj).values());
    }

    public List<ExternalFilterDesc> listAllExternalFilters() {
        return Lists.newArrayList(this.extFilterMap.values());
    }

    public Map<String, TableDesc> getAllTablesMap(String prj) {
        LinkedHashMap<String, TableDesc> globalTables = new LinkedHashMap<String, TableDesc>();
        LinkedHashMap<String, TableDesc> projectTables = new LinkedHashMap<String, TableDesc>();
        for (TableDesc t : this.srcTableMap.values()) {
            if (t.getProject() == null) {
                globalTables.put(t.getIdentity(), t);
                continue;
            }
            if (!t.getProject().equals(prj)) continue;
            projectTables.put(t.getIdentity(), t);
        }
        LinkedHashMap<String, TableDesc> result = globalTables;
        result.putAll(projectTables);
        return result;
    }

    public TableDesc getTableDesc(String tableName, String prj) {
        if (tableName.indexOf(".") < 0) {
            tableName = "DEFAULT." + tableName;
        }
        tableName.toUpperCase();
        TableDesc result = (TableDesc)this.srcTableMap.get(this.mapKey(tableName, prj));
        if (result == null) {
            result = (TableDesc)this.srcTableMap.get(this.mapKey(tableName, null));
        }
        return result;
    }

    public ExternalFilterDesc getExtFilterDesc(String filterTableName) {
        ExternalFilterDesc result = (ExternalFilterDesc)this.extFilterMap.get(filterTableName);
        return result;
    }

    public TableExtDesc getTableExt(String tableName, String prj) {
        TableDesc t = this.getTableDesc(tableName, prj);
        if (t == null) {
            return null;
        }
        return this.getTableExt(t);
    }

    public TableExtDesc getTableExt(TableDesc t) {
        TableExtDesc result = (TableExtDesc)this.srcTableExtMap.get(this.mapKey(t.getIdentity(), t.getProject()));
        if (null == result) {
            result = new TableExtDesc();
            result.setIdentity(t.getIdentity());
            result.setUuid(UUID.randomUUID().toString());
            result.setLastModified(0L);
            result.init(t.getProject());
            this.srcTableExtMap.put(this.mapKey(t.getIdentity(), t.getProject()), result);
        }
        return result;
    }

    public void saveTableExt(TableExtDesc tableExt, String prj) throws IOException {
        if (tableExt.getUuid() == null || tableExt.getIdentity() == null) {
            throw new IllegalArgumentException();
        }
        if (tableExt.getProject() == null) {
            if (this.getTableExt(tableExt.getIdentity(), prj).getProject() != null) {
                throw new IllegalStateException("Updating a legacy global TableExtDesc while a project level version exists: " + tableExt.getIdentity() + ", " + prj);
            }
            prj = tableExt.getProject();
        }
        tableExt.init(prj);
        String path = TableExtDesc.concatResourcePath(tableExt.getIdentity(), prj);
        ResourceStore store = this.getStore();
        TableExtDesc t = store.getResource(path, TableExtDesc.class, TABLE_EXT_SERIALIZER);
        if (t != null && t.getIdentity() == null) {
            store.deleteResource(path);
        }
        store.putResource(path, tableExt, TABLE_EXT_SERIALIZER);
        this.srcTableExtMap.put(this.mapKey(tableExt.getIdentity(), tableExt.getProject()), tableExt);
    }

    public void removeTableExt(String tableName, String prj) throws IOException {
        TableExtDesc t = this.getTableExt(tableName, prj);
        if (t == null) {
            return;
        }
        String path = TableExtDesc.concatResourcePath(t.getIdentity(), t.getProject());
        this.getStore().deleteResource(path);
        this.srcTableExtMap.remove(this.mapKey(t.getIdentity(), t.getProject()));
    }

    public void saveSourceTable(TableDesc srcTable, String prj) throws IOException {
        if (srcTable.getUuid() == null || srcTable.getIdentity() == null) {
            throw new IllegalArgumentException();
        }
        srcTable.init(prj);
        String path = TableDesc.concatResourcePath(srcTable.getIdentity(), prj);
        this.getStore().putResource(path, srcTable, TABLE_SERIALIZER);
        this.srcTableMap.put(this.mapKey(srcTable.getIdentity(), prj), srcTable);
    }

    public void removeSourceTable(String tableIdentity, String prj) throws IOException {
        TableDesc t = this.getTableDesc(tableIdentity, prj);
        if (t == null) {
            return;
        }
        String path = TableDesc.concatResourcePath(t.getIdentity(), t.getProject());
        this.getStore().deleteResource(path);
        this.srcTableMap.remove(this.mapKey(t.getIdentity(), t.getProject()));
    }

    public void saveExternalFilter(ExternalFilterDesc desc) throws IOException {
        if (desc.getUuid() == null) {
            throw new IllegalArgumentException("UUID not set.");
        }
        String path = desc.getResourcePath();
        this.getStore().putResource(path, desc, EXTERNAL_FILTER_DESC_SERIALIZER);
        desc = this.reloadExternalFilterAt(path);
        this.extFilterMap.put(desc.getName(), desc);
    }

    public void removeExternalFilter(String name) throws IOException {
        String path = ExternalFilterDesc.concatResourcePath(name);
        this.getStore().deleteResource(path);
        this.extFilterMap.remove(name);
    }

    private void init(KylinConfig config) throws IOException {
        this.config = config;
        this.srcTableMap = new CaseInsensitiveStringCache(config, "table");
        this.srcTableExtMap = new CaseInsensitiveStringCache(config, "table_ext");
        this.dataModelDescMap = new CaseInsensitiveStringCache(config, "data_model");
        this.extFilterMap = new CaseInsensitiveStringCache(config, "external_filter");
        this.reloadAllSourceTable();
        this.reloadAllTableExt();
        this.reloadAllDataModel();
        this.reloadAllExternalFilter();
        Broadcaster.getInstance(config).registerListener(new SrcTableSyncListener(), "table");
        Broadcaster.getInstance(config).registerListener(new SrcTableExtSyncListener(), "table_ext");
        Broadcaster.getInstance(config).registerListener(new DataModelSyncListener(), "data_model");
        Broadcaster.getInstance(config).registerListener(new ExtFilterSyncListener(), "external_filter");
    }

    private void reloadAllTableExt() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading Table_exd info from folder " + store.getReadableResourcePath("/table_exd"));
        this.srcTableExtMap.clear();
        List<String> paths = store.collectResourceRecursively("/table_exd", ".json");
        for (String path : paths) {
            this.reloadTableExtAt(path);
        }
        logger.debug("Loaded " + this.srcTableExtMap.size() + " SourceTable EXD(s)");
    }

    private TableExtDesc reloadTableExtAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        String prj = TableExtDesc.parseResourcePath(path).getSecond();
        TableExtDesc t = store.getResource(path, TableExtDesc.class, TABLE_EXT_SERIALIZER);
        if (t == null) {
            return null;
        }
        if (t.getIdentity() == null) {
            t = this.convertOldTableExtToNewer(path);
        }
        t.init(prj);
        this.srcTableExtMap.putLocal(this.mapKey(t.getIdentity(), prj), t);
        return t;
    }

    private String mapKey(String identity, String prj) {
        return prj == null ? identity : identity + "--" + prj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableExtDesc convertOldTableExtToNewer(String path) throws IOException {
        HashMap attrs = Maps.newHashMap();
        ResourceStore store = this.getStore();
        RawResource res = store.getResource(path);
        try (InputStream is = res.inputStream;){
            attrs.putAll(JsonUtil.readValue(is, HashMap.class));
        }
        String cardinality = (String)attrs.get("cardinality");
        String file = path;
        if (file.indexOf("/") > -1) {
            file = file.substring(file.lastIndexOf("/") + 1);
        }
        String tableIdentity = file.substring(0, file.length() - ".json".length()).toUpperCase();
        TableExtDesc result = new TableExtDesc();
        result.setIdentity(tableIdentity);
        result.setUuid(UUID.randomUUID().toString());
        result.setLastModified(0L);
        result.setCardinality(cardinality);
        return result;
    }

    private void reloadAllExternalFilter() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading ExternalFilter from folder " + store.getReadableResourcePath("/ext_filter"));
        this.extFilterMap.clear();
        List<String> paths = store.collectResourceRecursively("/ext_filter", ".json");
        for (String path : paths) {
            this.reloadExternalFilterAt(path);
        }
        logger.debug("Loaded " + this.extFilterMap.size() + " ExternalFilter(s)");
    }

    private void reloadAllSourceTable() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading SourceTable from folder " + store.getReadableResourcePath("/table"));
        this.srcTableMap.clear();
        List<String> paths = store.collectResourceRecursively("/table", ".json");
        for (String path : paths) {
            this.reloadSourceTableAt(path);
        }
        logger.debug("Loaded " + this.srcTableMap.size() + " SourceTable(s)");
    }

    private TableDesc reloadSourceTableAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        String prj = TableDesc.parseResourcePath(path).getSecond();
        TableDesc t = store.getResource(path, TableDesc.class, TABLE_SERIALIZER);
        if (t == null) {
            return null;
        }
        t.init(prj);
        this.srcTableMap.putLocal(this.mapKey(t.getIdentity(), prj), t);
        return t;
    }

    private ExternalFilterDesc reloadExternalFilterAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        ExternalFilterDesc t = store.getResource(path, ExternalFilterDesc.class, EXTERNAL_FILTER_DESC_SERIALIZER);
        if (t == null) {
            return null;
        }
        this.extFilterMap.putLocal(t.getName(), t);
        return t;
    }

    public void reloadExtFilter(String extFilterName) throws IOException {
        this.reloadExternalFilterAt(ExternalFilterDesc.concatResourcePath(extFilterName));
    }

    public DataModelDesc getDataModelDesc(String name) {
        return (DataModelDesc)this.dataModelDescMap.get(name);
    }

    public List<DataModelDesc> getModels() {
        return new ArrayList<DataModelDesc>(this.dataModelDescMap.values());
    }

    public List<DataModelDesc> getModels(String projectName) {
        ProjectInstance projectInstance = ProjectManager.getInstance(this.config).getProject(projectName);
        ArrayList<DataModelDesc> ret = new ArrayList<DataModelDesc>();
        if (projectInstance != null && projectInstance.getModels() != null) {
            for (String modelName : projectInstance.getModels()) {
                DataModelDesc model = this.getDataModelDesc(modelName);
                if (null != model) {
                    ret.add(model);
                    continue;
                }
                logger.error("Failed to load model " + modelName);
            }
        }
        return ret;
    }

    public List<String> getModelsUsingTable(TableDesc table, String project) throws IOException {
        ArrayList<String> models = new ArrayList<String>();
        for (DataModelDesc modelDesc : this.getModels(project)) {
            if (!modelDesc.containsTable(table)) continue;
            models.add(modelDesc.getName());
        }
        return models;
    }

    public boolean isTableInAnyModel(TableDesc table) {
        for (DataModelDesc modelDesc : this.getModels()) {
            if (!modelDesc.containsTable(table)) continue;
            return true;
        }
        return false;
    }

    private void reloadAllDataModel() throws IOException {
        ResourceStore store = this.getStore();
        logger.debug("Reloading DataModel from folder " + store.getReadableResourcePath("/model_desc"));
        this.dataModelDescMap.clear();
        List<String> paths = store.collectResourceRecursively("/model_desc", ".json");
        for (String path : paths) {
            try {
                logger.info("Reloading data model at " + path);
                this.reloadDataModelDescAt(path);
            }
            catch (IllegalStateException e) {
                logger.error("Error to load DataModel at " + path, (Throwable)e);
            }
        }
        logger.debug("Loaded " + this.dataModelDescMap.size() + " DataModel(s)");
    }

    public DataModelDesc reloadDataModelDescAt(String path) {
        ResourceStore store = this.getStore();
        try {
            DataModelDesc dataModelDesc = store.getResource(path, DataModelDesc.class, MODELDESC_SERIALIZER);
            String prj = ProjectManager.getInstance(this.config).getProjectOfModel(dataModelDesc.getName()).getName();
            if (!dataModelDesc.isDraft()) {
                dataModelDesc.init(this.config, this.getAllTablesMap(prj), this.listDataModels());
            }
            this.dataModelDescMap.putLocal(dataModelDesc.getName(), dataModelDesc);
            return dataModelDesc;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error to load " + path, e);
        }
    }

    public DataModelDesc dropModel(DataModelDesc desc) throws IOException {
        logger.info("Dropping model '" + desc.getName() + "'");
        ResourceStore store = this.getStore();
        store.deleteResource(desc.getResourcePath());
        ProjectManager.getInstance(this.config).removeModelFromProjects(desc.getName());
        this.afterModelDropped(desc);
        return desc;
    }

    private void afterModelDropped(DataModelDesc desc) {
        this.removeModelCache(desc.getName());
    }

    public void removeModelCache(String modelName) {
        this.dataModelDescMap.remove(modelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataModelDesc createDataModelDesc(DataModelDesc desc, String projectName, String owner) throws IOException {
        String name = desc.getName();
        if (this.dataModelDescMap.containsKey(name)) {
            throw new IllegalArgumentException("DataModelDesc '" + name + "' already exists");
        }
        ProjectManager prjMgr = ProjectManager.getInstance(this.config);
        ProjectInstance prj = prjMgr.getProject(projectName);
        if (prj.containsModel(name)) {
            throw new IllegalStateException("project " + projectName + " already contains model " + name);
        }
        try {
            prj.getModels().add(name);
            desc.setOwner(owner);
            desc = this.saveDataModelDesc(desc);
        }
        finally {
            prj.getModels().remove(name);
        }
        prjMgr.updateModelToProject(name, projectName);
        return desc;
    }

    public DataModelDesc updateDataModelDesc(DataModelDesc desc) throws IOException {
        String name = desc.getName();
        if (!this.dataModelDescMap.containsKey(name)) {
            throw new IllegalArgumentException("DataModelDesc '" + name + "' does not exist.");
        }
        return this.saveDataModelDesc(desc);
    }

    private DataModelDesc saveDataModelDesc(DataModelDesc dataModelDesc) throws IOException {
        String prj = ProjectManager.getInstance(this.config).getProjectOfModel(dataModelDesc.getName()).getName();
        if (!dataModelDesc.isDraft()) {
            dataModelDesc.init(this.config, this.getAllTablesMap(prj), this.listDataModels());
        }
        String path = dataModelDesc.getResourcePath();
        this.getStore().putResource(path, dataModelDesc, MODELDESC_SERIALIZER);
        this.dataModelDescMap.put(dataModelDesc.getName(), dataModelDesc);
        return dataModelDesc;
    }

    private class ExtFilterSyncListener
    extends Broadcaster.Listener {
        private ExtFilterSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            MetadataManager.clearCache();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if (event == Broadcaster.Event.DROP) {
                MetadataManager.this.extFilterMap.removeLocal(cacheKey);
            } else {
                MetadataManager.this.reloadExtFilter(cacheKey);
            }
        }
    }

    private class DataModelSyncListener
    extends Broadcaster.Listener {
        private DataModelSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            MetadataManager.clearCache();
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            for (String model : ProjectManager.getInstance(MetadataManager.this.config).getProject(project).getModels()) {
                MetadataManager.this.reloadDataModelDescAt(DataModelDesc.concatResourcePath(model));
            }
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if (event == Broadcaster.Event.DROP) {
                MetadataManager.this.dataModelDescMap.removeLocal(cacheKey);
            } else {
                MetadataManager.this.reloadDataModelDescAt(DataModelDesc.concatResourcePath(cacheKey));
            }
            for (ProjectInstance prj : ProjectManager.getInstance(MetadataManager.this.config).findProjectsByModel(cacheKey)) {
                broadcaster.notifyProjectSchemaUpdate(prj.getName());
            }
        }
    }

    private class SrcTableExtSyncListener
    extends Broadcaster.Listener {
        private SrcTableExtSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            MetadataManager.clearCache();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if (event == Broadcaster.Event.DROP) {
                MetadataManager.this.srcTableExtMap.removeLocal(cacheKey);
            } else {
                MetadataManager.this.reloadTableExtAt(TableExtDesc.concatRawResourcePath(cacheKey));
            }
        }
    }

    private class SrcTableSyncListener
    extends Broadcaster.Listener {
        private SrcTableSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            MetadataManager.clearCache();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if (event == Broadcaster.Event.DROP) {
                MetadataManager.this.srcTableMap.removeLocal(cacheKey);
            } else {
                MetadataManager.this.reloadSourceTableAt(TableDesc.concatRawResourcePath(cacheKey));
            }
            Pair<String, String> pair = TableDesc.parseResourcePath(cacheKey);
            String table = pair.getFirst();
            String prj = pair.getSecond();
            if (prj == null) {
                for (ProjectInstance p : ProjectManager.getInstance(MetadataManager.this.config).findProjectsByTable(table)) {
                    broadcaster.notifyProjectSchemaUpdate(p.getName());
                }
            } else {
                broadcaster.notifyProjectSchemaUpdate(prj);
            }
        }
    }
}

