/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.gridtable.CubeCodeSystem;
import org.apache.kylin.cube.gridtable.TrimmedCubeCodeSystem;
import org.apache.kylin.gridtable.GTUtil;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTInfo {
    private static final Logger logger = LoggerFactory.getLogger(GTInfo.class);
    String tableName;
    IGTCodeSystem codeSystem;
    DataType[] colTypes;
    ImmutableBitSet colPreferIndex;
    int nColumns;
    ImmutableBitSet colAll;
    TblColRef[] colRefs;
    ImmutableBitSet primaryKey;
    ImmutableBitSet[] colBlocks;
    int rowBlockSize;
    ImmutableBitSet colBlocksAll;
    public static final BytesSerializer<GTInfo> serializer = new BytesSerializer<GTInfo>(){

        @Override
        public void serialize(GTInfo value, ByteBuffer out) {
            if (value.codeSystem instanceof CubeCodeSystem) {
                BytesUtil.writeAsciiString(CubeCodeSystem.class.getCanonicalName(), out);
                TrimmedCubeCodeSystem trimmed = ((CubeCodeSystem)value.codeSystem).trimForCoprocessor();
                TrimmedCubeCodeSystem.serializer.serialize(trimmed, out);
            } else if (value.codeSystem != null) {
                BytesUtil.writeAsciiString(value.codeSystem.getClass().getCanonicalName(), out);
                BytesSerializer serializer = null;
                try {
                    serializer = (BytesSerializer)value.codeSystem.getClass().getField("serializer").get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException("failed to get serializer for " + value.codeSystem.getClass(), e);
                }
                serializer.serialize(value.codeSystem, out);
            } else {
                throw new IllegalStateException("code system cannot be null");
            }
            BytesUtil.writeUTFString(value.tableName, out);
            BytesUtil.writeVInt(value.colTypes.length, out);
            for (DataType dataType : value.colTypes) {
                DataType.serializer.serialize(dataType, out);
            }
            ImmutableBitSet.serializer.serialize(value.colPreferIndex, out);
            ImmutableBitSet.serializer.serialize(value.primaryKey, out);
            BytesUtil.writeVInt(value.colBlocks.length, out);
            for (ImmutableBitSet x : value.colBlocks) {
                ImmutableBitSet.serializer.serialize(x, out);
            }
            BytesUtil.writeVInt(value.rowBlockSize, out);
        }

        @Override
        public GTInfo deserialize(ByteBuffer in) {
            IGTCodeSystem codeSystem = null;
            String codeSystemType = BytesUtil.readAsciiString(in);
            if (CubeCodeSystem.class.getCanonicalName().equals(codeSystemType)) {
                codeSystem = TrimmedCubeCodeSystem.serializer.deserialize(in);
            } else {
                try {
                    Class<?> clazz = Class.forName(codeSystemType);
                    BytesSerializer serializer = (BytesSerializer)clazz.getField("serializer").get(null);
                    codeSystem = (IGTCodeSystem)serializer.deserialize(in);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to deserialize IGTCodeSystem " + codeSystemType, e);
                }
            }
            String newTableName = BytesUtil.readUTFString(in);
            int colTypesSize = BytesUtil.readVInt(in);
            DataType[] newColTypes = new DataType[colTypesSize];
            for (int i = 0; i < colTypesSize; ++i) {
                newColTypes[i] = DataType.serializer.deserialize(in);
            }
            ImmutableBitSet newColPreferIndex = ImmutableBitSet.serializer.deserialize(in);
            ImmutableBitSet newPrimaryKey = ImmutableBitSet.serializer.deserialize(in);
            int colBlockSize = BytesUtil.readVInt(in);
            ImmutableBitSet[] newColBlocks = new ImmutableBitSet[colBlockSize];
            for (int i = 0; i < colBlockSize; ++i) {
                newColBlocks[i] = ImmutableBitSet.serializer.deserialize(in);
            }
            int newRowBlockSize = BytesUtil.readVInt(in);
            return GTInfo.builder().setCodeSystem(codeSystem).setTableName(newTableName).setColumns(newColTypes).setColumnPreferIndex(newColPreferIndex).setPrimaryKey(newPrimaryKey).enableColumnBlock(newColBlocks).enableRowBlock(newRowBlockSize).build();
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    private GTInfo() {
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public DataType getColumnType(int i) {
        return this.colTypes[i];
    }

    public int getColumnBlockCount() {
        return this.colBlocks.length;
    }

    public ImmutableBitSet getColumnBlock(int i) {
        return this.colBlocks[i];
    }

    public ImmutableBitSet getPrimaryKey() {
        return this.primaryKey;
    }

    public ImmutableBitSet getAllColumns() {
        return this.colAll;
    }

    public boolean isRowBlockEnabled() {
        return this.rowBlockSize > 0;
    }

    public int getRowBlockSize() {
        return this.rowBlockSize;
    }

    public int getMaxRecordLength() {
        return this.getMaxColumnLength(this.colAll);
    }

    public int getMaxColumnLength(ImmutableBitSet selectedCols) {
        int result = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            result += this.codeSystem.maxCodeLength(c);
        }
        return result;
    }

    public int getMaxColumnLength() {
        int max = 0;
        for (int i = 0; i < this.nColumns; ++i) {
            max = Math.max(max, this.codeSystem.maxCodeLength(i));
        }
        return max;
    }

    public ImmutableBitSet selectColumns(ImmutableBitSet selectedColBlocks) {
        ImmutableBitSet result = ImmutableBitSet.EMPTY;
        for (int i = 0; i < selectedColBlocks.trueBitCount(); ++i) {
            result = result.or(this.colBlocks[selectedColBlocks.trueBitAt(i)]);
        }
        return result;
    }

    public ImmutableBitSet selectColumnBlocks(ImmutableBitSet columns) {
        if (columns == null) {
            columns = this.colAll;
        }
        BitSet result = new BitSet();
        for (int i = 0; i < this.colBlocks.length; ++i) {
            ImmutableBitSet cb = this.colBlocks[i];
            if (!cb.intersects(columns)) continue;
            result.set(i);
        }
        return new ImmutableBitSet(result);
    }

    public TblColRef colRef(int i) {
        if (this.colRefs == null) {
            this.colRefs = new TblColRef[this.nColumns];
        }
        if (this.colRefs[i] == null) {
            this.colRefs[i] = GTUtil.tblColRef(i, this.colTypes[i].toString());
        }
        return this.colRefs[i];
    }

    public void validateColRef(TblColRef ref) {
        TblColRef expected = this.colRef(ref.getColumnDesc().getZeroBasedIndex());
        if (!expected.equals(ref)) {
            throw new IllegalArgumentException();
        }
    }

    void validate() {
        if (this.codeSystem == null) {
            throw new IllegalStateException();
        }
        if (this.primaryKey == null || this.primaryKey.cardinality() == 0) {
            throw new IllegalStateException();
        }
        this.codeSystem.init(this);
        this.validateColumnBlocks();
    }

    private void validateColumnBlocks() {
        this.colAll = new ImmutableBitSet(0, this.nColumns);
        if (this.colBlocks == null) {
            this.colBlocks = new ImmutableBitSet[2];
            this.colBlocks[0] = this.primaryKey;
            this.colBlocks[1] = this.colAll.andNot(this.primaryKey);
        }
        this.colBlocksAll = new ImmutableBitSet(0, this.colBlocks.length);
        if (this.colPreferIndex == null) {
            this.colPreferIndex = ImmutableBitSet.EMPTY;
        }
        for (int i = 0; i < this.colBlocks.length; ++i) {
            for (int j = i + 1; j < this.colBlocks.length; ++j) {
                if (!this.colBlocks[i].intersects(this.colBlocks[j])) continue;
                throw new IllegalStateException();
            }
        }
        ImmutableBitSet merge = ImmutableBitSet.EMPTY;
        for (int i = 0; i < this.colBlocks.length; ++i) {
            merge = merge.or(this.colBlocks[i]);
        }
        if (!merge.equals(this.colAll)) {
            throw new IllegalStateException();
        }
        if (!this.primaryKey.equals(this.colBlocks[0])) {
            throw new IllegalStateException();
        }
        LinkedList<ImmutableBitSet> list = new LinkedList<ImmutableBitSet>(Arrays.asList(this.colBlocks));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ImmutableBitSet cb = (ImmutableBitSet)it.next();
            if (!cb.isEmpty()) continue;
            it.remove();
        }
        this.colBlocks = list.toArray(new ImmutableBitSet[list.size()]);
    }

    public IGTCodeSystem getCodeSystem() {
        return this.codeSystem;
    }

    public int getMaxLength() {
        int ret = 0;
        for (int i = 0; i < this.colAll.trueBitCount(); ++i) {
            ret += this.codeSystem.maxCodeLength(this.colAll.trueBitAt(i));
        }
        return ret;
    }

    public static class Builder {
        final GTInfo info = new GTInfo();

        private Builder() {
        }

        public Builder setTableName(String name) {
            this.info.tableName = name;
            return this;
        }

        public Builder setCodeSystem(IGTCodeSystem cs) {
            this.info.codeSystem = cs;
            return this;
        }

        public Builder setColumns(DataType ... colTypes) {
            this.info.nColumns = colTypes.length;
            this.info.colTypes = colTypes;
            return this;
        }

        public Builder setPrimaryKey(ImmutableBitSet primaryKey) {
            this.info.primaryKey = primaryKey;
            return this;
        }

        public Builder enableColumnBlock(ImmutableBitSet[] columnBlocks) {
            this.info.colBlocks = new ImmutableBitSet[columnBlocks.length];
            for (int i = 0; i < columnBlocks.length; ++i) {
                this.info.colBlocks[i] = columnBlocks[i];
            }
            return this;
        }

        public Builder enableRowBlock(int rowBlockSize) {
            this.info.rowBlockSize = rowBlockSize;
            return this;
        }

        public Builder setColumnPreferIndex(ImmutableBitSet colPreferIndex) {
            this.info.colPreferIndex = colPreferIndex;
            return this;
        }

        public GTInfo build() {
            this.info.validate();
            return this.info;
        }
    }
}

