/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.Serializable;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.dimension.AbstractDateDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;

public class TimeDimEnc
extends AbstractDateDimEnc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ENCODING_NAME = "time";

    public TimeDimEnc() {
        super(4, new AbstractDateDimEnc.IValueCodec(){
            private static final long serialVersionUID = 1L;

            @Override
            public long valueToCode(String value) {
                long millis = DateFormat.stringToMillis(value);
                return millis / 1000L;
            }

            @Override
            public String codeToValue(long code) {
                return String.valueOf(code * 1000L);
            }
        });
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return TimeDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new TimeDimEnc();
        }
    }
}

