/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryValueEnumerator;

public class MultipleDictionaryValueEnumerator
implements IDictionaryValueEnumerator {
    private List<Integer> curKeys = Lists.newArrayList();
    private String curValue = null;
    private List<Dictionary<String>> dictionaryList;

    public MultipleDictionaryValueEnumerator(List<DictionaryInfo> dictionaryInfoList) {
        this.dictionaryList = Lists.newArrayListWithCapacity((int)dictionaryInfoList.size());
        for (DictionaryInfo dictInfo : dictionaryInfoList) {
            Dictionary<String> dictionary = dictInfo.getDictionaryObject();
            this.dictionaryList.add(dictInfo.getDictionaryObject());
            this.curKeys.add(dictionary.getMinId());
        }
    }

    @Override
    public String current() throws IOException {
        return this.curValue;
    }

    @Override
    public boolean moveNext() throws IOException {
        String minValue = null;
        int curDictIndex = 0;
        for (int i = 0; i < this.dictionaryList.size(); ++i) {
            int curKey;
            Dictionary<String> dict = this.dictionaryList.get(i);
            if (dict == null || (curKey = this.curKeys.get(i).intValue()) > dict.getMaxId()) continue;
            String curValue = dict.getValueFromId(curKey);
            if (minValue != null && minValue.compareTo(curValue) <= 0) continue;
            minValue = curValue;
            curDictIndex = i;
        }
        if (minValue == null) {
            this.curValue = null;
            return false;
        }
        this.curValue = minValue;
        this.curKeys.set(curDictIndex, this.curKeys.get(curDictIndex) + 1);
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

