/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.upgrade.v1_4_0;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.cube.model.v1_4_0.CubeDesc;
import org.apache.kylin.cube.model.v1_4_0.DimensionDesc;
import org.apache.kylin.cube.upgrade.common.CubeMetadataUpgrade;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetadataUpgrade_v_1_4_0
extends CubeMetadataUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetadataUpgrade_v_1_4_0.class);
    private static final Serializer<CubeDesc> oldCubeDescSerializer = new JsonSerializer<CubeDesc>(CubeDesc.class);
    private List<String> updatedResources = Lists.newArrayList();

    public CubeMetadataUpgrade_v_1_4_0(String newMetadataUrl) {
        super(newMetadataUrl);
    }

    @Override
    public void upgradeNonCompatibleMeta() {
        this.dowork();
    }

    @Override
    public void upgradeCompatibleMeta() {
    }

    private CubeDesc loadOldCubeDesc(String path) {
        CubeDesc ndesc = null;
        try {
            ndesc = this.store.getResource(path, CubeDesc.class, oldCubeDescSerializer);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load old cubedesc at " + path);
        }
        if (StringUtils.isBlank((CharSequence)ndesc.getName())) {
            throw new IllegalStateException("CubeDesc name must not be blank");
        }
        return ndesc;
    }

    private DataModelDesc getDataModelDesc(String modelName) {
        MetadataManager.clearCache();
        return MetadataManager.getInstance(this.config).getDataModelDesc(modelName);
    }

    public void dowork() {
        List<String> paths = this.listResourceStore("/cube_desc");
        for (String path : paths) {
            logger.info("CubeMetadataUpgrade_v_1_4_0 handling in dowork {}", (Object)path);
            CubeDesc cubeDesc = this.loadOldCubeDesc(path);
            cubeDesc.init(this.config, MetadataManager.getInstance(this.config).getAllTablesMap(cubeDesc.getProject()));
            this.upgradeDataModelDesc(cubeDesc);
            this.upgradeCubeDesc(cubeDesc);
        }
    }

    private void upgradeDataModelDesc(CubeDesc cubeDesc) {
        boolean upgrade = false;
        DataModelDesc modelDesc = this.getDataModelDesc(cubeDesc.getModelName());
        try {
            if (modelDesc != null && modelDesc.getDimensions() == null && modelDesc.getMetrics() == null) {
                List<DimensionDesc> cubeDimDescList = cubeDesc.getDimensions();
                if (!CollectionUtils.isEmpty(cubeDimDescList)) {
                    HashMap modelDimMap = Maps.newHashMap();
                    for (DimensionDesc cubeDimDesc : cubeDimDescList) {
                        if (!modelDimMap.containsKey(cubeDimDesc.getTable())) {
                            modelDimMap.put(cubeDimDesc.getTable(), new HashSet());
                        }
                        ((HashSet)modelDimMap.get(cubeDimDesc.getTable())).addAll(Lists.newArrayList((Object[])(cubeDimDesc.getDerived() != null ? cubeDimDesc.getDerived() : cubeDimDesc.getColumn())));
                    }
                    ArrayList modelDimDescList = Lists.newArrayListWithCapacity((int)modelDimMap.size());
                    for (Map.Entry entry : modelDimMap.entrySet()) {
                        ModelDimensionDesc dimDesc = new ModelDimensionDesc();
                        dimDesc.setTable((String)entry.getKey());
                        String[] columns = new String[((HashSet)entry.getValue()).size()];
                        columns = ((HashSet)entry.getValue()).toArray(columns);
                        dimDesc.setColumns(columns);
                        modelDimDescList.add(dimDesc);
                    }
                    ModelDimensionDesc.capicalizeStrings(modelDimDescList);
                    modelDesc.setDimensions(modelDimDescList);
                    upgrade = true;
                }
                List<MeasureDesc> cubeMeasDescList = cubeDesc.getMeasures();
                if (!CollectionUtils.isEmpty(cubeDimDescList)) {
                    ArrayList metrics = Lists.newArrayListWithExpectedSize((int)cubeMeasDescList.size());
                    for (MeasureDesc measureDesc : cubeMeasDescList) {
                        for (TblColRef tblColRef : measureDesc.getFunction().getParameter().getColRefs()) {
                            metrics.add(tblColRef.getName());
                        }
                    }
                    String[] metricsArray = new String[metrics.size()];
                    modelDesc.setMetrics(metrics.toArray(metricsArray));
                    upgrade = true;
                }
            }
            if (upgrade) {
                this.store.putResource(modelDesc.getResourcePath(), modelDesc, MetadataManager.MODELDESC_SERIALIZER);
                this.updatedResources.add(modelDesc.getResourcePath());
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
            this.errorMsgs.add("upgradeDataModelDesc [" + modelDesc.getName() + "] failed: " + e.getLocalizedMessage());
        }
    }

    private void upgradeCubeDesc(CubeDesc cubeDesc) {
        try {
            DataModelDesc modelDesc = this.getDataModelDesc(cubeDesc.getModelName());
            PartitionDesc modelPartDesc = modelDesc.getPartitionDesc();
            if (cubeDesc.getPartitionDateStart() == 0L && modelPartDesc.getPartitionDateStart() != 0L) {
                cubeDesc.setPartitionDateStart(modelPartDesc.getPartitionDateStart());
            }
            this.store.putResource(cubeDesc.getResourcePath(), cubeDesc, oldCubeDescSerializer);
            this.updatedResources.add(cubeDesc.getResourcePath());
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
            this.errorMsgs.add("upgradeCubeDesc [" + cubeDesc.getName() + "] failed: " + e.getLocalizedMessage());
        }
    }
}

