/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.cube.model.HBaseMappingDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.cube.model.TooManyCuboidException;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.extendedcolumn.ExtendedColumnMeasureType;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IEngineAware;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeDesc
extends RootPersistentEntity
implements IEngineAware {
    private static final Logger logger = LoggerFactory.getLogger(CubeDesc.class);
    public static final int MAX_ROWKEY_SIZE = 64;
    private KylinConfigExt config;
    private DataModelDesc model;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="is_draft")
    private boolean isDraft;
    @JsonProperty(value="model_name")
    private String modelName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="null_string")
    private String[] nullStrings;
    @JsonProperty(value="dimensions")
    private List<DimensionDesc> dimensions;
    @JsonProperty(value="measures")
    private List<MeasureDesc> measures;
    @JsonProperty(value="dictionaries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<DictionaryDesc> dictionaries;
    @JsonProperty(value="rowkey")
    private RowKeyDesc rowkey;
    @JsonProperty(value="hbase_mapping")
    private HBaseMappingDesc hbaseMapping;
    @JsonProperty(value="aggregation_groups")
    private List<AggregationGroup> aggregationGroups;
    @JsonProperty(value="signature")
    private String signature;
    @JsonProperty(value="notify_list")
    private List<String> notifyList;
    @JsonProperty(value="status_need_notify")
    private List<String> statusNeedNotify = Collections.emptyList();
    @JsonProperty(value="partition_date_start")
    private long partitionDateStart = 0L;
    @JsonProperty(value="partition_date_end")
    private long partitionDateEnd = 3153600000000L;
    @JsonProperty(value="auto_merge_time_ranges")
    private long[] autoMergeTimeRanges;
    @JsonProperty(value="retention_range")
    private long retentionRange = 0L;
    @JsonProperty(value="engine_type")
    private int engineType = 0;
    @JsonProperty(value="storage_type")
    private int storageType = 0;
    @JsonProperty(value="override_kylin_properties")
    private LinkedHashMap<String, String> overrideKylinProps = new LinkedHashMap();
    @JsonProperty(value="partition_offset_start")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<Integer, Long> partitionOffsetStart = Maps.newHashMap();
    @JsonProperty(value="cuboid_black_list")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Set<Long> cuboidBlackSet = Sets.newHashSet();
    @JsonProperty(value="parent_forward")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private int parentForward = 3;
    private LinkedHashSet<TblColRef> allColumns = new LinkedHashSet();
    private LinkedHashSet<ColumnDesc> allColumnDescs = new LinkedHashSet();
    private LinkedHashSet<TblColRef> dimensionColumns = new LinkedHashSet();
    private Map<TblColRef, DeriveInfo> derivedToHostMap = Maps.newHashMap();
    private Map<Array<TblColRef>, List<DeriveInfo>> hostToDerivedMap = Maps.newHashMap();
    private Map<TblColRef, DeriveInfo> extendedColumnToHosts = Maps.newHashMap();
    private transient CuboidScheduler cuboidScheduler = null;
    private List<String> errors = new ArrayList<String>();

    public boolean isEnableSharding() {
        return this.storageType != 0 && this.storageType != 1;
    }

    public Set<TblColRef> getShardByColumns() {
        return this.getRowkey().getShardByColumns();
    }

    public Set<TblColRef> listAllColumns() {
        return this.allColumns == null ? null : Collections.unmodifiableSet(this.allColumns);
    }

    public Set<ColumnDesc> listAllColumnDescs() {
        return this.allColumnDescs == null ? null : Collections.unmodifiableSet(this.allColumnDescs);
    }

    public Set<TblColRef> listDimensionColumnsIncludingDerived() {
        return this.dimensionColumns == null ? null : Collections.unmodifiableSet(this.dimensionColumns);
    }

    public List<TblColRef> listDimensionColumnsExcludingDerived(boolean alsoExcludeExtendedCol) {
        ArrayList<TblColRef> result = new ArrayList<TblColRef>();
        for (TblColRef col : this.dimensionColumns) {
            if (this.isDerived(col) || alsoExcludeExtendedCol && this.isExtendedColumn(col)) continue;
            result.add(col);
        }
        return result;
    }

    public List<FunctionDesc> listAllFunctions() {
        ArrayList<FunctionDesc> functions = new ArrayList<FunctionDesc>();
        for (MeasureDesc m : this.measures) {
            functions.add(m.getFunction());
        }
        return functions;
    }

    public TblColRef findColumnRef(String table, String column) {
        return this.model.findColumn(table, column);
    }

    public DimensionDesc findDimensionByTable(String lookupTableName) {
        lookupTableName = lookupTableName.toUpperCase();
        for (DimensionDesc dim : this.dimensions) {
            if (dim.getTableRef() == null || !dim.getTableRef().getTableIdentity().equals(lookupTableName)) continue;
            return dim;
        }
        return null;
    }

    public boolean hasHostColumn(TblColRef col) {
        return this.isDerived(col) || this.isExtendedColumn(col);
    }

    public boolean isDerived(TblColRef col) {
        return this.derivedToHostMap.containsKey(col);
    }

    public boolean isExtendedColumn(TblColRef col) {
        return this.extendedColumnToHosts.containsKey(col);
    }

    public DeriveInfo getHostInfo(TblColRef derived) {
        if (this.isDerived(derived)) {
            return this.derivedToHostMap.get(derived);
        }
        if (this.isExtendedColumn(derived)) {
            return this.extendedColumnToHosts.get(derived);
        }
        throw new RuntimeException("Cannot get host info for " + derived);
    }

    public Map<Array<TblColRef>, List<DeriveInfo>> getHostToDerivedInfo(List<TblColRef> rowCols, Collection<TblColRef> wantedCols) {
        HashMap<Array<TblColRef>, List<DeriveInfo>> result = new HashMap<Array<TblColRef>, List<DeriveInfo>>();
        for (Map.Entry<Array<TblColRef>, List<DeriveInfo>> entry : this.hostToDerivedMap.entrySet()) {
            Array<TblColRef> hostCols = entry.getKey();
            boolean hostOnRow = rowCols.containsAll(Arrays.asList(hostCols.data));
            if (!hostOnRow) continue;
            ArrayList<DeriveInfo> wantedInfo = new ArrayList<DeriveInfo>();
            for (DeriveInfo info : entry.getValue()) {
                if (wantedCols != null && Collections.disjoint(wantedCols, Arrays.asList(info.columns))) continue;
                wantedInfo.add(info);
            }
            if (wantedInfo.size() <= 0) continue;
            result.put(hostCols, wantedInfo);
        }
        return result;
    }

    public String getResourcePath() {
        return CubeDesc.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String descName) {
        return "/cube_desc/" + descName + ".json";
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    private void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public void setDraft(boolean isDraft) {
        this.isDraft = isDraft;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public DataModelDesc getModel() {
        return this.model;
    }

    public void setModel(DataModelDesc model) {
        this.model = model;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getNullStrings() {
        return this.nullStrings;
    }

    public List<DimensionDesc> getDimensions() {
        return this.dimensions == null ? null : Collections.unmodifiableList(this.dimensions);
    }

    public void setDimensions(List<DimensionDesc> dimensions) {
        this.dimensions = dimensions;
    }

    public List<MeasureDesc> getMeasures() {
        return this.measures == null ? null : Collections.unmodifiableList(this.measures);
    }

    public void setMeasures(List<MeasureDesc> measures) {
        this.measures = measures;
    }

    public List<DictionaryDesc> getDictionaries() {
        return this.dictionaries == null ? null : Collections.unmodifiableList(this.dictionaries);
    }

    public void setDictionaries(List<DictionaryDesc> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public RowKeyDesc getRowkey() {
        return this.rowkey;
    }

    public void setRowkey(RowKeyDesc rowkey) {
        this.rowkey = rowkey;
    }

    public List<AggregationGroup> getAggregationGroups() {
        return this.aggregationGroups == null ? null : Collections.unmodifiableList(this.aggregationGroups);
    }

    public void setAggregationGroups(List<AggregationGroup> aggregationGroups) {
        this.aggregationGroups = aggregationGroups;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public List<String> getNotifyList() {
        return this.notifyList == null ? null : Collections.unmodifiableList(this.notifyList);
    }

    public void setNotifyList(List<String> notifyList) {
        this.notifyList = notifyList;
    }

    public List<String> getStatusNeedNotify() {
        return this.statusNeedNotify == null ? null : Collections.unmodifiableList(this.statusNeedNotify);
    }

    public void setStatusNeedNotify(List<String> statusNeedNotify) {
        this.statusNeedNotify = statusNeedNotify;
    }

    public LinkedHashMap<String, String> getOverrideKylinProps() {
        return this.overrideKylinProps;
    }

    private void setOverrideKylinProps(LinkedHashMap<String, String> overrideKylinProps) {
        this.overrideKylinProps = overrideKylinProps;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubeDesc cubeDesc = (CubeDesc)o;
        if (!this.name.equals(cubeDesc.name)) {
            return false;
        }
        return this.modelName.equals(cubeDesc.modelName);
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.model.getRootFactTable().hashCode();
        return result;
    }

    public String toString() {
        return "CubeDesc [name=" + this.name + "]";
    }

    public boolean checkSignature() {
        if (this.getConfig().isIgnoreCubeSignatureInconsistency()) {
            logger.info("Skip checking cube signature");
            return true;
        }
        KylinVersion cubeVersion = new KylinVersion(this.getVersion());
        KylinVersion kylinVersion = KylinVersion.getCurrentVersion();
        if (!kylinVersion.isCompatibleWith(cubeVersion)) {
            logger.info("checkSignature on {} is skipped as the its version {} is different from kylin version {}", new Object[]{this.getName(), cubeVersion, kylinVersion});
            return true;
        }
        if (kylinVersion.isCompatibleWith(cubeVersion) && !kylinVersion.isSignatureCompatibleWith(cubeVersion)) {
            logger.info("checkSignature on {} is skipped as the its version is {} (not signature compatible but compatible) ", (Object)this.getName(), (Object)cubeVersion);
            return true;
        }
        if (StringUtils.isBlank((String)this.getSignature())) {
            return true;
        }
        String calculated = this.calculateSignature();
        String saved = this.getSignature();
        return calculated.equals(saved);
    }

    public boolean consistentWith(CubeDesc another) {
        if (another == null) {
            return false;
        }
        return this.calculateSignature().equals(another.calculateSignature());
    }

    public String calculateSignature() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder sigString = new StringBuilder();
            sigString.append(this.name).append("|").append(JsonUtil.writeValueAsString(this.modelName)).append("|").append(JsonUtil.writeValueAsString(this.nullStrings)).append("|").append(JsonUtil.writeValueAsString(this.dimensions)).append("|").append(JsonUtil.writeValueAsString(this.measures)).append("|").append(JsonUtil.writeValueAsString(this.rowkey)).append("|").append(JsonUtil.writeValueAsString(this.aggregationGroups)).append("|").append(JsonUtil.writeValueAsString(this.hbaseMapping)).append("|").append(JsonUtil.writeValueAsString(this.engineType)).append("|").append(JsonUtil.writeValueAsString(this.storageType)).append("|");
            String signatureInput = sigString.toString().replaceAll("\\s+", "").toLowerCase();
            byte[] signature = md.digest(signatureInput.getBytes());
            String ret = new String(Base64.encodeBase64((byte[])signature));
            return ret;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to calculate signature");
        }
    }

    public void deInit() {
        this.config = null;
        this.model = null;
        this.allColumns = new LinkedHashSet();
        this.allColumnDescs = new LinkedHashSet();
        this.dimensionColumns = new LinkedHashSet();
        this.derivedToHostMap = Maps.newHashMap();
        this.hostToDerivedMap = Maps.newHashMap();
        this.extendedColumnToHosts = Maps.newHashMap();
        this.cuboidBlackSet = Sets.newHashSet();
        this.cuboidScheduler = null;
    }

    public void init(KylinConfig config) {
        this.errors.clear();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.name), (Object)"CubeDesc name is blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.modelName), (String)"CubeDesc (%s) has blank model name", (Object[])new Object[]{this.name});
        List<ProjectInstance> ownerPrj = ProjectManager.getInstance(config).findProjects(RealizationType.CUBE, this.name);
        if (ownerPrj.size() == 1) {
            LinkedHashMap<String, String> prjOverrideProps = ownerPrj.get(0).getOverrideKylinProps();
            for (Map.Entry entry : prjOverrideProps.entrySet()) {
                if (this.overrideKylinProps.containsKey(entry.getKey())) continue;
                this.overrideKylinProps.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.config = KylinConfigExt.createInstance(config, this.overrideKylinProps);
        Preconditions.checkArgument((this.rowkey.getRowKeyColumns().length <= this.config.getCubeRowkeyMaxSize() ? 1 : 0) != 0, (String)"Too many rowkeys (%s) in CubeDesc, please try to reduce dimension number or adopt derived dimensions", (Object[])new Object[]{this.rowkey.getRowKeyColumns().length});
        this.model = MetadataManager.getInstance(config).getDataModelDesc(this.modelName);
        Preconditions.checkNotNull((Object)this.model, (String)"DateModelDesc(%s) not found", (Object[])new Object[]{this.modelName});
        for (DimensionDesc dim : this.dimensions) {
            dim.init(this);
        }
        this.initDimensionColumns();
        this.initMeasureColumns();
        this.rowkey.init(this);
        for (AggregationGroup agg : this.aggregationGroups) {
            agg.init(this, this.rowkey);
        }
        this.validateAggregationGroups();
        this.validateAggregationGroupsCombination();
        String hbaseMappingAdapterName = config.getHBaseMappingAdapter();
        if (hbaseMappingAdapterName != null) {
            try {
                Class<?> hbaseMappingAdapterClass = Class.forName(hbaseMappingAdapterName);
                Method initMethod = hbaseMappingAdapterClass.getMethod("initHBaseMapping", CubeDesc.class);
                initMethod.invoke(null, this);
                Method initMeasureReferenceToColumnFamilyMethod = hbaseMappingAdapterClass.getMethod("initMeasureReferenceToColumnFamilyWithChecking", CubeDesc.class);
                initMeasureReferenceToColumnFamilyMethod.invoke(null, this);
            }
            catch (Exception e) {
                logger.error("Wrong configuration for kylin.metadata.hbasemapping-adapter: class " + hbaseMappingAdapterName + " not found. ");
            }
        } else if (this.hbaseMapping != null) {
            this.hbaseMapping.init(this);
            this.initMeasureReferenceToColumnFamily();
        }
        List<TblColRef> dimCols = this.listDimensionColumnsExcludingDerived(true);
        Preconditions.checkState((this.rowkey.getRowKeyColumns().length == dimCols.size() ? 1 : 0) != 0, (String)"RowKey columns count (%s) doesn't match dimensions columns count (%s)", (Object[])new Object[]{this.rowkey.getRowKeyColumns().length, dimCols.size()});
        this.initDictionaryDesc();
        this.amendAllColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CuboidScheduler getInitialCuboidScheduler() {
        if (this.cuboidScheduler != null) {
            return this.cuboidScheduler;
        }
        CubeDesc cubeDesc = this;
        synchronized (cubeDesc) {
            if (this.cuboidScheduler == null) {
                this.cuboidScheduler = CuboidScheduler.getInstance(this);
            }
            return this.cuboidScheduler;
        }
    }

    public boolean isBlackedCuboid(long cuboidID) {
        return this.cuboidBlackSet.contains(cuboidID);
    }

    public void validateAggregationGroupsCombination() {
        int index = 0;
        for (AggregationGroup agg : this.getAggregationGroups()) {
            try {
                long combination = agg.calculateCuboidCombination();
                if (combination > this.config.getCubeAggrGroupMaxCombination()) {
                    String msg = "Aggregation group " + index + " of Cube Desc " + this.name + " has too many combinations: " + combination + ". Use 'mandatory'/'hierarchy'/'joint' to optimize; or update 'kylin.cube.aggrgroup.max-combination' to a bigger value.";
                    throw new TooManyCuboidException(msg);
                }
            }
            catch (TooManyCuboidException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unknown error while calculating cuboid number for Aggregation group " + index + " of Cube Desc " + this.name, e);
            }
            ++index;
        }
    }

    public void validateAggregationGroups() {
        int index = 0;
        for (AggregationGroup agg : this.getAggregationGroups()) {
            if (agg.getIncludes() == null) {
                logger.error("Aggregation group " + index + " 'includes' field not set");
                throw new IllegalStateException("Aggregation group " + index + " includes field not set");
            }
            if (agg.getSelectRule() == null) {
                logger.error("Aggregation group " + index + " 'select_rule' field not set");
                throw new IllegalStateException("Aggregation group " + index + " select rule field not set");
            }
            TreeSet<String> includeDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(includeDims, agg.getIncludes());
            TreeSet<String> mandatoryDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(mandatoryDims, agg.getSelectRule().mandatoryDims);
            ArrayList hierarchyDimsList = Lists.newArrayList();
            TreeSet<String> hierarchyDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(hierarchyDimsList, hierarchyDims, agg.getSelectRule().hierarchyDims);
            ArrayList jointDimsList = Lists.newArrayList();
            TreeSet<String> jointDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.getDims(jointDimsList, jointDims, agg.getSelectRule().jointDims);
            if (!(includeDims.containsAll(mandatoryDims) && includeDims.containsAll(hierarchyDims) && includeDims.containsAll(jointDims))) {
                ArrayList notIncluded = Lists.newArrayList();
                Iterable all = Iterables.unmodifiableIterable((Iterable)Iterables.concat(mandatoryDims, hierarchyDims, jointDims));
                for (String dim : all) {
                    if (includeDims.contains(dim)) continue;
                    notIncluded.add(dim);
                }
                Collections.sort(notIncluded);
                logger.error("Aggregation group " + index + " Include dimensions not containing all the used dimensions");
                throw new IllegalStateException("Aggregation group " + index + " 'includes' dimensions not include all the dimensions:" + ((Object)notIncluded).toString());
            }
            if (CollectionUtils.containsAny(mandatoryDims, hierarchyDims)) {
                logger.warn("Aggregation group " + index + " mandatory dimensions overlap with hierarchy dimensions: " + this.ensureOrder(CollectionUtils.intersection(mandatoryDims, hierarchyDims)));
            }
            if (CollectionUtils.containsAny(mandatoryDims, jointDims)) {
                logger.warn("Aggregation group " + index + " mandatory dimensions overlap with joint dimensions: " + this.ensureOrder(CollectionUtils.intersection(mandatoryDims, jointDims)));
            }
            if (CollectionUtils.containsAny(hierarchyDims, jointDims)) {
                logger.error("Aggregation group " + index + " hierarchy dimensions overlap with joint dimensions");
                throw new IllegalStateException("Aggregation group " + index + " hierarchy dimensions overlap with joint dimensions: " + this.ensureOrder(CollectionUtils.intersection(hierarchyDims, jointDims)));
            }
            if (this.hasSingleOrNone(hierarchyDimsList)) {
                logger.error("Aggregation group " + index + " require at least 2 dimensions in a hierarchy");
                throw new IllegalStateException("Aggregation group " + index + " require at least 2 dimensions in a hierarchy.");
            }
            if (this.hasSingleOrNone(jointDimsList)) {
                logger.error("Aggregation group " + index + " require at least 2 dimensions in a joint");
                throw new IllegalStateException("Aggregation group " + index + " require at least 2 dimensions in a joint");
            }
            Pair<Boolean, Set<String>> overlap = this.hasOverlap(hierarchyDimsList, hierarchyDims);
            if (overlap.getFirst().booleanValue()) {
                logger.error("Aggregation group " + index + " a dimension exist in more than one hierarchy: " + this.ensureOrder(overlap.getSecond()));
                throw new IllegalStateException("Aggregation group " + index + " a dimension exist in more than one hierarchy: " + this.ensureOrder(overlap.getSecond()));
            }
            overlap = this.hasOverlap(jointDimsList, jointDims);
            if (overlap.getFirst().booleanValue()) {
                logger.error("Aggregation group " + index + " a dimension exist in more than one joint: " + this.ensureOrder(overlap.getSecond()));
                throw new IllegalStateException("Aggregation group " + index + " a dimension exist in more than one joint: " + this.ensureOrder(overlap.getSecond()));
            }
            ++index;
        }
    }

    private void getDims(Set<String> dims, String[] stringSet) {
        if (stringSet != null) {
            for (String str : stringSet) {
                dims.add(str);
            }
        }
    }

    private void getDims(ArrayList<Set<String>> dimsList, Set<String> dims, String[][] stringSets) {
        if (stringSets != null) {
            for (String[] ss : stringSets) {
                TreeSet<String> temp = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (String s : ss) {
                    temp.add(s);
                    dims.add(s);
                }
                dimsList.add(temp);
            }
        }
    }

    private boolean hasSingleOrNone(ArrayList<Set<String>> dimsList) {
        boolean hasSingleOrNone = false;
        for (Set<String> dims : dimsList) {
            if (dims.size() > 1) continue;
            hasSingleOrNone = true;
            break;
        }
        return hasSingleOrNone;
    }

    private Pair<Boolean, Set<String>> hasOverlap(ArrayList<Set<String>> dimsList, Set<String> Dims) {
        HashSet<String> existing = new HashSet<String>();
        HashSet overlap = new HashSet();
        for (Set<String> dims : dimsList) {
            if (CollectionUtils.containsAny(existing, dims)) {
                overlap.addAll(this.ensureOrder(CollectionUtils.intersection(existing, dims)));
            }
            existing.addAll(dims);
        }
        return new Pair<Boolean, Set<String>>(overlap.size() > 0, overlap);
    }

    private void initDimensionColumns() {
        for (DimensionDesc dim : this.dimensions) {
            JoinDesc join = dim.getJoin();
            ArrayList dimCols = Lists.newArrayList();
            String colStr = dim.getColumn();
            if (colStr == null && dim.isDerived() || "{FK}".equalsIgnoreCase(colStr)) {
                for (TblColRef col : join.getForeignKeyColumns()) {
                    dimCols.add(this.initDimensionColRef(col));
                }
            } else {
                Preconditions.checkState((!StringUtils.isEmpty((String)colStr) ? 1 : 0) != 0, (String)"Dimension column must not be blank: %s", (Object[])new Object[]{dim});
                dimCols.add(this.initDimensionColRef(dim, colStr));
            }
            TblColRef[] dimColArray = dimCols.toArray(new TblColRef[dimCols.size()]);
            dim.setColumnRefs(dimColArray);
            if (dim.isDerived()) {
                String[] derived = dim.getDerived();
                String[][] split = this.splitDerivedColumnAndExtra(derived);
                String[] derivedNames = split[0];
                String[] derivedExtra = split[1];
                TblColRef[] derivedCols = new TblColRef[derivedNames.length];
                for (int i = 0; i < derivedNames.length; ++i) {
                    derivedCols[i] = this.initDimensionColRef(dim, derivedNames[i]);
                }
                this.initDerivedMap(dimColArray, DeriveType.LOOKUP, join, derivedCols, derivedExtra);
            }
            if (join == null) continue;
            this.allColumns.addAll(Arrays.asList(join.getForeignKeyColumns()));
            this.allColumns.addAll(Arrays.asList(join.getPrimaryKeyColumns()));
        }
        HashSet<TblColRef> realDimensions = new HashSet<TblColRef>(this.listDimensionColumnsExcludingDerived(true));
        for (JoinTableDesc joinTable : this.model.getJoinTables()) {
            JoinDesc join = joinTable.getJoin();
            int n = join.getForeignKeyColumns().length;
            for (int i = 0; i < n; ++i) {
                TblColRef pk = join.getPrimaryKeyColumns()[i];
                TblColRef fk = join.getForeignKeyColumns()[i];
                if (realDimensions.contains(pk) && !realDimensions.contains(fk)) {
                    this.initDimensionColRef(fk);
                    this.initDerivedMap(new TblColRef[]{pk}, DeriveType.PK_FK, join, new TblColRef[]{fk}, null);
                    continue;
                }
                if (!realDimensions.contains(fk) || realDimensions.contains(pk)) continue;
                this.initDimensionColRef(pk);
                this.initDerivedMap(new TblColRef[]{fk}, DeriveType.PK_FK, join, new TblColRef[]{pk}, null);
            }
        }
    }

    private String[][] splitDerivedColumnAndExtra(String[] derived) {
        String[] cols = new String[derived.length];
        String[] extra = new String[derived.length];
        for (int i = 0; i < derived.length; ++i) {
            String str = derived[i];
            int cut = str.indexOf(":");
            if (cut >= 0) {
                cols[i] = str.substring(0, cut);
                extra[i] = str.substring(cut + 1).trim();
                continue;
            }
            cols[i] = str;
            extra[i] = "";
        }
        return new String[][]{cols, extra};
    }

    private void initDerivedMap(TblColRef[] hostCols, DeriveType type, JoinDesc join, TblColRef[] derivedCols, String[] extra) {
        int i;
        if (hostCols.length == 0 || derivedCols.length == 0) {
            throw new IllegalStateException("host/derived columns must not be empty");
        }
        for (i = 0; i < derivedCols.length; ++i) {
            if (!ArrayUtils.contains((Object[])hostCols, (Object)derivedCols[i])) continue;
            derivedCols = (TblColRef[])ArrayUtils.remove((Object[])derivedCols, (int)i);
            if (extra != null) {
                extra = (String[])ArrayUtils.remove((Object[])extra, (int)i);
            }
            --i;
        }
        if (derivedCols.length == 0) {
            return;
        }
        for (i = 0; i < derivedCols.length; ++i) {
            TblColRef derivedCol = derivedCols[i];
            boolean isOneToOne = type == DeriveType.PK_FK || ArrayUtils.contains((Object[])hostCols, (Object)derivedCol) || extra != null && extra[i].contains("1-1");
            this.derivedToHostMap.put(derivedCol, new DeriveInfo(type, join, hostCols, isOneToOne));
        }
        Array<TblColRef> hostColArray = new Array<TblColRef>(hostCols);
        List<DeriveInfo> infoList = this.hostToDerivedMap.get(hostColArray);
        if (infoList == null) {
            infoList = new ArrayList<DeriveInfo>();
            this.hostToDerivedMap.put(hostColArray, infoList);
        }
        ArrayList<TblColRef> whatsLeft = new ArrayList<TblColRef>();
        for (TblColRef derCol : derivedCols) {
            boolean merged = false;
            for (DeriveInfo existing : infoList) {
                if (existing.type != type || !existing.join.getPKSide().equals(join.getPKSide())) continue;
                if (ArrayUtils.contains((Object[])existing.columns, (Object)derCol)) {
                    merged = true;
                    break;
                }
                if (type != DeriveType.LOOKUP) continue;
                existing.columns = (TblColRef[])ArrayUtils.add((Object[])existing.columns, (Object)derCol);
                merged = true;
                break;
            }
            if (merged) continue;
            whatsLeft.add(derCol);
        }
        if (whatsLeft.size() > 0) {
            infoList.add(new DeriveInfo(type, join, whatsLeft.toArray(new TblColRef[whatsLeft.size()]), false));
        }
    }

    private TblColRef initDimensionColRef(DimensionDesc dim, String colName) {
        int idx;
        JoinDesc join;
        TblColRef col = this.model.findColumn(dim.getTable(), colName);
        if (KylinVersion.isBefore200(this.getVersion()) && (join = dim.getJoin()) != null && (idx = ArrayUtils.indexOf((Object[])join.getPrimaryKeyColumns(), (Object)col)) >= 0) {
            col = join.getForeignKeyColumns()[idx];
        }
        return this.initDimensionColRef(col);
    }

    private TblColRef initDimensionColRef(TblColRef col) {
        this.allColumns.add(col);
        this.dimensionColumns.add(col);
        return col;
    }

    private void initMeasureColumns() {
        if (this.measures == null || this.measures.isEmpty()) {
            return;
        }
        for (MeasureDesc m : this.measures) {
            m.setName(m.getName().toUpperCase());
            if (m.getDependentMeasureRef() != null) {
                m.setDependentMeasureRef(m.getDependentMeasureRef().toUpperCase());
            }
            FunctionDesc func = m.getFunction();
            func.init(this.model);
            this.allColumns.addAll(func.getParameter().getColRefs());
            if (!"EXTENDED_COLUMN".equalsIgnoreCase(m.getFunction().getExpression())) continue;
            FunctionDesc functionDesc = m.getFunction();
            List<TblColRef> hosts = ExtendedColumnMeasureType.getExtendedColumnHosts(functionDesc);
            TblColRef extendedColumn = ExtendedColumnMeasureType.getExtendedColumn(functionDesc);
            this.initExtendedColumnMap(hosts.toArray(new TblColRef[hosts.size()]), extendedColumn);
        }
    }

    private void initExtendedColumnMap(TblColRef[] hostCols, TblColRef extendedColumn) {
        this.extendedColumnToHosts.put(extendedColumn, new DeriveInfo(DeriveType.EXTENDED_COLUMN, null, hostCols, false));
    }

    public void initMeasureReferenceToColumnFamily() {
        if (this.measures == null || this.measures.size() == 0) {
            return;
        }
        HashMap<String, MeasureDesc> measureLookup = new HashMap<String, MeasureDesc>();
        for (MeasureDesc m : this.measures) {
            measureLookup.put(m.getName(), m);
        }
        HashMap<String, Integer> measureIndexLookup = new HashMap<String, Integer>();
        for (int i = 0; i < this.measures.size(); ++i) {
            measureIndexLookup.put(this.measures.get(i).getName(), i);
        }
        BitSet checkEachMeasureExist = new BitSet();
        HashSet measureSet = Sets.newHashSet();
        for (HBaseColumnFamilyDesc cf : this.getHbaseMapping().getColumnFamily()) {
            for (HBaseColumnDesc c : cf.getColumns()) {
                String[] colMeasureRefs = c.getMeasureRefs();
                MeasureDesc[] measureDescs = new MeasureDesc[colMeasureRefs.length];
                int[] measureIndex = new int[colMeasureRefs.length];
                int lastMeasureIndex = -1;
                for (int i = 0; i < colMeasureRefs.length; ++i) {
                    measureDescs[i] = (MeasureDesc)measureLookup.get(colMeasureRefs[i]);
                    Preconditions.checkState((measureDescs[i] != null ? 1 : 0) != 0, (String)"measure desc at (%s) is null", (Object[])new Object[]{i});
                    measureIndex[i] = (Integer)measureIndexLookup.get(colMeasureRefs[i]);
                    Preconditions.checkState((measureIndex[i] >= 0 ? 1 : 0) != 0, (String)"measure index at (%s) not positive", (Object[])new Object[]{i});
                    Preconditions.checkState((!measureSet.contains(colMeasureRefs[i]) ? 1 : 0) != 0, (String)"measure (%s) duplicates", (Object[])new Object[]{colMeasureRefs[i]});
                    measureSet.add(colMeasureRefs[i]);
                    Preconditions.checkState((measureIndex[i] > lastMeasureIndex ? 1 : 0) != 0, (String)"measure (%s) is not in order", (Object[])new Object[]{colMeasureRefs[i]});
                    lastMeasureIndex = measureIndex[i];
                    checkEachMeasureExist.set(measureIndex[i]);
                }
                c.setMeasures(measureDescs);
                c.setMeasureIndex(measureIndex);
                c.setColumnFamilyName(cf.getName());
            }
        }
        for (int i = 0; i < this.measures.size(); ++i) {
            Preconditions.checkState((boolean)checkEachMeasureExist.get(i), (String)"measure (%s) does not exist in column family, or measure duplicates", (Object[])new Object[]{this.measures.get(i)});
        }
    }

    private void initDictionaryDesc() {
        if (this.dictionaries != null) {
            for (DictionaryDesc dictDesc : this.dictionaries) {
                dictDesc.init(this);
                this.allColumns.add(dictDesc.getColumnRef());
                if (dictDesc.getResuseColumnRef() == null) continue;
                this.allColumns.add(dictDesc.getResuseColumnRef());
            }
        }
    }

    public TblColRef getColumnByBitIndex(int bitIndex) {
        RowKeyColDesc[] rowKeyColumns = this.getRowkey().getRowKeyColumns();
        return rowKeyColumns[rowKeyColumns.length - 1 - bitIndex].getColRef();
    }

    public boolean hasMemoryHungryMeasures() {
        for (MeasureDesc measure : this.measures) {
            if (!measure.getFunction().getMeasureType().isMemoryHungry()) continue;
            return true;
        }
        return false;
    }

    private void amendAllColumns() {
        Set<TableRef> tables = this.collectTablesOnJoinChain(this.allColumns);
        for (TableRef t : tables) {
            JoinDesc join = this.model.getJoinByPKSide(t);
            if (join == null) continue;
            this.allColumns.addAll(Arrays.asList(join.getForeignKeyColumns()));
            this.allColumns.addAll(Arrays.asList(join.getPrimaryKeyColumns()));
        }
        for (TblColRef col : this.allColumns) {
            this.allColumnDescs.add(col.getColumnDesc());
        }
    }

    private Set<TableRef> collectTablesOnJoinChain(Set<TblColRef> columns) {
        HashSet<TableRef> result = new HashSet<TableRef>();
        for (TblColRef col : columns) {
            TableRef t = col.getTableRef();
            while (t != null) {
                result.add(t);
                JoinDesc join = this.model.getJoinByPKSide(t);
                t = join == null ? null : join.getFKSide();
            }
        }
        return result;
    }

    public long getRetentionRange() {
        return this.retentionRange;
    }

    public void setRetentionRange(long retentionRange) {
        this.retentionRange = retentionRange;
    }

    public long[] getAutoMergeTimeRanges() {
        return this.autoMergeTimeRanges;
    }

    public void setAutoMergeTimeRanges(long[] autoMergeTimeRanges) {
        this.autoMergeTimeRanges = autoMergeTimeRanges;
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public List<String> getError() {
        return this.errors;
    }

    public String getErrorMsg() {
        StringBuffer sb = new StringBuffer();
        for (String error : this.errors) {
            sb.append(error + " ");
        }
        return sb.toString();
    }

    public HBaseMappingDesc getHbaseMapping() {
        return this.hbaseMapping;
    }

    public void setHbaseMapping(HBaseMappingDesc hbaseMapping) {
        this.hbaseMapping = hbaseMapping;
    }

    public void setNullStrings(String[] nullStrings) {
        this.nullStrings = nullStrings;
    }

    public boolean supportsLimitPushDown() {
        return this.getStorageType() != 0 && this.getStorageType() != 1;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    @Override
    public int getEngineType() {
        return this.engineType;
    }

    public void setEngineType(int engineType) {
        this.engineType = engineType;
    }

    public long getPartitionDateStart() {
        return this.partitionDateStart;
    }

    public void setPartitionDateStart(long partitionDateStart) {
        this.partitionDateStart = partitionDateStart;
    }

    public long getPartitionDateEnd() {
        return this.partitionDateEnd;
    }

    public void setPartitionDateEnd(long partitionDateEnd) {
        this.partitionDateEnd = partitionDateEnd;
    }

    public Map<Integer, Long> getPartitionOffsetStart() {
        return this.partitionOffsetStart;
    }

    public void setPartitionOffsetStart(Map<Integer, Long> partitionOffsetStart) {
        this.partitionOffsetStart = partitionOffsetStart;
    }

    public Set<Long> getAllCuboids() {
        return this.getInitialCuboidScheduler().getAllCuboidIds();
    }

    public int getParentForward() {
        return this.parentForward;
    }

    public void setParentForward(int parentForward) {
        this.parentForward = parentForward;
    }

    public Set<TblColRef> getAllColumnsHaveDictionary() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (RowKeyColDesc rowKeyColDesc : this.rowkey.getRowKeyColumns()) {
            TblColRef colRef = rowKeyColDesc.getColRef();
            if (!this.rowkey.isUseDictionary(colRef)) continue;
            result.add(colRef);
        }
        for (MeasureDesc measure : this.measures) {
            MeasureType<?> aggrType = measure.getFunction().getMeasureType();
            result.addAll(aggrType.getColumnsNeedDictionary(measure.getFunction()));
        }
        if (this.dictionaries != null) {
            for (DictionaryDesc dictDesc : this.dictionaries) {
                TblColRef col = dictDesc.getColumnRef();
                result.add(col);
            }
        }
        return result;
    }

    public Set<TblColRef> getAllColumnsNeedDictionaryBuilt() {
        Set<TblColRef> result = this.getAllColumnsHaveDictionary();
        if (this.dictionaries != null) {
            for (DictionaryDesc dictDesc : this.dictionaries) {
                if (dictDesc.getResuseColumnRef() == null) continue;
                result.remove(dictDesc.getColumnRef());
                result.add(dictDesc.getResuseColumnRef());
            }
        }
        return result;
    }

    public TblColRef getDictionaryReuseColumn(TblColRef col) {
        if (this.dictionaries == null) {
            return col;
        }
        for (DictionaryDesc dictDesc : this.dictionaries) {
            if (!dictDesc.getColumnRef().equals(col) || dictDesc.getResuseColumnRef() == null) continue;
            return dictDesc.getResuseColumnRef();
        }
        return col;
    }

    public TblColRef getDistributedByColumn() {
        Set<TblColRef> shardBy = this.getShardByColumns();
        if (shardBy != null && shardBy.size() > 0) {
            return shardBy.iterator().next();
        }
        return null;
    }

    TblColRef getClusteredByColumn() {
        if (this.getDistributedByColumn() != null) {
            return null;
        }
        if (this.dictionaries == null) {
            return null;
        }
        String clusterByColumn = this.config.getFlatHiveTableClusterByDictColumn();
        for (DictionaryDesc dictDesc : this.dictionaries) {
            if (!dictDesc.getColumnRef().getName().equalsIgnoreCase(clusterByColumn)) continue;
            return dictDesc.getColumnRef();
        }
        return null;
    }

    public String getDictionaryBuilderClass(TblColRef col) {
        if (this.dictionaries == null) {
            return null;
        }
        for (DictionaryDesc desc : this.dictionaries) {
            if (desc.getBuilderClass() == null || !col.equals(desc.getColumnRef())) continue;
            return desc.getBuilderClass();
        }
        return null;
    }

    public String getProject() {
        return this.getModel().getProject();
    }

    public static CubeDesc getCopyOf(CubeDesc cubeDesc) {
        CubeDesc newCubeDesc = new CubeDesc();
        newCubeDesc.setName(cubeDesc.getName());
        newCubeDesc.setDraft(cubeDesc.isDraft());
        newCubeDesc.setModelName(cubeDesc.getModelName());
        newCubeDesc.setDescription(cubeDesc.getDescription());
        newCubeDesc.setNullStrings(cubeDesc.getNullStrings());
        newCubeDesc.setDimensions(cubeDesc.getDimensions());
        newCubeDesc.setMeasures(cubeDesc.getMeasures());
        newCubeDesc.setDictionaries(cubeDesc.getDictionaries());
        newCubeDesc.setRowkey(cubeDesc.getRowkey());
        newCubeDesc.setHbaseMapping(cubeDesc.getHbaseMapping());
        newCubeDesc.setSignature(cubeDesc.getSignature());
        newCubeDesc.setNotifyList(cubeDesc.getNotifyList());
        newCubeDesc.setStatusNeedNotify(cubeDesc.getStatusNeedNotify());
        newCubeDesc.setAutoMergeTimeRanges(cubeDesc.getAutoMergeTimeRanges());
        newCubeDesc.setPartitionDateStart(cubeDesc.getPartitionDateStart());
        newCubeDesc.setPartitionDateEnd(cubeDesc.getPartitionDateEnd());
        newCubeDesc.setRetentionRange(cubeDesc.getRetentionRange());
        newCubeDesc.setEngineType(cubeDesc.getEngineType());
        newCubeDesc.setStorageType(cubeDesc.getStorageType());
        newCubeDesc.setAggregationGroups(cubeDesc.getAggregationGroups());
        newCubeDesc.setOverrideKylinProps(cubeDesc.getOverrideKylinProps());
        newCubeDesc.setConfig((KylinConfigExt)cubeDesc.getConfig());
        newCubeDesc.setPartitionOffsetStart(cubeDesc.getPartitionOffsetStart());
        newCubeDesc.setVersion(cubeDesc.getVersion());
        newCubeDesc.setParentForward(cubeDesc.getParentForward());
        newCubeDesc.updateRandomUuid();
        return newCubeDesc;
    }

    private Collection ensureOrder(Collection c) {
        TreeSet<String> set = new TreeSet<String>();
        for (Object o : c) {
            set.add(o.toString());
        }
        return set;
    }

    public static class DeriveInfo
    implements Serializable {
        public DeriveType type;
        public JoinDesc join;
        public TblColRef[] columns;
        public boolean isOneToOne;

        DeriveInfo(DeriveType type, JoinDesc join, TblColRef[] columns, boolean isOneToOne) {
            this.type = type;
            this.join = join;
            this.columns = columns;
            this.isOneToOne = isOneToOne;
        }

        public String toString() {
            return "DeriveInfo [type=" + this.type + ", join=" + this.join + ", columns=" + Arrays.toString(this.columns) + ", isOneToOne=" + this.isOneToOne + "]";
        }
    }

    public static enum DeriveType implements Serializable
    {
        LOOKUP,
        PK_FK,
        EXTENDED_COLUMN;

    }

    public static class CannotFilterExtendedColumnException
    extends RuntimeException {
        public CannotFilterExtendedColumnException(TblColRef tblColRef) {
            super(tblColRef == null ? "null" : tblColRef.getCanonicalName());
        }
    }
}

