/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.kylin.cube.cuboid.algorithm.generic.GeneticAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Chromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.ChromosomePair;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.ListPopulation;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Population;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.SelectionPolicy;

public class TournamentSelection
implements SelectionPolicy {
    private int arity;

    public TournamentSelection(int arity) {
        this.arity = arity;
    }

    @Override
    public ChromosomePair select(Population population) throws IllegalArgumentException {
        return new ChromosomePair(this.tournament((ListPopulation)population), this.tournament((ListPopulation)population));
    }

    private Chromosome tournament(ListPopulation population) throws IllegalArgumentException {
        if (population.getPopulationSize() < this.arity) {
            throw new IllegalArgumentException("Tournament arty is too large.");
        }
        ListPopulation tournamentPopulation = new ListPopulation(this.arity){

            @Override
            public Population nextGeneration() {
                return null;
            }
        };
        ArrayList chromosomes = Lists.newArrayList(population.getChromosomes());
        for (int i = 0; i < this.arity; ++i) {
            int rind = GeneticAlgorithm.RANDGEN.get().nextInt(chromosomes.size());
            tournamentPopulation.addChromosome((Chromosome)chromosomes.get(rind));
            chromosomes.remove(rind);
        }
        return tournamentPopulation.getFittestChromosome();
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }
}

