/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic.lib;

import java.util.BitSet;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.GeneticAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Chromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.ChromosomeMismatchException;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.ChromosomePair;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.CrossoverPolicy;

public class OnePointCrossover
implements CrossoverPolicy {
    @Override
    public ChromosomePair crossover(Chromosome first, Chromosome second) throws IllegalArgumentException, ChromosomeMismatchException {
        if (!(first instanceof BitsChromosome) || !(second instanceof BitsChromosome)) {
            throw new IllegalArgumentException("Chromosome first " + first.getClass() + " and second " + second.getClass() + " must be of type BitsChromosome.");
        }
        return this.crossover((BitsChromosome)first, (BitsChromosome)second);
    }

    private ChromosomePair crossover(BitsChromosome first, BitsChromosome second) throws ChromosomeMismatchException {
        int length = first.getLength();
        if (length != second.getLength()) {
            throw new ChromosomeMismatchException("BitsChromosome length mismatch.", second.getLength(), length);
        }
        BitSet parent1Key = first.getKey();
        BitSet parent2Key = second.getKey();
        BitSet child1Key = new BitSet(length);
        BitSet child2Key = new BitSet(length);
        int crossoverIndex = 1 + GeneticAlgorithm.RANDGEN.get().nextInt(length - 2);
        BitSet a = (BitSet)parent1Key.clone();
        a.clear(crossoverIndex, length);
        BitSet b = (BitSet)parent2Key.clone();
        b.clear(0, crossoverIndex);
        BitSet c = (BitSet)parent1Key.clone();
        c.clear(crossoverIndex, length);
        BitSet d = (BitSet)parent2Key.clone();
        d.clear(0, crossoverIndex);
        child1Key.or(a);
        child1Key.or(d);
        child2Key.or(c);
        child2Key.or(b);
        return new ChromosomePair(first.newBitsChromosome(child1Key), second.newBitsChromosome(child2Key));
    }
}

