/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic.lib;

import java.util.BitSet;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.GeneticAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.Chromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.lib.MutationPolicy;

public class BitsMutation
implements MutationPolicy {
    @Override
    public Chromosome mutate(Chromosome original) throws IllegalArgumentException {
        int geneIndex;
        BitSet newNey;
        if (!(original instanceof BitsChromosome)) {
            throw new IllegalArgumentException("Chromosome " + original.getClass() + " must be of type BitsChromosome.");
        }
        BitsChromosome origChrom = (BitsChromosome)original;
        boolean value = (newNey = (BitSet)origChrom.getKey().clone()).get(geneIndex = this.getMutationGeneIndex(origChrom));
        newNey.set(geneIndex, !value);
        BitsChromosome newChrom = origChrom.newBitsChromosome(newNey);
        return newChrom;
    }

    protected int getMutationGeneIndex(BitsChromosome origChrom) {
        return GeneticAlgorithm.RANDGEN.get().nextInt(origChrom.getLength());
    }
}

