/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;

public class CuboidEncoder {
    private List<Long> selectionCuboids;

    public CuboidEncoder(CuboidStats cuboidStats) {
        this.selectionCuboids = Lists.newArrayList(cuboidStats.getAllCuboidsForSelection());
        Collections.sort(this.selectionCuboids, Collections.reverseOrder());
    }

    public List<Long> toCuboidList(BitSet bits) {
        ArrayList cuboids = Lists.newArrayListWithCapacity((int)bits.cardinality());
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            cuboids.add(this.selectionCuboids.get(i));
            i = bits.nextSetBit(i + 1);
        }
        return cuboids;
    }
}

