/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.cuboid.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.cube.cuboid.algorithm.PBPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.generic.GeneticAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.greedy.GreedyAlgorithm;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidRecommender {
    private static final Logger logger = LoggerFactory.getLogger(CuboidRecommender.class);
    private static Cache<String, Map<Long, Long>> cuboidRecommendCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, Map<Long, Long>>(){

        public void onRemoval(RemovalNotification<String, Map<Long, Long>> notification) {
            logger.info("Dict with resource path " + (String)notification.getKey() + " is removed due to " + notification.getCause());
        }
    }).maximumSize((long)KylinConfig.getInstanceFromEnv().getCubePlannerRecommendCuboidCacheMaxSize()).expireAfterWrite(1L, TimeUnit.DAYS).build();
    private static CuboidRecommender instance = new CuboidRecommender();

    public CuboidRecommender() {
        Broadcaster.getInstance(KylinConfig.getInstanceFromEnv()).registerListener(new CuboidRecommenderSyncListener(), "cube");
    }

    public static CuboidRecommender getInstance() {
        return instance;
    }

    public Map<Long, Long> getRecommendCuboidList(final CuboidStats cuboidStats, final KylinConfig kylinConfig) {
        if (cuboidStats == null) {
            return null;
        }
        final String key = cuboidStats.getKey();
        Map results = (Map)cuboidRecommendCache.getIfPresent((Object)key);
        if (results == null) {
            try {
                results = (Map)cuboidRecommendCache.get((Object)key, (Callable)new Callable<Map<Long, Long>>(){

                    @Override
                    public Map<Long, Long> call() throws Exception {
                        HashMap emptyMap = Maps.newHashMap();
                        cuboidRecommendCache.put((Object)key, (Object)emptyMap);
                        try {
                            Map<Long, Long> recommendCuboid = CuboidRecommender.this.getRecommendCuboidList(cuboidStats, kylinConfig, true);
                            if (recommendCuboid != null) {
                                logger.info("Add recommend cuboids for " + key + " to cache");
                                cuboidRecommendCache.put((Object)key, recommendCuboid);
                            }
                            return recommendCuboid;
                        }
                        catch (Exception e) {
                            cuboidRecommendCache.invalidate((Object)key);
                            logger.error("Failed to get recommend cuboids for " + key + " in cache", (Throwable)e);
                            throw e;
                        }
                    }
                });
            }
            catch (ExecutionException e) {
                logger.error("Failed to get recommend cuboids for " + key);
            }
        }
        return results;
    }

    public Map<Long, Long> getRecommendCuboidList(CuboidStats cuboidStats, KylinConfig kylinConf, boolean ifForceRecommend) {
        long Threshold2;
        long Threshold1 = 1L << kylinConf.getCubePlannerAgreedyAlgorithmAutoThreshold();
        if (Threshold1 >= (Threshold2 = 1L << kylinConf.getCubePlannerGeneticAlgorithmAutoThreshold())) {
            logger.error("Invalid Cube Planner Algorithm configuration");
            return null;
        }
        int allCuboidCount = cuboidStats.getAllCuboidsForMandatory().size() + cuboidStats.getAllCuboidsForSelection().size();
        PBPUSCalculator benefitPolicy = new PBPUSCalculator(cuboidStats);
        AbstractRecommendAlgorithm algorithm = null;
        algorithm = (long)allCuboidCount <= Threshold2 ? new GreedyAlgorithm(-1L, benefitPolicy, cuboidStats) : new GeneticAlgorithm(-1L, benefitPolicy, cuboidStats);
        long startTime = System.currentTimeMillis();
        logger.info("Cube Planner Algorithm started at " + startTime);
        List<Long> recommendCuboidList = algorithm.recommend(kylinConf.getCubePlannerExpansionRateThreshold());
        logger.info("Cube Planner Algorithm ended at " + (System.currentTimeMillis() - startTime));
        if (recommendCuboidList.size() < allCuboidCount) {
            logger.info("Cube Planner Algorithm chooses " + recommendCuboidList.size() + " most effective cuboids to build among of all " + allCuboidCount + " cuboids.");
        }
        LinkedHashMap recommendCuboidsWithStats = Maps.newLinkedHashMap();
        for (Long cuboid : recommendCuboidList) {
            if (cuboid.equals(cuboidStats.getBaseCuboid())) {
                recommendCuboidsWithStats.put(cuboid, cuboidStats.getCuboidCount(cuboid));
                continue;
            }
            if (cuboidStats.getAllCuboidsForSelection().contains(cuboid)) {
                recommendCuboidsWithStats.put(cuboid, cuboidStats.getCuboidCount(cuboid));
                continue;
            }
            recommendCuboidsWithStats.put(cuboid, -1L);
        }
        if (!ifForceRecommend && (long)allCuboidCount <= Threshold1) {
            return null;
        }
        return recommendCuboidsWithStats;
    }

    private class CuboidRecommenderSyncListener
    extends Broadcaster.Listener {
        private CuboidRecommenderSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            cuboidRecommendCache.invalidateAll();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            cuboidRecommendCache.invalidate((Object)cacheKey);
        }
    }
}

