/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HiveCmdBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HiveCmdBuilder.class);
    public static final String HIVE_CONF_FILENAME = "kylin_hive_conf";
    private HiveClientMode clientMode;
    private KylinConfig kylinConfig;
    private final Map<String, String> hiveConfProps = new HashMap<String, String>();
    private final ArrayList<String> statements = Lists.newArrayList();

    public HiveCmdBuilder() {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.clientMode = HiveClientMode.valueOf(this.kylinConfig.getHiveClientMode().toUpperCase());
        this.loadHiveConfiguration();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String build() {
        StringBuffer buf = new StringBuffer();
        switch (this.clientMode) {
            case CLI: {
                buf.append("hive -e \"");
                Iterator<String> i$ = this.statements.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        buf.append("\"");
                        buf.append(this.parseProps());
                        return buf.toString();
                    }
                    String statement = i$.next();
                    buf.append(statement).append("\n");
                }
            }
            case BEELINE: {
                BufferedWriter bw = null;
                File tmpHql = null;
                try {
                    tmpHql = File.createTempFile("beeline_", ".hql");
                    bw = new BufferedWriter(new FileWriter(tmpHql));
                    for (String statement : this.statements) {
                        bw.write(statement);
                        bw.newLine();
                    }
                    buf.append("beeline ");
                    buf.append(this.kylinConfig.getHiveBeelineParams());
                    buf.append(this.parseProps());
                    buf.append(" -f ");
                    buf.append(tmpHql.getAbsolutePath());
                    buf.append(";ret_code=$?;rm -f ");
                    buf.append(tmpHql.getAbsolutePath());
                    buf.append(";exit $ret_code");
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bw);
                        if (tmpHql == null) throw throwable;
                        if (!logger.isDebugEnabled()) throw throwable;
                        String hql2 = null;
                        try {
                            hql2 = FileUtils.readFileToString((File)tmpHql, (Charset)Charset.defaultCharset());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        logger.debug("The SQL to execute in beeline: \n" + hql2);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)bw);
                if (tmpHql == null) return buf.toString();
                if (!logger.isDebugEnabled()) return buf.toString();
                String hql = null;
                try {
                    hql = FileUtils.readFileToString((File)tmpHql, (Charset)Charset.defaultCharset());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                logger.debug("The SQL to execute in beeline: \n" + hql);
                return buf.toString();
            }
        }
        throw new RuntimeException("Hive client cannot be recognized: " + (Object)((Object)this.clientMode));
    }

    private String parseProps() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, String> prop : this.hiveConfProps.entrySet()) {
            s.append(" --hiveconf ");
            s.append(prop.getKey());
            s.append("=");
            s.append(prop.getValue());
        }
        return s.toString();
    }

    public void reset() {
        this.statements.clear();
        this.hiveConfProps.clear();
    }

    public void setHiveConfProps(Map<String, String> hiveConfProps) {
        this.hiveConfProps.clear();
        this.hiveConfProps.putAll(hiveConfProps);
    }

    public void overwriteHiveProps(Map<String, String> overwrites) {
        this.hiveConfProps.putAll(overwrites);
    }

    public void addStatement(String statement) {
        this.statements.add(statement);
    }

    public void addStatements(String[] stats) {
        for (String s : stats) {
            this.statements.add(s);
        }
    }

    public String toString() {
        return this.build();
    }

    private void loadHiveConfiguration() {
        File hiveConfFile;
        String hiveConfFileName = "kylin_hive_conf.xml";
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty((String)path)) {
            hiveConfFile = new File(path, hiveConfFileName);
        } else {
            path = KylinConfig.getKylinHome();
            if (StringUtils.isEmpty((String)path)) {
                logger.error("KYLIN_HOME is not set, can not locate hive conf: {}.xml", (Object)HIVE_CONF_FILENAME);
                return;
            }
            hiveConfFile = new File(path + File.separator + "conf", hiveConfFileName);
        }
        if (hiveConfFile == null || !hiveConfFile.exists()) {
            throw new RuntimeException("Failed to read kylin_hive_conf.xml");
        }
        String fileUrl = OptionsHelper.convertToFileURL(hiveConfFile.getAbsolutePath());
        try {
            File file = new File(fileUrl);
            if (file.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(file);
                NodeList nl = doc.getElementsByTagName("property");
                this.hiveConfProps.clear();
                for (int i = 0; i < nl.getLength(); ++i) {
                    String key = doc.getElementsByTagName("name").item(i).getFirstChild().getNodeValue();
                    String value = doc.getElementsByTagName("value").item(i).getFirstChild().getNodeValue();
                    if (key.equals("tmpjars")) continue;
                    this.hiveConfProps.put(key, value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse hive conf file ", e);
        }
    }

    public static enum HiveClientMode {
        CLI,
        BEELINE;

    }
}

