/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;

public class KylinVersion
implements Comparable {
    private static final String COMMIT_SHA1_v15 = "commit_SHA1";
    private static final String COMMIT_SHA1_v13 = "commit.sha1";
    public final int major;
    public final int minor;
    public final int revision;
    public final int internal;
    public final boolean isSnapshot;
    private static final KylinVersion CURRENT_KYLIN_VERSION = new KylinVersion("2.2.0");
    private static final KylinVersion VERSION_200 = new KylinVersion("2.0.0");
    private static final Set<KylinVersion> SIGNATURE_INCOMPATIBLE_REVISIONS = new HashSet<KylinVersion>();

    public KylinVersion(String version) {
        String[] splits;
        Preconditions.checkNotNull((Object)version);
        int index = version.indexOf("-");
        if (index == -1) {
            splits = version.split("\\.");
            this.isSnapshot = false;
        } else {
            splits = version.substring(0, index).split("\\.");
            this.isSnapshot = true;
        }
        this.major = Integer.parseInt(splits[0]);
        this.minor = Integer.parseInt(splits[1]);
        this.revision = splits.length > 2 ? Integer.parseInt(splits[2]) : 0;
        this.internal = splits.length > 3 ? Integer.parseInt(splits[3]) : 0;
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.revision + "." + this.internal + (this.isSnapshot ? "-SNAPSHOT" : "");
    }

    public int compareTo(Object o) {
        KylinVersion v = (KylinVersion)o;
        int comp = this.major - v.major;
        if (comp != 0) {
            return comp;
        }
        comp = this.minor - v.minor;
        if (comp != 0) {
            return comp;
        }
        comp = this.revision - v.revision;
        if (comp != 0) {
            return comp;
        }
        comp = this.internal - v.internal;
        if (comp != 0) {
            return comp;
        }
        return (this.isSnapshot ? 0 : 1) - (v.isSnapshot ? 0 : 1);
    }

    public static KylinVersion getCurrentVersion() {
        return CURRENT_KYLIN_VERSION;
    }

    public static boolean isBefore200(String ver) {
        return new KylinVersion(ver).compareTo(VERSION_200) < 0;
    }

    public static int compare(String v1, String v2) {
        return new KylinVersion(v1).compareTo(new KylinVersion(v2));
    }

    public static void main(String[] args) {
        System.out.println(KylinVersion.getKylinClientInformation());
    }

    public boolean isCompatibleWith(KylinVersion v) {
        KylinVersion current = CURRENT_KYLIN_VERSION;
        return current.major == v.major && current.minor == v.minor;
    }

    public boolean isSignatureCompatibleWith(final KylinVersion v) {
        if (!this.isCompatibleWith(v)) {
            return false;
        }
        if (v.isSnapshot || this.isSnapshot) {
            return false;
        }
        boolean signatureIncompatible = Iterables.any((Iterable)Iterables.filter(SIGNATURE_INCOMPATIBLE_REVISIONS, (Predicate)new Predicate<KylinVersion>(){

            public boolean apply(@Nullable KylinVersion input) {
                return v.major == input.major && v.minor == input.minor;
            }
        }), (Predicate)new Predicate<KylinVersion>(){

            public boolean apply(@Nullable KylinVersion input) {
                return input.revision > v.revision;
            }
        });
        return !signatureIncompatible;
    }

    public static String getKylinClientInformation() {
        StringBuilder buf = new StringBuilder();
        buf.append("kylin.home: ").append(KylinConfig.getKylinHome() == null ? "UNKNOWN" : new File(KylinConfig.getKylinHome()).getAbsolutePath()).append("\n");
        buf.append("kylin.version:").append(KylinVersion.getCurrentVersion()).append("\n");
        buf.append("commit:").append(KylinVersion.getGitCommitInfo()).append("\n");
        buf.append("os.name:").append(System.getProperty("os.name")).append("\n");
        buf.append("os.arch:").append(System.getProperty("os.arch")).append("\n");
        buf.append("os.version:").append(System.getProperty("os.version")).append("\n");
        buf.append("java.version:").append(System.getProperty("java.version")).append("\n");
        buf.append("java.vendor:").append(System.getProperty("java.vendor"));
        return buf.toString();
    }

    public static String getGitCommitInfo() {
        try {
            File commitFile = new File(KylinConfig.getKylinHome(), COMMIT_SHA1_v15);
            if (!commitFile.exists()) {
                commitFile = new File(KylinConfig.getKylinHome(), COMMIT_SHA1_v13);
            }
            List lines = FileUtils.readLines((File)commitFile, (Charset)Charset.defaultCharset());
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                if (line.startsWith("#")) continue;
                sb.append(line).append(";");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        SIGNATURE_INCOMPATIBLE_REVISIONS.add(new KylinVersion("1.5.1"));
        SIGNATURE_INCOMPATIBLE_REVISIONS.add(new KylinVersion("1.6.1"));
    }
}

