/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.BackwardCompatibilityConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.ZooKeeperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KylinConfigBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfigBase.class);
    static BackwardCompatibilityConfig BCC = new BackwardCompatibilityConfig();
    volatile Properties properties = new Properties();
    private String cachedHdfsWorkingDirectory;
    private static final Pattern COPROCESSOR_JAR_NAME_PATTERN = Pattern.compile("kylin-coprocessor-(.+)\\.jar");
    private static final Pattern JOB_JAR_NAME_PATTERN = Pattern.compile("kylin-job-(.+)\\.jar");

    public static String getKylinHome() {
        String kylinHome = System.getenv("KYLIN_HOME");
        if (StringUtils.isEmpty((String)kylinHome)) {
            kylinHome = System.getProperty("KYLIN_HOME");
        }
        if (StringUtils.isEmpty((String)kylinHome)) {
            logger.warn("KYLIN_HOME was not set");
        }
        return kylinHome;
    }

    public static String getSparkHome() {
        String sparkHome = System.getenv("SPARK_HOME");
        if (StringUtils.isNotEmpty((String)sparkHome)) {
            logger.info("SPARK_HOME was set to " + sparkHome);
            return sparkHome;
        }
        sparkHome = System.getProperty("SPARK_HOME");
        if (StringUtils.isNotEmpty((String)sparkHome)) {
            logger.info("SPARK_HOME was set to " + sparkHome);
            return sparkHome;
        }
        return KylinConfigBase.getKylinHome() + File.separator + "spark";
    }

    public KylinConfigBase() {
        this(new Properties());
    }

    public KylinConfigBase(Properties props) {
        this.properties = BCC.check(props);
    }

    protected KylinConfigBase(Properties props, boolean force) {
        this.properties = force ? props : BCC.check(props);
    }

    protected final String getOptional(String prop) {
        return this.getOptional(prop, null);
    }

    protected String getOptional(String prop, String dft) {
        String property = System.getProperty(prop);
        return property != null ? property : this.properties.getProperty(prop, dft);
    }

    protected Properties getAllProperties() {
        return this.properties;
    }

    protected final Map<String, String> getPropertiesByPrefix(String prefix) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : this.getAllProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }

    protected final String[] getOptionalStringArray(String prop, String[] dft) {
        String property = this.getOptional(prop);
        if (!StringUtils.isBlank((String)property)) {
            return property.split("\\s*,\\s*");
        }
        return dft;
    }

    protected final int[] getOptionalIntArray(String prop, String[] dft) {
        String[] strArray = this.getOptionalStringArray(prop, dft);
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }

    protected final String getRequired(String prop) {
        String r = this.getOptional(prop);
        if (StringUtils.isEmpty((String)r)) {
            throw new IllegalArgumentException("missing '" + prop + "' in conf/kylin.properties");
        }
        return r;
    }

    public final void setProperty(String key, String value) {
        logger.info("Kylin Config was updated with " + key + " : " + value);
        this.properties.setProperty(BCC.check(key), value);
    }

    protected final void reloadKylinConfig(Properties properties) {
        this.properties = BCC.check(properties);
    }

    private Map<Integer, String> convertKeyToInteger(Map<String, String> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(Integer.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public String toString() {
        return this.getMetadataUrl().toString();
    }

    public boolean isDevEnv() {
        return "DEV".equals(this.getOptional("kylin.env", "DEV"));
    }

    public String getDeployEnv() {
        return this.getOptional("kylin.env", "DEV");
    }

    public String getHdfsWorkingDirectory() {
        if (this.cachedHdfsWorkingDirectory != null) {
            return this.cachedHdfsWorkingDirectory;
        }
        String root = this.getOptional("kylin.env.hdfs-working-dir", "/kylin");
        Path path = new Path(root);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-working-dir must be absolute, but got " + root);
        }
        try {
            FileSystem fs = path.getFileSystem(HadoopUtil.getCurrentConfiguration());
            path = fs.makeQualified(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        root = new Path(path, StringUtils.replaceChars((String)this.getMetadataUrlPrefix(), (char)':', (char)'-')).toString();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        this.cachedHdfsWorkingDirectory = root;
        if (this.cachedHdfsWorkingDirectory.startsWith("file:")) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace("file:", "file://");
        } else if (this.cachedHdfsWorkingDirectory.startsWith("maprfs:")) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace("maprfs:", "maprfs://");
        }
        return this.cachedHdfsWorkingDirectory;
    }

    public String getZookeeperBasePath() {
        return this.getOptional("kylin.env.zookeeper-base-path", "/kylin");
    }

    public String getZookeeperConnectString() {
        String str = this.getOptional("kylin.env.zookeeper-connect-string");
        if (str != null) {
            return str;
        }
        str = ZooKeeperUtil.getZKConnectStringFromHBase();
        if (str != null) {
            return str;
        }
        throw new RuntimeException("Please set 'kylin.env.zookeeper-connect-string' in kylin.properties");
    }

    public StorageURL getMetadataUrl() {
        return StorageURL.valueOf(this.getOptional("kylin.metadata.url", "kylin_metadata@hbase"));
    }

    public int getCacheSyncRetrys() {
        return Integer.parseInt(this.getOptional("kylin.metadata.sync-retries", "3"));
    }

    public void setMetadataUrl(String metadataUrl) {
        this.setProperty("kylin.metadata.url", metadataUrl);
    }

    public String getMetadataUrlPrefix() {
        return this.getMetadataUrl().getIdentifier();
    }

    public Map<String, String> getResourceStoreImpls() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put("", "org.apache.kylin.common.persistence.FileResourceStore");
        r.put("hbase", "org.apache.kylin.storage.hbase.HBaseResourceStore");
        r.put("hdfs", "org.apache.kylin.storage.hdfs.HDFSResourceStore");
        r.put("ifile", "org.apache.kylin.storage.hdfs.IdentifierFileResourceStore");
        r.putAll(this.getPropertiesByPrefix("kylin.metadata.resource-store-provider."));
        return r;
    }

    public String[] getRealizationProviders() {
        return this.getOptionalStringArray("kylin.metadata.realization-providers", new String[]{"org.apache.kylin.cube.CubeManager", "org.apache.kylin.storage.hybrid.HybridManager"});
    }

    public String[] getCubeDimensionCustomEncodingFactories() {
        return this.getOptionalStringArray("kylin.metadata.custom-dimension-encodings", new String[0]);
    }

    public Map<String, String> getCubeCustomMeasureTypes() {
        return this.getPropertiesByPrefix("kylin.metadata.custom-measure-types.");
    }

    public DistributedLockFactory getDistributedLockFactory() {
        String clsName = this.getOptional("kylin.metadata.distributed-lock-impl", "org.apache.kylin.storage.hbase.util.ZookeeperDistributedLock$Factory");
        return (DistributedLockFactory)ClassUtil.newInstance(clsName);
    }

    public String getHBaseMappingAdapter() {
        return this.getOptional("kylin.metadata.hbasemapping-adapter");
    }

    public boolean isUseForestTrieDictionary() {
        return Boolean.parseBoolean(this.getOptional("kylin.dictionary.use-forest-trie", "true"));
    }

    public int getTrieDictionaryForestMaxTrieSizeMB() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.forest-trie-max-mb", "500"));
    }

    public int getCachedDictMaxEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.max-cache-entry", "3000"));
    }

    public boolean isGrowingDictEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.dictionary.growing-enabled", "false"));
    }

    public int getAppendDictEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.append-entry-size", "10000000"));
    }

    public int getAppendDictMaxVersions() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.append-max-versions", "3"));
    }

    public int getAppendDictVersionTTL() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.append-version-ttl", "259200000"));
    }

    public int getCachedSnapshotMaxEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.max-cache-entry", "500"));
    }

    public int getTableSnapshotMaxMB() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.max-mb", "300"));
    }

    public String getCuboidScheduler() {
        return this.getOptional("kylin.cube.cuboid-scheduler", "org.apache.kylin.cube.cuboid.DefaultCuboidScheduler");
    }

    public String getSegmentAdvisor() {
        return this.getOptional("kylin.cube.segment-advisor", "org.apache.kylin.cube.CubeSegmentAdvisor");
    }

    public double getJobCuboidSizeRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-ratio", "0.25"));
    }

    @Deprecated
    public double getJobCuboidSizeMemHungryRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-memhungry-ratio", "0.05"));
    }

    public double getJobCuboidSizeCountDistinctRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-countdistinct-ratio", "0.05"));
    }

    public String getCubeAlgorithm() {
        return this.getOptional("kylin.cube.algorithm", "auto");
    }

    public double getCubeAlgorithmAutoThreshold() {
        return Double.parseDouble(this.getOptional("kylin.cube.algorithm.layer-or-inmem-threshold", "7"));
    }

    public int getCubeAlgorithmAutoMapperLimit() {
        return Integer.parseInt(this.getOptional("kylin.cube.algorithm.inmem-split-limit", "500"));
    }

    public int getCubeAlgorithmInMemConcurrentThreads() {
        return Integer.parseInt(this.getOptional("kylin.cube.algorithm.inmem-concurrent-threads", "1"));
    }

    public boolean isIgnoreCubeSignatureInconsistency() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.ignore-signature-inconsistency", "false"));
    }

    public long getCubeAggrGroupMaxCombination() {
        return Long.parseLong(this.getOptional("kylin.cube.aggrgroup.max-combination", "4096"));
    }

    public boolean getCubeAggrGroupIsMandatoryOnlyValid() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.aggrgroup.is-mandatory-only-valid", "false"));
    }

    public int getCubeRowkeyMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.cube.rowkey.max-size", "63"));
    }

    public int getMaxBuildingSegments() {
        return Integer.parseInt(this.getOptional("kylin.cube.max-building-segments", "10"));
    }

    public boolean allowCubeAppearInMultipleProjects() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.allow-appear-in-multiple-projects", "false"));
    }

    public int getGTScanRequestSerializationLevel() {
        return Integer.parseInt(this.getOptional("kylin.cube.gtscanrequest-serialization-level", "1"));
    }

    public boolean isCubePlannerEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.cubeplanner.enabled", "false"));
    }

    public boolean isCubePlannerEnabledForExistingCube() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.cubeplanner.enabled-for-existing-cube", "false"));
    }

    public double getCubePlannerExpansionRateThreshold() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.expansion-threshold", "15.0"));
    }

    public int getCubePlannerRecommendCuboidCacheMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.recommend-cache-max-size", "200"));
    }

    public long getCubePlannerMandatoryRollUpThreshold() {
        return Long.parseLong(this.getOptional("kylin.cube.cubeplanner.mandatory-rollup-threshold", "1000"));
    }

    public int getCubePlannerAgreedyAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.algorithm-threshold-greedy", "10"));
    }

    public int getCubePlannerGeneticAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.algorithm-threshold-genetic", "23"));
    }

    public CliCommandExecutor getCliCommandExecutor() throws IOException {
        CliCommandExecutor exec = new CliCommandExecutor();
        if (this.getRunAsRemoteCommand()) {
            exec.setRunAtRemote(this.getRemoteHadoopCliHostname(), this.getRemoteHadoopCliPort(), this.getRemoteHadoopCliUsername(), this.getRemoteHadoopCliPassword());
        }
        return exec;
    }

    public String getKylinJobLogDir() {
        return this.getOptional("kylin.job.log-dir", "/tmp/kylin/logs");
    }

    public boolean getRunAsRemoteCommand() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-remote-cli"));
    }

    public int getRemoteHadoopCliPort() {
        return Integer.parseInt(this.getOptional("kylin.job.remote-cli-port", "22"));
    }

    public String getRemoteHadoopCliHostname() {
        return this.getOptional("kylin.job.remote-cli-hostname");
    }

    public String getRemoteHadoopCliUsername() {
        return this.getOptional("kylin.job.remote-cli-username");
    }

    public String getRemoteHadoopCliPassword() {
        return this.getOptional("kylin.job.remote-cli-password");
    }

    public String getCliWorkingDir() {
        return this.getOptional("kylin.job.remote-cli-working-dir");
    }

    public boolean isEmptySegmentAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.allow-empty-segment", "true"));
    }

    public int getMaxConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.job.max-concurrent-jobs", "10"));
    }

    public int getCubingInMemSamplingPercent() {
        int percent = Integer.parseInt(this.getOptional("kylin.job.sampling-percentage", "100"));
        percent = Math.max(percent, 1);
        percent = Math.min(percent, 100);
        return percent;
    }

    public String getHiveDependencyFilterList() {
        return this.getOptional("kylin.job.dependency-filter-list", "[^,]*hive-exec[^,]*?\\.jar|[^,]*hive-metastore[^,]*?\\.jar|[^,]*hive-hcatalog-core[^,]*?\\.jar");
    }

    public boolean isMailEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-enabled", "false"));
    }

    public boolean isStarttlsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-mail-enable-starttls", "false"));
    }

    public String getSmtpPort() {
        return this.getOptional("kylin.job.notification-mail-port", "25");
    }

    public String getMailHost() {
        return this.getOptional("kylin.job.notification-mail-host", "");
    }

    public String getMailUsername() {
        return this.getOptional("kylin.job.notification-mail-username", "");
    }

    public String getMailPassword() {
        return this.getOptional("kylin.job.notification-mail-password", "");
    }

    public String getMailSender() {
        return this.getOptional("kylin.job.notification-mail-sender", "");
    }

    public String[] getAdminDls() {
        return this.getOptionalStringArray("kylin.job.notification-admin-emails", null);
    }

    public int getJobRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.retry", "0"));
    }

    public int getCubeStatsHLLPrecision() {
        return Integer.parseInt(this.getOptional("kylin.job.sampling-hll-precision", "14"));
    }

    public String getJobControllerLock() {
        return this.getOptional("kylin.job.lock", "org.apache.kylin.storage.hbase.util.ZookeeperJobLock");
    }

    public Map<Integer, String> getSchedulers() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.job.impl.threadpool.DefaultScheduler");
        r.put(2, "org.apache.kylin.job.impl.threadpool.DistributedScheduler");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.job.scheduler.provider.")));
        return r;
    }

    public Integer getSchedulerType() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.default", "0"));
    }

    public Integer getSchedulerPollIntervalSecond() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.poll-interval-second", "30"));
    }

    public Integer getErrorRecordThreshold() {
        return Integer.parseInt(this.getOptional("kylin.job.error-record-threshold", "0"));
    }

    public boolean isAdvancedFlatTableUsed() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-advanced-flat-table", "false"));
    }

    public String getAdvancedFlatTableClass() {
        return this.getOptional("kylin.job.advanced-flat-table.class");
    }

    public String getJobTrackingURLPattern() {
        return this.getOptional("kylin.job.tracking-url-pattern", "");
    }

    public int getDefaultSource() {
        return Integer.parseInt(this.getOptional("kylin.source.default", "0"));
    }

    public Map<Integer, String> getSourceEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.source.hive.HiveSource");
        r.put(1, "org.apache.kylin.source.kafka.KafkaSource");
        r.put(8, "org.apache.kylin.source.jdbc.JdbcSource");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.source.provider.")));
        return r;
    }

    @Deprecated
    public String getHiveUrl() {
        return this.getOptional("kylin.source.hive.connection-url", "");
    }

    @Deprecated
    public String getHiveUser() {
        return this.getOptional("kylin.source.hive.connection-user", "");
    }

    @Deprecated
    public String getHivePassword() {
        return this.getOptional("kylin.source.hive.connection-password", "");
    }

    public Map<String, String> getHiveConfigOverride() {
        return this.getPropertiesByPrefix("kylin.source.hive.config-override.");
    }

    public String getOverrideHiveTableLocation(String table) {
        return this.getOptional("kylin.source.hive.table-location." + table.toUpperCase());
    }

    public boolean isHiveKeepFlatTable() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.keep-flat-table", "false"));
    }

    public String getHiveDatabaseForIntermediateTable() {
        return this.getOptional("kylin.source.hive.database-for-flat-table", "default");
    }

    public boolean isHiveRedistributeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.redistribute-flat-table", "true"));
    }

    public String getHiveClientMode() {
        return this.getOptional("kylin.source.hive.client", "cli");
    }

    public String getHiveBeelineParams() {
        return this.getOptional("kylin.source.hive.beeline-params", "");
    }

    public String getFlatHiveTableClusterByDictColumn() {
        return this.getOptional("kylin.source.hive.flat-table-cluster-by-dict-column");
    }

    public int getDefaultVarcharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-varchar-precision", "256"));
        if (v < 1) {
            return 256;
        }
        if (v > 65355) {
            return 65535;
        }
        return v;
    }

    public int getDefaultCharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-char-precision", "255"));
        if (v < 1) {
            return 255;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public int getDefaultDecimalPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-precision", "19"));
        if (v < 1) {
            return 19;
        }
        return v;
    }

    public int getDefaultDecimalScale() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-scale", "4"));
        if (v < 1) {
            return 4;
        }
        return v;
    }

    public Map<String, String> getKafkaConfigOverride() {
        return this.getPropertiesByPrefix("kylin.source.kafka.config-override.");
    }

    public String getJdbcConnectionUrl() {
        return this.getOptional("kylin.source.jdbc.connection-url");
    }

    public String getJdbcDriver() {
        return this.getOptional("kylin.source.jdbc.driver");
    }

    public String getJdbcDialect() {
        return this.getOptional("kylin.source.jdbc.dialect");
    }

    public String getJdbcUser() {
        return this.getOptional("kylin.source.jdbc.user");
    }

    public String getJdbcPass() {
        return this.getOptional("kylin.source.jdbc.pass");
    }

    public String getSqoopHome() {
        return this.getOptional("kylin.source.jdbc.sqoop-home");
    }

    public Map<Integer, String> getStorageEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.storage.hbase.HBaseStorage");
        r.put(1, "org.apache.kylin.storage.hybrid.HybridStorage");
        r.put(2, "org.apache.kylin.storage.hbase.HBaseStorage");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.storage.provider.")));
        return r;
    }

    public int getDefaultStorageEngine() {
        return Integer.parseInt(this.getOptional("kylin.storage.default", "2"));
    }

    public StorageURL getStorageUrl() {
        String url = this.getOptional("kylin.storage.url", "default@hbase");
        if ("hbase".equals(url)) {
            url = "default@hbase";
        }
        return StorageURL.valueOf(url);
    }

    public String getHBaseTableNamePrefix() {
        return this.getOptional("kylin.storage.hbase.table-name-prefix", "KYLIN_");
    }

    public String getHBaseClusterFs() {
        return this.getOptional("kylin.storage.hbase.cluster-fs", "");
    }

    public String getHBaseClusterHDFSConfigFile() {
        return this.getOptional("kylin.storage.hbase.cluster-hdfs-config-file", "");
    }

    public String getCoprocessorLocalJar() {
        String coprocessorJar = this.getOptional("kylin.storage.hbase.coprocessor-local-jar");
        if (StringUtils.isNotEmpty((String)coprocessorJar)) {
            return coprocessorJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            throw new RuntimeException("getCoprocessorLocalJar needs KYLIN_HOME");
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", COPROCESSOR_JAR_NAME_PATTERN);
    }

    public void overrideCoprocessorLocalJar(String path) {
        logger.info("override kylin.storage.hbase.coprocessor-local-jar to " + path);
        System.setProperty("kylin.storage.hbase.coprocessor-local-jar", path);
    }

    private static String getFileName(String homePath, Pattern pattern) {
        File[] listFiles;
        File home = new File(homePath);
        TreeSet files = Sets.newTreeSet();
        if (home.exists() && home.isDirectory() && (listFiles = home.listFiles()) != null) {
            for (File file : listFiles) {
                Matcher matcher = pattern.matcher(file.getName());
                if (!matcher.matches()) continue;
                files.add(file.getAbsolutePath());
            }
        }
        if (files.isEmpty()) {
            throw new RuntimeException("cannot find " + pattern.toString() + " in " + homePath);
        }
        return (String)files.last();
    }

    public int getHBaseRegionCountMin() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.min-region-count", "1"));
    }

    public int getHBaseRegionCountMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-region-count", "500"));
    }

    public float getHBaseHFileSizeGB() {
        return Float.parseFloat(this.getOptional("kylin.storage.hbase.hfile-size-gb", "2.0"));
    }

    public boolean getQueryRunLocalCoprocessor() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.hbase.run-local-coprocessor", "false"));
    }

    public double getQueryCoprocessorMemGB() {
        return Double.parseDouble(this.getOptional("kylin.storage.hbase.coprocessor-mem-gb", "3.0"));
    }

    public boolean getQueryCoprocessorSpillEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.partition.aggr-spill-enabled", "true"));
    }

    public long getPartitionMaxScanBytes() {
        long value = Long.parseLong(this.getOptional("kylin.storage.partition.max-scan-bytes", String.valueOf(0xC0000000L)));
        return value > 0L ? value : Long.MAX_VALUE;
    }

    public int getQueryCoprocessorTimeoutSeconds() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.coprocessor-timeout-seconds", "0"));
    }

    public int getQueryScanFuzzyKeyMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-fuzzykey-scan", "200"));
    }

    public int getQueryStorageVisitScanRangeMax() {
        return Integer.valueOf(this.getOptional("kylin.storage.hbase.max-visit-scanrange", "1000000"));
    }

    public String getDefaultIGTStorage() {
        return this.getOptional("kylin.storage.hbase.gtstorage", "org.apache.kylin.storage.hbase.cube.v2.CubeHBaseEndpointRPC");
    }

    public int getHBaseScanCacheRows() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.scan-cache-rows", "1024"));
    }

    public float getKylinHBaseRegionCut() {
        return Float.valueOf(this.getOptional("kylin.storage.hbase.region-cut-gb", "5.0")).floatValue();
    }

    public int getHBaseScanMaxResultSize() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-scan-result-bytes", "5242880"));
    }

    public String getHbaseDefaultCompressionCodec() {
        return this.getOptional("kylin.storage.hbase.compression-codec", "none");
    }

    public String getHbaseDefaultEncoding() {
        return this.getOptional("kylin.storage.hbase.rowkey-encoding", "FAST_DIFF");
    }

    public int getHbaseDefaultBlockSize() {
        return Integer.valueOf(this.getOptional("kylin.storage.hbase.block-size-bytes", "1048576"));
    }

    public int getHbaseSmallFamilyBlockSize() {
        return Integer.valueOf(this.getOptional("kylin.storage.hbase.small-family-block-size-bytes", "65536"));
    }

    public String getKylinOwner() {
        return this.getOptional("kylin.storage.hbase.owner-tag", "");
    }

    public boolean getCompressionResult() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.hbase.endpoint-compress-result", "true"));
    }

    public int getHBaseMaxConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-hconnection-threads", "2048"));
    }

    public int getHBaseCoreConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.core-hconnection-threads", "2048"));
    }

    public long getHBaseConnectionThreadPoolAliveSeconds() {
        return Long.parseLong(this.getOptional("kylin.storage.hbase.hconnection-threads-alive-seconds", "60"));
    }

    public Map<Integer, String> getJobEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.engine.mr.MRBatchCubingEngine");
        r.put(2, "org.apache.kylin.engine.mr.MRBatchCubingEngine2");
        r.put(4, "org.apache.kylin.engine.spark.SparkBatchCubingEngine2");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.engine.provider.")));
        return r;
    }

    public int getDefaultCubeEngine() {
        return Integer.parseInt(this.getOptional("kylin.engine.default", "2"));
    }

    public String getKylinJobJarPath() {
        String jobJar = this.getOptional("kylin.engine.mr.job-jar");
        if (StringUtils.isNotEmpty((String)jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            return "";
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", JOB_JAR_NAME_PATTERN);
    }

    public void overrideMRJobJarPath(String path) {
        logger.info("override kylin.engine.mr.job-jar to " + path);
        System.setProperty("kylin.engine.mr.job-jar", path);
    }

    public String getKylinJobMRLibDir() {
        return this.getOptional("kylin.engine.mr.lib-dir", "");
    }

    public Map<String, String> getMRConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.mr.config-override.");
    }

    public Map<String, String> getSparkConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.spark-conf.");
    }

    public double getDefaultHadoopJobReducerInputMB() {
        return Double.parseDouble(this.getOptional("kylin.engine.mr.reduce-input-mb", "500"));
    }

    public double getDefaultHadoopJobReducerCountRatio() {
        return Double.parseDouble(this.getOptional("kylin.engine.mr.reduce-count-ratio", "1.0"));
    }

    public int getHadoopJobMinReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.min-reducer-number", "1"));
    }

    public int getHadoopJobMaxReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.max-reducer-number", "500"));
    }

    public int getHadoopJobMapperInputRows() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.mapper-input-rows", "1000000"));
    }

    public int getUHCReducerCount() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.uhc-reducer-count", "1"));
    }

    public boolean isBuildDictInReducerEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.mr.build-dict-in-reducer", "true"));
    }

    public String getYarnStatusCheckUrl() {
        return this.getOptional("kylin.engine.mr.yarn-check-status-url", null);
    }

    public int getYarnStatusCheckIntervalSeconds() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.yarn-check-interval-seconds", "10"));
    }

    public String getHadoopConfDir() {
        return this.getOptional("kylin.env.hadoop-conf-dir", "");
    }

    public String getSparkAdditionalJars() {
        return this.getOptional("kylin.engine.spark.additional-jars", "");
    }

    public float getSparkRDDPartitionCutMB() {
        return Float.valueOf(this.getOptional("kylin.engine.spark.rdd-partition-cut-mb", "10.0")).floatValue();
    }

    public int getSparkMinPartition() {
        return Integer.valueOf(this.getOptional("kylin.engine.spark.min-partition", "1"));
    }

    public int getSparkMaxPartition() {
        return Integer.valueOf(this.getOptional("kylin.engine.spark.max-partition", "5000"));
    }

    public boolean isSparkSanityCheckEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark.sanity-check-enabled", "false"));
    }

    public boolean isSkippingEmptySegments() {
        return Boolean.valueOf(this.getOptional("kylin.query.skip-empty-segments", "true"));
    }

    public boolean isDisableCubeNoAggSQL() {
        return Boolean.valueOf(this.getOptional("kylin.query.disable-cube-noagg-sql", "false"));
    }

    public boolean isStreamAggregateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.stream-aggregate-enabled", "true"));
    }

    @Deprecated
    public int getStoragePushDownLimitMax() {
        return Integer.parseInt(this.getOptional("kylin.query.max-limit-pushdown", "10000"));
    }

    public int getForceLimit() {
        return Integer.parseInt(this.getOptional("kylin.query.force-limit", "-1"));
    }

    @Deprecated
    public int getScanThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.scan-threshold", "10000000"));
    }

    public long getQueryMaxScanBytes() {
        long value = Long.parseLong(this.getOptional("kylin.query.max-scan-bytes", "0"));
        return value > 0L ? value : Long.MAX_VALUE;
    }

    public int getTranslatedInClauseMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.query.translated-in-clause-max-size", String.valueOf(0x100000)));
    }

    public int getLargeQueryThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.large-query-threshold", String.valueOf(1000000)));
    }

    public int getDerivedInThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.derived-filter-translation-threshold", "20"));
    }

    public int getBadQueryStackTraceDepth() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-stacktrace-depth", "10"));
    }

    public int getBadQueryHistoryNum() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-history-number", "50"));
    }

    public int getBadQueryDefaultAlertingSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-alerting-seconds", "90"));
    }

    public int getBadQueryDefaultDetectIntervalSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-detect-interval", "60"));
    }

    public boolean getBadQueryPersistentEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.badquery-persistent-enabled", "true"));
    }

    public String[] getQueryTransformers() {
        return this.getOptionalStringArray("kylin.query.transformers", new String[0]);
    }

    public String[] getQueryInterceptors() {
        return this.getOptionalStringArray("kylin.query.interceptors", new String[0]);
    }

    public long getQueryDurationCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-duration", String.valueOf(2000)));
    }

    public long getQueryScanCountCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-count", String.valueOf(10240)));
    }

    public long getQueryScanBytesCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-bytes", String.valueOf(0x100000)));
    }

    public boolean isQuerySecureEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.security-enabled", "true"));
    }

    public boolean isQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.cache-enabled", "true"));
    }

    public boolean isQueryIgnoreUnknownFunction() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.ignore-unknown-function", "false"));
    }

    public String getQueryAccessController() {
        return this.getOptional("kylin.query.access-controller", null);
    }

    public int getDimCountDistinctMaxCardinality() {
        return Integer.parseInt(this.getOptional("kylin.query.max-dimension-count-distinct", "5000000"));
    }

    public Map<String, String> getUDFs() {
        LinkedHashMap udfMap = Maps.newLinkedHashMap();
        udfMap.put("version", "org.apache.kylin.query.udf.VersionUDF");
        udfMap.put("concat", "org.apache.kylin.query.udf.ConcatUDF");
        udfMap.put("massin", "org.apache.kylin.query.udf.MassInUDF");
        Map<String, String> overrideUdfMap = this.getPropertiesByPrefix("kylin.query.udf.");
        udfMap.putAll(overrideUdfMap);
        return udfMap;
    }

    public int getQueryTimeoutSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.timeout-seconds", "0"));
    }

    public boolean isPushDownEnabled() {
        return StringUtils.isNotEmpty((String)this.getPushDownRunnerClassName());
    }

    public boolean isPushDownUpdateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.update-enabled", "false"));
    }

    public String getPushDownRunnerClassName() {
        return this.getOptional("kylin.query.pushdown.runner-class-name", "");
    }

    public String[] getPushDownConverterClassNames() {
        return this.getOptionalStringArray("kylin.query.pushdown.converter-class-names", new String[]{"org.apache.kylin.source.adhocquery.HivePushDownConverter"});
    }

    public boolean isPushdownQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.cache-enabled", "false"));
    }

    public String getJdbcUrl() {
        return this.getOptional("kylin.query.pushdown.jdbc.url", "");
    }

    public String getJdbcDriverClass() {
        return this.getOptional("kylin.query.pushdown.jdbc.driver", "");
    }

    public String getJdbcUsername() {
        return this.getOptional("kylin.query.pushdown.jdbc.username", "");
    }

    public String getJdbcPassword() {
        return this.getOptional("kylin.query.pushdown.jdbc.password", "");
    }

    public int getPoolMaxTotal() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-total", "8"));
    }

    public int getPoolMaxIdle() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-idle", "8"));
    }

    public int getPoolMinIdle() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-min-idle", "0"));
    }

    public boolean isTableACLEnabled() {
        return Boolean.valueOf(this.getOptional("kylin.query.security.table-acl-enabled", "true"));
    }

    public boolean isEscapeDefaultKeywordEnabled() {
        return Boolean.valueOf(this.getOptional("kylin.query.escape-default-keyword", "false"));
    }

    public String getServerMode() {
        return this.getOptional("kylin.server.mode", "all");
    }

    public String[] getRestServers() {
        return this.getOptionalStringArray("kylin.server.cluster-servers", new String[0]);
    }

    public String getClusterName() {
        return this.getOptional("kylin.server.cluster-name", this.getMetadataUrlPrefix());
    }

    public String getInitTasks() {
        return this.getOptional("kylin.server.init-tasks");
    }

    public int getWorkersPerServer() {
        return Integer.parseInt(this.getOptional("kylin.server.sequence-sql.workers-per-server", "1"));
    }

    public long getSequenceExpireTime() {
        return Long.valueOf(this.getOptional("kylin.server.sequence-sql.expire-time", "86400000"));
    }

    public boolean getQueryMetricsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.query-metrics-enabled", "false"));
    }

    public boolean getQueryMetrics2Enabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.query-metrics2-enabled", "false"));
    }

    public int[] getQueryMetricsPercentilesIntervals() {
        String[] dft = new String[]{"60", "300", "3600"};
        return this.getOptionalIntArray("kylin.server.query-metrics-percentiles-intervals", dft);
    }

    public int getServerUserCacheExpireSeconds() {
        return Integer.valueOf(this.getOptional("kylin.server.auth-user-cache.expire-seconds", "300"));
    }

    public int getServerUserCacheMaxEntries() {
        return Integer.valueOf(this.getOptional("kylin.server.auth-user-cache.max-entries", "100"));
    }

    public String getExternalAclProvider() {
        return this.getOptional("kylin.server.external-acl-provider", "");
    }

    public String getTimeZone() {
        return this.getOptional("kylin.web.timezone", "PST");
    }

    public boolean isWebCrossDomainEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.cross-domain-enabled", "true"));
    }

    public int getRestClientDefaultMaxPerRoute() {
        return Integer.valueOf(this.getOptional("kylin.restclient.connection.default-max-per-route", "20"));
    }

    public int getRestClientMaxTotal() {
        return Integer.valueOf(this.getOptional("kylin.restclient.connection.max-total", "200"));
    }

    public String getCoadhaleMetricsReportClassesNames() {
        return this.getOptional("kylin.metrics.reporter-classes", "org.apache.kylin.common.metrics.metrics2.JsonFileMetricsReporter,org.apache.kylin.common.metrics.metrics2.JmxMetricsReporter");
    }

    public String getMetricsFileLocation() {
        return this.getOptional("kylin.metrics.file-location", "/tmp/report.json");
    }

    public Long getMetricsReporterFrequency() {
        return Long.parseLong(this.getOptional("kylin.metrics.file-frequency", "5000"));
    }

    public String getPerfLoggerClassName() {
        return this.getOptional("kylin.metrics.perflogger-class", "org.apache.kylin.common.metrics.perflog.PerfLogger");
    }
}

