/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinConfigCannotInitException;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.OrderedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfig
extends KylinConfigBase {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfig.class);
    public static final String KYLIN_CONF_PROPERTIES_FILE = "kylin.properties";
    public static final String KYLIN_CONF = "KYLIN_CONF";
    private static KylinConfig SYS_ENV_INSTANCE = null;
    private static transient ThreadLocal<KylinConfig> THREAD_ENV_INSTANCE = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KylinConfig getInstanceFromEnv() {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            KylinConfig config = THREAD_ENV_INSTANCE.get();
            if (config != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return config;
            }
            if (SYS_ENV_INSTANCE == null) {
                try {
                    config = new KylinConfig();
                    config.reloadKylinConfig(KylinConfig.buildSiteProperties());
                    logger.info("Initialized a new KylinConfig from getInstanceFromEnv : " + System.identityHashCode(config));
                    SYS_ENV_INSTANCE = config;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to find KylinConfig ", e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SYS_ENV_INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyInstance() {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            logger.info("Destroy KylinConfig");
            KylinConfig.dumpStackTrace();
            SYS_ENV_INSTANCE = null;
            THREAD_ENV_INSTANCE = new ThreadLocal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void dumpStackTrace() {
    }

    private static UriType decideUriType(String metaUri) {
        try {
            File file = new File(metaUri);
            if (file.exists() || metaUri.contains("/")) {
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.isDirectory()) {
                    return UriType.LOCAL_FOLDER;
                }
                if (file.isFile()) {
                    if (file.getName().equalsIgnoreCase(KYLIN_CONF_PROPERTIES_FILE)) {
                        return UriType.PROPERTIES_FILE;
                    }
                    throw new IllegalStateException("Metadata uri : " + metaUri + " is a local file but not kylin.properties");
                }
                throw new IllegalStateException("Metadata uri : " + metaUri + " looks like a file but it's neither a file nor a directory");
            }
            if (RestClient.matchFullRestPattern(metaUri)) {
                return UriType.REST_ADDR;
            }
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not a valid REST URI address");
        }
        catch (Exception e) {
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not recognized", e);
        }
    }

    public static KylinConfig createInstanceFromUri(String uri) {
        UriType uriType = KylinConfig.decideUriType(uri);
        if (uriType == UriType.LOCAL_FOLDER) {
            KylinConfig config = new KylinConfig();
            config.setMetadataUrl(uri);
            return config;
        }
        if (uriType == UriType.PROPERTIES_FILE) {
            KylinConfig config;
            try {
                config = new KylinConfig();
                FileInputStream is = new FileInputStream(uri);
                Properties prop = KylinConfig.streamToProps(is);
                config.reloadKylinConfig(prop);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return config;
        }
        try {
            KylinConfig config = new KylinConfig();
            RestClient client = new RestClient(uri);
            String propertyText = client.getKylinProperties();
            InputStream is = IOUtils.toInputStream((String)propertyText, (Charset)Charset.defaultCharset());
            Properties prop = KylinConfig.streamToProps(is);
            config.reloadKylinConfig(prop);
            return config;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Properties streamToProps(InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        IOUtils.closeQuietly((InputStream)is);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKylinConfigInEnvIfMissing(Properties prop) {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (SYS_ENV_INSTANCE == null) {
                try {
                    KylinConfig config = new KylinConfig();
                    config.reloadKylinConfig(prop);
                    logger.info("Resetting SYS_ENV_INSTANCE by a input stream: " + System.identityHashCode(config));
                    SYS_ENV_INSTANCE = config;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to find KylinConfig ", e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void setKylinConfigInEnvIfMissing(String propsInStr) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(propsInStr));
        KylinConfig.setKylinConfigInEnvIfMissing(props);
    }

    public static void setKylinConfigThreadLocal(KylinConfig config) {
        THREAD_ENV_INSTANCE.set(config);
    }

    public static void removeKylinConfigThreadLocal() {
        THREAD_ENV_INSTANCE.remove();
    }

    public static KylinConfig createKylinConfig(String propsInStr) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(propsInStr));
        return KylinConfig.createKylinConfig(props);
    }

    public static KylinConfig createKylinConfig(KylinConfig another) {
        return KylinConfig.createKylinConfig(another.getAllProperties());
    }

    public static KylinConfig createKylinConfig(Properties prop) {
        KylinConfig kylinConfig = new KylinConfig();
        kylinConfig.reloadKylinConfig(prop);
        return kylinConfig;
    }

    public static File getKylinConfDir() {
        return KylinConfig.getSitePropertiesFile().getParentFile();
    }

    static File getSitePropertiesFile() {
        String kylinConfHome = System.getProperty(KYLIN_CONF);
        if (!StringUtils.isEmpty((String)kylinConfHome)) {
            logger.info("Use KYLIN_CONF=" + kylinConfHome);
            return KylinConfig.existFile(kylinConfHome);
        }
        logger.debug("KYLIN_CONF property was not set, will seek KYLIN_HOME env variable");
        String kylinHome = KylinConfig.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            throw new KylinConfigCannotInitException("Didn't find KYLIN_CONF or KYLIN_HOME, please set one of them");
        }
        String path = kylinHome + File.separator + "conf";
        return KylinConfig.existFile(path);
    }

    private static File existFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path, KYLIN_CONF_PROPERTIES_FILE);
    }

    private static Properties buildSiteProperties() {
        Properties conf = new Properties();
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        for (Map.Entry<String, String> each : orderedProperties.entrySet()) {
            conf.put(each.getKey(), each.getValue());
        }
        return conf;
    }

    private static OrderedProperties buildSiteOrderedProps() {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("kylin-defaults.properties");
            Preconditions.checkNotNull((Object)resource);
            logger.info("Loading kylin-defaults.properties from {}", (Object)resource.getPath());
            OrderedProperties orderedProperties = new OrderedProperties();
            KylinConfig.loadPropertiesFromInputStream(resource.openStream(), orderedProperties);
            for (int i = 0; i < 10; ++i) {
                String fileName = "kylin-defaults" + i + ".properties";
                URL additionalResource = Thread.currentThread().getContextClassLoader().getResource(fileName);
                if (additionalResource == null) continue;
                logger.info("Loading {} from {} ", (Object)fileName, (Object)additionalResource.getPath());
                KylinConfig.loadPropertiesFromInputStream(additionalResource.openStream(), orderedProperties);
            }
            File propFile = KylinConfig.getSitePropertiesFile();
            if (propFile == null || !propFile.exists()) {
                logger.error("fail to locate kylin.properties");
                throw new RuntimeException("fail to locate kylin.properties");
            }
            KylinConfig.loadPropertiesFromInputStream(new FileInputStream(propFile), orderedProperties);
            File propOverrideFile = new File(propFile.getParentFile(), propFile.getName() + ".override");
            if (propOverrideFile.exists()) {
                KylinConfig.loadPropertiesFromInputStream(new FileInputStream(propOverrideFile), orderedProperties);
            }
            return orderedProperties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadPropertiesFromInputStream(InputStream inputStream, OrderedProperties properties) {
        Preconditions.checkNotNull((Object)properties);
        BufferedReader confReader = null;
        try {
            confReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            OrderedProperties temp = new OrderedProperties();
            temp.load(confReader);
            temp = BCC.check(temp);
            properties.putAll(temp);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(confReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)confReader);
    }

    public static void setSandboxEnvIfPossible() {
        File dir1 = new File("../examples/test_case_data/sandbox");
        File dir2 = new File("../../kylin/examples/test_case_data/sandbox");
        if (dir1.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir1.getAbsolutePath());
            ClassUtil.addClasspath(dir1.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir1.getAbsolutePath());
        } else if (dir2.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir2.getAbsolutePath());
            ClassUtil.addClasspath(dir2.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir2.getAbsolutePath());
        }
    }

    private KylinConfig() {
    }

    protected KylinConfig(Properties props, boolean force) {
        super(props, force);
    }

    public Properties exportToProperties() {
        Properties all = this.getAllProperties();
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)all);
        return copy;
    }

    public String exportToString() throws IOException {
        Properties allProps = this.getAllProperties();
        OrderedProperties orderedProperties = KylinConfig.buildSiteOrderedProps();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : allProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!orderedProperties.containsProperty(key)) {
                orderedProperties.setProperty(key, value);
                continue;
            }
            if (orderedProperties.getProperty(key).equalsIgnoreCase(value)) continue;
            orderedProperties.setProperty(key, value);
        }
        for (Map.Entry<Object, Object> entry : orderedProperties.entrySet()) {
            sb.append((String)entry.getKey() + "=" + (String)entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToFile(File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.getAllProperties().store(fos, file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public synchronized void reloadFromSiteProperties() {
        this.reloadKylinConfig(KylinConfig.buildSiteProperties());
    }

    public KylinConfig base() {
        return this;
    }

    private int superHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.base().superHashCode();
    }

    public boolean equals(Object another) {
        if (!(another instanceof KylinConfig)) {
            return false;
        }
        return this.base() == ((KylinConfig)another).base();
    }

    static {
        String NATIVE_UTF16_CHARSET_NAME = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";
        System.setProperty("saffron.default.charset", NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.nationalcharset", NATIVE_UTF16_CHARSET_NAME);
        System.setProperty("saffron.default.collation.name", NATIVE_UTF16_CHARSET_NAME + "$en_US");
    }

    public static enum UriType {
        PROPERTIES_FILE,
        REST_ADDR,
        LOCAL_FOLDER,
        HDFS_FILE;

    }
}

