/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.storage.hbase.steps.CreateHTableJob;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateHTableTest
extends LocalFileMetadataTestCase {
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = HadoopUtil.getCurrentConfiguration();
        this.conf.set("fs.default.name", "file:///");
        this.conf.set("mapreduce.framework.name", "local");
        this.conf.set("mapreduce.application.framework.path", "");
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testGetSplits() throws IllegalArgumentException, Exception {
        CreateHTableJob c = new CreateHTableJob();
        String input = "src/test/resources/partition_list/part-r-00000";
        byte[][] splits = c.getRegionSplits(this.conf, new Path(input));
        Assert.assertEquals((long)497L, (long)splits.length);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 15, -1, 11, 51, -45, 2}, (byte[])splits[0]);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 3, -1, -1, -54, -61, 109, -44, 1}, (byte[])splits[496]);
    }
}

