/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hdfs;

import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;

public class ResourceLock {
    private String resourcePath;
    private InterProcessMutex lock;

    protected ResourceLock(String resourcePath, InterProcessMutex lock) {
        this.resourcePath = resourcePath;
        this.lock = lock;
    }

    public void acquire(long time, TimeUnit unit) throws Exception {
        boolean success = this.lock.acquire(time, unit);
        if (!success) {
            throw new IllegalStateException("Fail to get Zookeeper lock");
        }
    }

    public void acquire() throws Exception {
        this.lock.acquire();
    }

    protected void release() throws Exception {
        this.lock.release();
    }

    public String getResourcePath() {
        return this.resourcePath;
    }
}

