/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.storage.hbase.HBaseConnection;

public class HBaseUsage {
    public static void main(String[] args) throws IOException {
        HBaseUsage.show();
    }

    private static void show() throws IOException {
        HTableDescriptor[] tableDescriptors;
        HashMap envs = Maps.newHashMap();
        Connection conn = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl());
        Admin hbaseAdmin = conn.getAdmin();
        String tableNamePrefix = "KYLIN_";
        for (HTableDescriptor desc : tableDescriptors = hbaseAdmin.listTables(tableNamePrefix + ".*")) {
            String host = desc.getValue("KYLIN_HOST");
            if (StringUtils.isEmpty((String)host)) {
                HBaseUsage.add("unknown", desc.getNameAsString(), envs);
                continue;
            }
            HBaseUsage.add(host, desc.getNameAsString(), envs);
        }
        for (Map.Entry entry : envs.entrySet()) {
            System.out.println((String)entry.getKey() + " has htable count: " + ((List)entry.getValue()).size());
        }
        hbaseAdmin.close();
    }

    private static void add(String tag, String tableName, Map<String, List<String>> envs) {
        if (!envs.containsKey(tag)) {
            envs.put(tag, Lists.newArrayList());
        }
        envs.get(tag).add(tableName);
    }
}

