/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.kylin.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRegionSizeCalculator {
    private static final Logger logger = LoggerFactory.getLogger(HBaseRegionSizeCalculator.class);
    private final Map<byte[], Long> sizeMap;
    private final Map<byte[], Pair<Integer, Integer>> countMap;
    static final String ENABLE_REGIONSIZECALCULATOR = "hbase.regionsizecalculator.enable";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseRegionSizeCalculator(String tableName, Connection hbaseConnection) throws IOException {
        Admin admin;
        Table table;
        block6: {
            this.sizeMap = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            this.countMap = new TreeMap<byte[], Pair<Integer, Integer>>(Bytes.BYTES_COMPARATOR);
            table = null;
            admin = null;
            table = hbaseConnection.getTable(TableName.valueOf((String)tableName));
            admin = hbaseConnection.getAdmin();
            if (this.enabled(table.getConfiguration())) break block6;
            logger.info("Region size calculation disabled.");
            IOUtils.closeQuietly((Closeable)admin);
            return;
        }
        try {
            logger.info("Calculating region sizes for table \"" + table.getName() + "\".");
            RegionLocator regionLocator = hbaseConnection.getRegionLocator(table.getName());
            List regionLocationList = regionLocator.getAllRegionLocations();
            TreeSet<byte[]> tableRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (HRegionLocation hRegionLocation : regionLocationList) {
                tableRegions.add(hRegionLocation.getRegionInfo().getRegionName());
            }
            ClusterStatus clusterStatus = admin.getClusterStatus();
            Collection servers = clusterStatus.getServers();
            long megaByte = 0x100000L;
            for (ServerName serverName : servers) {
                ServerLoad serverLoad = clusterStatus.getLoad(serverName);
                for (RegionLoad regionLoad : serverLoad.getRegionsLoad().values()) {
                    byte[] regionId = regionLoad.getName();
                    if (!tableRegions.contains(regionId)) continue;
                    long regionSizeBytes = (long)regionLoad.getStorefileSizeMB() * 0x100000L;
                    this.sizeMap.put(regionId, regionSizeBytes);
                    this.countMap.put(regionId, new Pair<Integer, Integer>(regionLoad.getStores(), regionLoad.getStorefiles()));
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(admin);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)admin);
    }

    boolean enabled(Configuration configuration) {
        return configuration.getBoolean(ENABLE_REGIONSIZECALCULATOR, true);
    }

    public long getRegionSize(byte[] regionId) {
        Long size = this.sizeMap.get(regionId);
        if (size == null) {
            logger.info("Unknown region:" + Arrays.toString(regionId));
            return 0L;
        }
        return size;
    }

    public Map<byte[], Long> getRegionSizeMap() {
        return Collections.unmodifiableMap(this.sizeMap);
    }

    public Map<byte[], Pair<Integer, Integer>> getRegionHFileCountMap() {
        return Collections.unmodifiableMap(this.countMap);
    }
}

