/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.HiveToBaseCuboidMapper;
import org.apache.kylin.engine.mr.steps.InMemCuboidMapper;
import org.apache.kylin.engine.mr.steps.MergeCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidMapper;
import org.apache.kylin.engine.mr.steps.ReducerNumSizing;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.storage.hbase.steps.HBaseMRSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMROutput2Transition
implements IMROutput2 {
    private static final Logger logger = LoggerFactory.getLogger(HBaseMROutput2Transition.class);

    public IMROutput2.IMRBatchCubingOutputSide2 getBatchCubingOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchCubingOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps(seg);
            }

            public void addStepPhase2_BuildDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStepWithStats(jobFlow.getId()));
            }

            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
            }

            public IMROutput2.IMROutputFormat getOuputFormat() {
                return new HBaseMROutputFormat();
            }
        };
    }

    public IMROutput2.IMRBatchMergeOutputSide2 getBatchMergeOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchMergeOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps(seg);
            }

            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStepWithStats(jobFlow.getId()));
            }

            public void addStepPhase2_BuildCube(CubeSegment seg2, List<CubeSegment> mergingSegments, DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createMergeCuboidDataStep(seg2, mergingSegments, jobFlow.getId(), MergeCuboidJob.class));
                jobFlow.addTask((AbstractExecutable)this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase3_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addMergingGarbageCollectionSteps(jobFlow);
            }

            public IMROutput2.IMRMergeOutputFormat getOuputFormat() {
                return new HBaseMergeMROutputFormat();
            }
        };
    }

    public static class HBaseMergeMROutputFormat
    implements IMROutput2.IMRMergeOutputFormat {
        private static final Pattern JOB_NAME_PATTERN = Pattern.compile("kylin-([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

        public void configureJobInput(Job job, String input) throws Exception {
            job.setInputFormatClass(SequenceFileInputFormat.class);
        }

        public void configureJobOutput(Job job, String output, CubeSegment segment) throws Exception {
            int reducerNum = ReducerNumSizing.getLayeredCubingReduceTaskNum((CubeSegment)segment, (double)AbstractHadoopJob.getTotalMapInputMB((Job)job), (int)-1);
            job.setNumReduceTasks(reducerNum);
            Path outputPath = new Path(output);
            HadoopUtil.deletePath(job.getConfiguration(), outputPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
        }

        public CubeSegment findSourceSegment(FileSplit fileSplit, CubeInstance cube) {
            String filePath = fileSplit.getPath().toString();
            String jobID = HBaseMergeMROutputFormat.extractJobIDFromPath(filePath);
            return HBaseMergeMROutputFormat.findSegmentWithUuid(jobID, cube);
        }

        private static String extractJobIDFromPath(String path) {
            Matcher matcher = JOB_NAME_PATTERN.matcher(path);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new IllegalStateException("Can not extract job ID from file path : " + path);
        }

        private static CubeSegment findSegmentWithUuid(String jobID, CubeInstance cubeInstance) {
            for (CubeSegment segment : cubeInstance.getSegments()) {
                String lastBuildJobID = segment.getLastBuildJobID();
                if (lastBuildJobID == null || !lastBuildJobID.equalsIgnoreCase(jobID)) continue;
                return segment;
            }
            throw new IllegalStateException("No merging segment's last build job ID equals " + jobID);
        }
    }

    public static class HBaseMROutputFormat
    implements IMROutput2.IMROutputFormat {
        public void configureJobInput(Job job, String input) throws Exception {
            job.setInputFormatClass(SequenceFileInputFormat.class);
        }

        public void configureJobOutput(Job job, String output, CubeSegment segment, int level) throws Exception {
            int reducerNum = 1;
            Class mapperClass = job.getMapperClass();
            if (mapperClass == HiveToBaseCuboidMapper.class || mapperClass == NDCuboidMapper.class) {
                reducerNum = ReducerNumSizing.getLayeredCubingReduceTaskNum((CubeSegment)segment, (double)AbstractHadoopJob.getTotalMapInputMB((Job)job), (int)level);
            } else if (mapperClass == InMemCuboidMapper.class) {
                reducerNum = ReducerNumSizing.getInmemCubingReduceTaskNum((CubeSegment)segment);
            }
            Path outputPath = new Path(output);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            job.setNumReduceTasks(reducerNum);
            HadoopUtil.deletePath(job.getConfiguration(), outputPath);
        }
    }
}

