/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.CubeHFileMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeHFileJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(CubeHFileJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_PARTITION_FILE_PATH);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_HTABLE_NAME);
            this.parseOptions(options, args);
            Path partitionFilePath = new Path(this.getOptionValue(OPTION_PARTITION_FILE_PATH));
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase();
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.setJobClasspath(this.job, cube.getConfig());
            HBaseConnection.addHBaseClusterNNHAConfiguration(this.job.getConfiguration());
            CubeHFileJob.addInputDirs((String)this.getOptionValue(OPTION_INPUT_PATH), (Job)this.job);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(CubeHFileMapper.class);
            this.job.setReducerClass(KeyValueSortReducer.class);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.attachCubeMetadata(cube, this.job.getConfiguration());
            Configuration hbaseConf = HBaseConfiguration.create((Configuration)this.getConf());
            HTable htable = new HTable(hbaseConf, this.getOptionValue(OPTION_HTABLE_NAME).toUpperCase());
            HFileOutputFormat.configureIncrementalLoad((Job)this.job, (HTable)htable);
            this.reconfigurePartitions(hbaseConf, partitionFilePath);
            hbaseConf.set("dfs.replication", "3");
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void reconfigurePartitions(Configuration conf, Path path) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path)) {
            try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, conf);){
                int partitionCount = 0;
                Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                while (reader.next(key, value)) {
                    ++partitionCount;
                }
                TotalOrderPartitioner.setPartitionFile((Configuration)this.job.getConfiguration(), (Path)path);
                this.job.setNumReduceTasks(partitionCount + 1);
            }
        } else {
            logger.info("File '" + path.toString() + " doesn't exist, will not reconfigure hfile Partitions");
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new CubeHFileJob(), (String[])args);
        System.exit(exitCode);
    }
}

