/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.datagen;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.source.datagen.ModelDataGenerator;
import org.apache.kylin.source.datagen.Util;

public class ColumnGenConfig {
    public static final String FK = "FK";
    public static final String ID = "ID";
    public static final String RAND = "RAND";
    public static final String $RANDOM = "${RANDOM}";
    boolean isDiscrete;
    boolean isFK;
    List<String> values;
    boolean isRandom;
    String randFormat;
    int randStart;
    int randEnd;
    boolean isID;
    int idStart;
    int cardinality;
    boolean genNull;
    double genNullPct;
    String genNullStr;
    boolean order;
    boolean unique;

    public ColumnGenConfig(ColumnDesc col, ModelDataGenerator modelGen) throws IOException {
        this.init(col, modelGen);
    }

    private void init(ColumnDesc col, ModelDataGenerator modelGen) throws IOException {
        Map<String, String> config = Util.parseEqualCommaPairs(col.getDataGen(), "values");
        this.values = Arrays.asList(Util.parseString(config, "values", "").split("[|]"));
        List<String> pkValues = modelGen.getPkValuesIfIsFk(col);
        if (FK.equals(this.values.get(0)) || this.values.get(0).isEmpty() && pkValues != null) {
            this.isFK = true;
            this.values = this.getPkValues(modelGen, config, pkValues);
        } else if (ID.equals(this.values.get(0))) {
            this.isID = true;
            this.idStart = this.values.size() > 1 ? Integer.parseInt(this.values.get(1)) : 0;
        } else if (RAND.equals(this.values.get(0)) || this.values.get(0).isEmpty()) {
            this.isRandom = true;
            this.randFormat = this.values.size() > 1 ? this.values.get(1) : "";
            this.randStart = this.values.size() > 2 ? Integer.parseInt(this.values.get(2)) : 0;
            this.randEnd = this.values.size() > 3 ? Integer.parseInt(this.values.get(3)) : 0;
        } else {
            this.isDiscrete = true;
        }
        this.cardinality = Util.parseInt(config, "card", this.guessCardinality(col.getName()));
        this.genNull = Util.parseBoolean(config, "null", this.guessGenNull(col.getName()));
        this.genNullPct = Util.parseDouble(config, "nullpct", 0.01);
        this.genNullStr = Util.parseString(config, "nullstr", "\\N");
        this.order = Util.parseBoolean(config, "order", false);
        this.unique = Util.parseBoolean(config, "uniq", modelGen.isPK(col));
    }

    private List<String> getPkValues(ModelDataGenerator modelGen, Map<String, String> config, List<String> dftPkValues) throws IOException {
        String pkColName = config.get("pk");
        if (pkColName == null) {
            return dftPkValues;
        }
        int cut = pkColName.lastIndexOf(46);
        String pkTableName = pkColName.substring(0, cut);
        pkColName = pkColName.substring(cut + 1);
        KylinConfig kylinConfig = modelGen.getModle().getConfig();
        ColumnDesc pkcol = MetadataManager.getInstance(kylinConfig).getTableDesc(pkTableName).findColumnByName(pkColName);
        return modelGen.getPkValues(pkcol);
    }

    private int guessCardinality(String col) {
        for (String s : col.split("_")) {
            if (!s.startsWith("C")) continue;
            try {
                return Integer.parseInt(s.substring(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private boolean guessGenNull(String col) {
        return col.contains("_NULL");
    }
}

