/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source;

import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISource;

public class SourceFactory {
    private static ThreadLocal<ImplementationSwitch<ISource>> sources = new ThreadLocal();

    private static ISource getSource(int sourceType) {
        ImplementationSwitch<ISource> current = sources.get();
        if (current == null) {
            current = new ImplementationSwitch<ISource>(KylinConfig.getInstanceFromEnv().getSourceEngines(), ISource.class);
            sources.set(current);
        }
        return current.get(sourceType);
    }

    public static ISource getDefaultSource() {
        return SourceFactory.getSource(KylinConfig.getInstanceFromEnv().getDefaultSource());
    }

    public static ISource getSource(ISourceAware aware) {
        return SourceFactory.getSource(aware.getSourceType());
    }

    public static IReadableTable createReadableTable(TableDesc table) {
        return SourceFactory.getSource(table).createReadableTable(table);
    }

    public static <T> T createEngineAdapter(ISourceAware table, Class<T> engineInterface) {
        return SourceFactory.getSource(table).adaptToBuildEngine(engineInterface);
    }

    public static List<String> getMRDependentResources(TableDesc table) {
        return SourceFactory.getSource(table).getSourceMetadataExplorer().getRelatedKylinResources(table);
    }
}

