/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.streaming.StreamingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingManager {
    private static final Logger logger = LoggerFactory.getLogger(StreamingManager.class);
    private static final ConcurrentMap<KylinConfig, StreamingManager> CACHE = new ConcurrentHashMap<KylinConfig, StreamingManager>();
    public static final Serializer<StreamingConfig> STREAMING_SERIALIZER = new JsonSerializer<StreamingConfig>(StreamingConfig.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<StreamingConfig> streamingMap;

    public static void clearCache() {
        CACHE.clear();
    }

    private StreamingManager(KylinConfig config) throws IOException {
        this.config = config;
        this.streamingMap = new CaseInsensitiveStringCache(config, "streaming");
        this.reloadAllStreaming();
        Broadcaster.getInstance(config).registerListener(new StreamingSyncListener(), "streaming");
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public static StreamingManager getInstance(KylinConfig config) {
        StreamingManager r = (StreamingManager)CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<StreamingManager> clazz = StreamingManager.class;
        synchronized (StreamingManager.class) {
            r = (StreamingManager)CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new StreamingManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init StreamingManager from " + config, e);
            }
        }
    }

    private static String formatStreamingConfigPath(String name) {
        return "/streaming/" + name + ".json";
    }

    private static String formatStreamingOutputPath(String streaming, int partition) {
        return "/streaming_output/" + streaming + "_" + partition + ".json";
    }

    private static String formatStreamingOutputPath(String streaming, List<Integer> partitions) {
        return "/streaming_output/" + streaming + "_" + StringUtils.join(partitions, (String)"_") + ".json";
    }

    public StreamingConfig getStreamingConfig(String name) {
        return (StreamingConfig)this.streamingMap.get(name);
    }

    public List<StreamingConfig> listAllStreaming() {
        return new ArrayList<StreamingConfig>(this.streamingMap.values());
    }

    public StreamingConfig reloadStreamingConfigLocal(String name) throws IOException {
        String path = StreamingConfig.concatResourcePath(name);
        StreamingConfig ndesc = this.loadStreamingConfigAt(path);
        this.streamingMap.putLocal(ndesc.getName(), ndesc);
        return ndesc;
    }

    public void removeStreamingConfig(StreamingConfig streamingConfig) throws IOException {
        String path = streamingConfig.getResourcePath();
        this.getStore().deleteResource(path);
        this.streamingMap.remove(streamingConfig.getName());
    }

    public StreamingConfig getConfig(String name) {
        name = name.toUpperCase();
        return (StreamingConfig)this.streamingMap.get(name);
    }

    public void removeStreamingLocal(String streamingName) {
        this.streamingMap.removeLocal(streamingName);
    }

    public StreamingConfig updateStreamingConfig(StreamingConfig desc) throws IOException {
        if (desc.getUuid() == null || desc.getName() == null) {
            throw new IllegalArgumentException("SteamingConfig Illegal.");
        }
        String name = desc.getName();
        if (!this.streamingMap.containsKey(name)) {
            throw new IllegalArgumentException("StreamingConfig '" + name + "' does not exist.");
        }
        String path = desc.getResourcePath();
        this.getStore().putResource(path, desc, STREAMING_SERIALIZER);
        StreamingConfig ndesc = this.loadStreamingConfigAt(path);
        this.streamingMap.put(ndesc.getName(), desc);
        return ndesc;
    }

    public StreamingConfig saveStreamingConfig(StreamingConfig streamingConfig) throws IOException {
        if (streamingConfig == null || StringUtils.isEmpty((CharSequence)streamingConfig.getName())) {
            throw new IllegalArgumentException();
        }
        if (this.streamingMap.containsKey(streamingConfig.getName())) {
            throw new IllegalArgumentException("StreamingConfig '" + streamingConfig.getName() + "' already exists");
        }
        String path = StreamingConfig.concatResourcePath(streamingConfig.getName());
        this.getStore().putResource(path, streamingConfig, StreamingConfig.SERIALIZER);
        this.streamingMap.put(streamingConfig.getName(), streamingConfig);
        return streamingConfig;
    }

    private StreamingConfig loadStreamingConfigAt(String path) throws IOException {
        ResourceStore store = this.getStore();
        StreamingConfig streamingDesc = store.getResource(path, StreamingConfig.class, STREAMING_SERIALIZER);
        if (StringUtils.isBlank((CharSequence)streamingDesc.getName())) {
            throw new IllegalStateException("StreamingConfig name must not be blank");
        }
        return streamingDesc;
    }

    private void reloadAllStreaming() throws IOException {
        ResourceStore store = this.getStore();
        logger.info("Reloading Streaming Metadata from folder " + store.getReadableResourcePath("/streaming"));
        this.streamingMap.clear();
        List<String> paths = store.collectResourceRecursively("/streaming", ".json");
        for (String path : paths) {
            StreamingConfig streamingConfig;
            try {
                streamingConfig = this.loadStreamingConfigAt(path);
            }
            catch (Exception e) {
                logger.error("Error loading streaming desc " + path, (Throwable)e);
                continue;
            }
            if (!path.equals(streamingConfig.getResourcePath())) {
                logger.error("Skip suspicious desc at " + path + ", " + streamingConfig + " should be at " + streamingConfig.getResourcePath());
                continue;
            }
            if (this.streamingMap.containsKey(streamingConfig.getName())) {
                logger.error("Dup StreamingConfig name '" + streamingConfig.getName() + "' on path " + path);
                continue;
            }
            this.streamingMap.putLocal(streamingConfig.getName(), streamingConfig);
        }
        logger.debug("Loaded " + this.streamingMap.size() + " StreamingConfig(s)");
    }

    private class StreamingSyncListener
    extends Broadcaster.Listener {
        private StreamingSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            StreamingManager.clearCache();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if (event == Broadcaster.Event.DROP) {
                StreamingManager.this.removeStreamingLocal(cacheKey);
            } else {
                StreamingManager.this.reloadStreamingConfigLocal(cacheKey);
            }
        }
    }
}

