/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.tool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang3.tuple.Pair;

public class CalciteParser {
    public static SqlNode parse(String sql) throws SqlParseException {
        SqlParser.ConfigBuilder parserBuilder = SqlParser.configBuilder();
        SqlParser sqlParser = SqlParser.create((String)sql, (SqlParser.Config)parserBuilder.build());
        return sqlParser.parseQuery();
    }

    public static SqlNode getOnlySelectNode(String sql) {
        SqlNodeList selectList = null;
        try {
            selectList = ((SqlSelect)CalciteParser.parse(sql)).getSelectList();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("Failed to parse expression '" + sql + "', please make sure the expression is valid and no table name exists in the expression");
        }
        Preconditions.checkArgument((selectList.size() == 1 ? 1 : 0) != 0, (Object)"Expression is invalid because size of select list exceeds one");
        return selectList.get(0);
    }

    public static SqlNode getExpNode(String expr) {
        return CalciteParser.getOnlySelectNode("select " + expr + " from t");
    }

    public static SqlNode getFromNode(String sql) {
        sql = sql.split("LIMIT")[0];
        SqlNode fromNode = null;
        try {
            fromNode = ((SqlSelect)CalciteParser.parse(sql)).getFrom();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("Failed to parse expression '" + sql + "', please make sure the expression is valid");
        }
        return fromNode;
    }

    public static boolean isNodeEqual(SqlNode node0, SqlNode node1) {
        if (node0 == null) {
            return node1 == null;
        }
        if (node1 == null) {
            return false;
        }
        if (!Objects.equals(node0.getClass().getSimpleName(), node1.getClass().getSimpleName())) {
            return false;
        }
        if (node0 instanceof SqlCall) {
            SqlCall thisNode = (SqlCall)node0;
            SqlCall thatNode = (SqlCall)node1;
            if (!thisNode.getOperator().getName().equalsIgnoreCase(thatNode.getOperator().getName())) {
                return false;
            }
            return CalciteParser.isNodeEqual(thisNode.getOperandList(), thatNode.getOperandList());
        }
        if (node0 instanceof SqlLiteral) {
            SqlLiteral thisNode = (SqlLiteral)node0;
            SqlLiteral thatNode = (SqlLiteral)node1;
            return Objects.equals(thisNode.getValue(), thatNode.getValue());
        }
        if (node0 instanceof SqlNodeList) {
            SqlNodeList thisNode = (SqlNodeList)node0;
            SqlNodeList thatNode = (SqlNodeList)node1;
            if (thisNode.getList().size() != thatNode.getList().size()) {
                return false;
            }
            for (int i = 0; i < thisNode.getList().size(); ++i) {
                SqlNode thatChild;
                SqlNode thisChild = (SqlNode)thisNode.getList().get(i);
                if (CalciteParser.isNodeEqual(thisChild, thatChild = (SqlNode)thatNode.getList().get(i))) continue;
                return false;
            }
            return true;
        }
        if (node0 instanceof SqlIdentifier) {
            SqlIdentifier thisNode = (SqlIdentifier)node0;
            SqlIdentifier thatNode = (SqlIdentifier)node1;
            String name0 = ((String)thisNode.names.get(thisNode.names.size() - 1)).replace("\"", "");
            String name1 = ((String)thatNode.names.get(thatNode.names.size() - 1)).replace("\"", "");
            return name0.equalsIgnoreCase(name1);
        }
        return false;
    }

    private static boolean isNodeEqual(List<SqlNode> operands0, List<SqlNode> operands1) {
        if (operands0.size() != operands1.size()) {
            return false;
        }
        for (int i = 0; i < operands0.size(); ++i) {
            if (CalciteParser.isNodeEqual(operands0.get(i), operands1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void ensureNoTableNameExists(String expr) {
        SqlNode sqlNode = CalciteParser.getExpNode(expr);
        SqlBasicVisitor sqlVisitor = new SqlBasicVisitor(){

            public Object visit(SqlIdentifier id) {
                if (id.names.size() > 1) {
                    throw new IllegalArgumentException("SqlIdentifier " + id + " contains DB/Table name");
                }
                return null;
            }
        };
        sqlNode.accept((SqlVisitor)sqlVisitor);
    }

    public static String insertAliasInExpr(String expr, String alias) {
        String prefix = "select ";
        String suffix = " from t";
        String sql = prefix + expr + suffix;
        SqlNode sqlNode = CalciteParser.getOnlySelectNode(sql);
        final HashSet s = Sets.newHashSet();
        SqlBasicVisitor sqlVisitor = new SqlBasicVisitor(){

            public Object visit(SqlIdentifier id) {
                if (id.names.size() > 1) {
                    throw new IllegalArgumentException("SqlIdentifier " + id + " contains DB/Table name");
                }
                s.add(id);
                return null;
            }
        };
        sqlNode.accept((SqlVisitor)sqlVisitor);
        ArrayList sqlIdentifiers = Lists.newArrayList((Iterable)s);
        Collections.sort(sqlIdentifiers, new Comparator<SqlIdentifier>(){

            @Override
            public int compare(SqlIdentifier o1, SqlIdentifier o2) {
                int linegap = o2.getParserPosition().getLineNum() - o1.getParserPosition().getLineNum();
                if (linegap != 0) {
                    return linegap;
                }
                return o2.getParserPosition().getColumnNum() - o1.getParserPosition().getColumnNum();
            }
        });
        for (SqlIdentifier sqlIdentifier : sqlIdentifiers) {
            Pair<Integer, Integer> replacePos = CalciteParser.getReplacePos((SqlNode)sqlIdentifier, sql);
            int start = (Integer)replacePos.getLeft();
            sql = sql.substring(0, start) + alias + "." + sql.substring(start);
        }
        return sql.substring(prefix.length(), sql.length() - suffix.length());
    }

    public static Pair<Integer, Integer> getReplacePos(SqlNode node, String inputSql) {
        int i;
        if (inputSql == null) {
            return Pair.of((Object)0, (Object)0);
        }
        String[] lines = inputSql.split("\n");
        SqlParserPos pos = node.getParserPosition();
        int lineStart = pos.getLineNum();
        int lineEnd = pos.getEndLineNum();
        int columnStart = pos.getColumnNum() - 1;
        int columnEnd = pos.getEndColumnNum();
        for (i = 0; i < lineStart - 1; ++i) {
            columnStart += lines[i].length() + 1;
        }
        for (i = 0; i < lineEnd - 1; ++i) {
            columnEnd += lines[i].length() + 1;
        }
        Pair<Integer, Integer> startEndPos = CalciteParser.getPosWithBracketsCompletion(inputSql, columnStart, columnEnd);
        return startEndPos;
    }

    private static Pair<Integer, Integer> getPosWithBracketsCompletion(String inputSql, int left, int right) {
        int leftBracketNum = 0;
        int rightBracketNum = 0;
        String substring = inputSql.substring(left, right);
        for (int i = 0; i < substring.length(); ++i) {
            char temp = substring.charAt(i);
            if (temp == '(') {
                ++leftBracketNum;
            }
            if (temp != ')' || leftBracketNum >= ++rightBracketNum) continue;
            while ('(' != inputSql.charAt(left - 1)) {
                --left;
            }
            --left;
            ++leftBracketNum;
        }
        while (rightBracketNum < leftBracketNum) {
            while (')' != inputSql.charAt(right)) {
                ++right;
            }
            ++right;
            ++rightBracketNum;
        }
        return Pair.of((Object)left, (Object)right);
    }
}

