/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.persistence.RootPersistentEntity;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableExtDesc
extends RootPersistentEntity {
    @JsonProperty(value="table_name")
    private String tableIdentity;
    @JsonProperty(value="last_build_job_id")
    private String jodID;
    @JsonProperty(value="frequency")
    private int frequency;
    @JsonProperty(value="columns_stats")
    private List<ColumnStats> columnStats = new ArrayList<ColumnStats>();
    @JsonProperty(value="sample_rows")
    private List<String[]> sampleRows = new ArrayList<String[]>();
    @JsonProperty(value="last_modified_time")
    private long lastModifiedTime;
    @JsonProperty(value="total_rows")
    private long totalRows;
    @JsonProperty(value="mapper_rows")
    private List<Long> mapRecords = new ArrayList<Long>();
    @JsonProperty(value="data_source_properties")
    private Map<String, String> dataSourceProps = new HashMap<String, String>();

    public String getResourcePath() {
        return TableExtDesc.concatResourcePath(this.getIdentity());
    }

    public static String concatResourcePath(String tableIdentity) {
        return "/table_exd/" + tableIdentity + ".json";
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public String getIdentity() {
        return this.tableIdentity;
    }

    public String getJodID() {
        return this.jodID;
    }

    public void addDataSourceProp(String key, String value) {
        this.dataSourceProps.put(key, value);
    }

    public Map<String, String> getDataSourceProp() {
        return this.dataSourceProps;
    }

    public void setSampleRows(List<String[]> sampleRows) {
        this.sampleRows = sampleRows;
    }

    public List<String[]> getSampleRows() {
        return this.sampleRows;
    }

    public void setMapRecords(List<Long> mapRecords) {
        this.mapRecords = mapRecords;
    }

    public List<Long> getMapRecords() {
        return this.mapRecords;
    }

    public String getCardinality() {
        StringBuffer cardinality = new StringBuffer();
        for (ColumnStats stat : this.columnStats) {
            cardinality.append(stat.getCardinality());
            cardinality.append(",");
        }
        return cardinality.toString();
    }

    public void setCardinality(String cardinality) {
        if (null == cardinality) {
            return;
        }
        String[] cardi = cardinality.split(",");
        if (0 == this.columnStats.size()) {
            for (int i = 0; i < cardi.length; ++i) {
                ColumnStats columnStat = new ColumnStats();
                columnStat.setCardinality(Long.parseLong(cardi[i]));
                this.columnStats.add(columnStat);
            }
        } else if (this.columnStats.size() == cardi.length) {
            for (int i = 0; i < cardi.length; ++i) {
                this.columnStats.get(i).setCardinality(Long.parseLong(cardi[i]));
            }
        } else {
            throw new IllegalArgumentException("The given cardinality columns don't match tables " + this.tableIdentity);
        }
    }

    public List<ColumnStats> getColumnStats() {
        return this.columnStats;
    }

    public void setColumnStats(List<ColumnStats> columnStats) {
        this.columnStats = null;
        this.columnStats = columnStats;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public void setIdentity(String name) {
        this.tableIdentity = name;
    }

    public void setJodID(String jobID) {
        this.jodID = jobID;
    }

    public void init() {
        if (this.tableIdentity != null) {
            this.tableIdentity = this.tableIdentity.toUpperCase();
        }
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean isPartitioned() {
        return this.dataSourceProps.get("partition_column") == null ? false : !this.dataSourceProps.get("partition_column").isEmpty();
    }

    @Override
    public int hashCode() {
        return this.getIdentity().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        return "TableExtDesc{name='" + (null == this.tableIdentity ? "NULL" : this.tableIdentity) + '\'' + ", columns_samples=" + (null == this.columnStats ? "null" : Arrays.toString(this.columnStats.toArray()));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ColumnStats
    implements Comparable<ColumnStats>,
    Serializable {
        @JsonBackReference
        private TableExtDesc tableExtDesc;
        @JsonProperty(value="column_name")
        private String columnName;
        @JsonProperty(value="max_value")
        private String maxValue;
        @JsonProperty(value="min_value")
        private String minValue;
        @JsonProperty(value="max_length_value")
        private String maxLengthValue;
        @JsonProperty(value="min_length_value")
        private String minLengthValue;
        @JsonProperty(value="null_count")
        private long nullCount;
        @JsonProperty(value="cardinality")
        private long cardinality;
        @JsonProperty(value="data_skew_samples")
        private Map<String, Long> dataSkewSamples = new HashMap<String, Long>();

        @Override
        public int compareTo(ColumnStats o) {
            return 0;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        public String getMaxValue() {
            return this.maxValue;
        }

        public void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public void setMaxLengthValue(String maxLengthValue) {
            this.maxLengthValue = maxLengthValue;
        }

        public String getMaxLengthValue() {
            return this.maxLengthValue;
        }

        public void setMinLengthValue(String minLengthValue) {
            this.minLengthValue = minLengthValue;
        }

        public String getMinLengthValue() {
            return this.minLengthValue;
        }

        public void setCardinality(long cardinality) {
            this.cardinality = cardinality;
        }

        public long getCardinality() {
            return this.cardinality;
        }

        public void setDataSkewSamples(Map<String, Long> dataSkewSamples) {
            this.dataSkewSamples = dataSkewSamples;
        }

        public Map<String, Long> getDataSkewSamples() {
            return this.dataSkewSamples;
        }

        public void setColumnSamples(String max, String min, String maxLenValue, String minLenValue) {
            this.maxValue = max;
            this.minValue = min;
            this.maxLengthValue = maxLenValue;
            this.minLengthValue = minLenValue;
        }

        public long getNullCount() {
            return this.nullCount;
        }

        public void setNullCount(long nullCount) {
            this.nullCount = nullCount;
        }
    }
}

