/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segments<T extends ISegment>
extends ArrayList<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Segments.class);

    public static boolean sourceOffsetContains(ISegment a, ISegment b) {
        return a.getSourceOffsetStart() <= b.getSourceOffsetStart() && b.getSourceOffsetEnd() <= a.getSourceOffsetEnd();
    }

    public static boolean sourceOffsetOverlaps(ISegment a, ISegment b) {
        return a.getSourceOffsetStart() < b.getSourceOffsetEnd() && b.getSourceOffsetStart() < a.getSourceOffsetEnd();
    }

    public T getFirstSegment() {
        if (this == null || this.size() == 0) {
            return null;
        }
        return (T)((ISegment)this.get(0));
    }

    public long getDateRangeStart() {
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY);
        long startTime = Long.MAX_VALUE;
        for (ISegment seg : readySegs) {
            startTime = Math.min(startTime, seg.getDateRangeStart());
        }
        return startTime;
    }

    public long getDateRangeEnd() {
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY);
        long endTime = Long.MIN_VALUE;
        for (ISegment seg : readySegs) {
            endTime = Math.max(endTime, seg.getDateRangeEnd());
        }
        return endTime;
    }

    public T getLatestReadySegment() {
        ISegment latest = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            ISegment seg = (ISegment)this.get(i);
            if (seg.getStatus() != SegmentStatusEnum.READY || latest != null && latest.getDateRangeEnd() >= seg.getDateRangeEnd()) continue;
            latest = seg;
        }
        return (T)latest;
    }

    public T getLatestBuiltSegment() {
        ISegment latest = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            ISegment seg = (ISegment)this.get(i);
            if (seg.getLastBuildTime() <= 0L || latest != null && seg.getLastBuildTime() <= latest.getLastBuildTime()) continue;
            latest = seg;
        }
        return (T)latest;
    }

    public Segments<T> getSegments(SegmentStatusEnum status) {
        Segments<T> result = new Segments<T>();
        for (ISegment segment : this) {
            if (segment.getStatus() != status) continue;
            result.add(segment);
        }
        return result;
    }

    public T getSegment(String name, SegmentStatusEnum status) {
        for (ISegment segment : this) {
            if (null == segment.getName() || !segment.getName().equals(name) || status != null && segment.getStatus() != status) continue;
            return (T)segment;
        }
        return null;
    }

    public Segments<T> getBuildingSegments() {
        Segments<T> buildingSegments = new Segments<T>();
        if (null != this) {
            for (ISegment segment : this) {
                if (SegmentStatusEnum.NEW != segment.getStatus() && SegmentStatusEnum.READY_PENDING != segment.getStatus()) continue;
                buildingSegments.add(segment);
            }
        }
        return buildingSegments;
    }

    public Segments getMergingSegments(T mergedSegment) {
        Segments<T> result = new Segments<T>();
        if (mergedSegment == null) {
            return result;
        }
        for (ISegment seg : this) {
            if (seg.getStatus() != SegmentStatusEnum.READY && seg.getStatus() != SegmentStatusEnum.READY_PENDING || seg == mergedSegment || !Segments.sourceOffsetContains(mergedSegment, seg)) continue;
            if (result.size() > 0 && super.getLast().getSourceOffsetEnd() != seg.getSourceOffsetStart()) {
                throw new IllegalStateException("Merging segments must not have gaps between " + super.getLast() + " and " + seg);
            }
            result.add(seg);
        }
        return result;
    }

    public Pair<Long, Long> autoMergeCubeSegments(boolean needAutoMerge, String cubeName, long[] timeRanges) throws IOException {
        if (!needAutoMerge) {
            logger.debug("Cube " + cubeName + " doesn't need auto merge");
            return null;
        }
        int buildingSize = this.getBuildingSegments().size();
        if (buildingSize > 0) {
            logger.debug("Cube " + cubeName + " has " + buildingSize + " building segments");
        }
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY);
        Segments<T> mergingSegs = new Segments<T>();
        if (buildingSize > 0) {
            for (ISegment building : this.getBuildingSegments()) {
                for (ISegment ready : readySegs) {
                    if (ready.getSourceOffsetStart() < building.getSourceOffsetStart() || ready.getSourceOffsetEnd() > building.getSourceOffsetEnd()) continue;
                    mergingSegs.add(ready);
                }
            }
        }
        readySegs.removeAll(mergingSegs);
        Arrays.sort(timeRanges);
        for (int i = timeRanges.length - 1; i >= 0; --i) {
            long toMergeRange = timeRanges[i];
            for (int s = 0; s < readySegs.size(); ++s) {
                ISegment seg = (ISegment)readySegs.get(s);
                Pair<T, T> p = super.getSubList(s, readySegs.size()).findMergeOffsetsByDateRange(seg.getDateRangeStart(), seg.getDateRangeStart() + toMergeRange, toMergeRange);
                if (p == null || ((ISegment)p.getSecond()).getDateRangeEnd() - ((ISegment)p.getFirst()).getDateRangeStart() < toMergeRange) continue;
                return Pair.newPair(((ISegment)p.getFirst()).getSourceOffsetStart(), ((ISegment)p.getSecond()).getSourceOffsetEnd());
            }
        }
        return null;
    }

    public Pair<T, T> findMergeOffsetsByDateRange(long startDate, long endDate, long skipSegDateRangeCap) {
        Segments<T> result = new Segments<T>();
        for (ISegment seg : this) {
            if (startDate >= seg.getDateRangeEnd() || seg.getDateRangeStart() >= endDate) continue;
            if (seg.getDateRangeEnd() - seg.getDateRangeStart() > skipSegDateRangeCap || result.size() > 0 && super.getLast().getSourceOffsetEnd() != seg.getSourceOffsetStart()) break;
            result.add(seg);
        }
        if (result.size() <= 1) {
            return null;
        }
        return Pair.newPair(super.getFirst(), super.getLast());
    }

    public Segments calculateToBeSegments(ISegment newSegment) {
        Segments tobe = (Segments)this.clone();
        if (newSegment != null && !tobe.contains(newSegment)) {
            tobe.add(newSegment);
        }
        if (tobe.size() == 0) {
            return tobe;
        }
        Collections.sort(tobe);
        T firstSeg = tobe.getFirst();
        firstSeg.validate();
        int i = 0;
        int j = 1;
        while (j < tobe.size()) {
            ISegment is = (ISegment)tobe.get(i);
            ISegment js = (ISegment)tobe.get(j);
            js.validate();
            if (!this.isNew(is) && !this.isReady(is)) {
                tobe.remove(i);
                continue;
            }
            if (!this.isNew(js) && !this.isReady(js)) {
                tobe.remove(j);
                continue;
            }
            if (is.getSourceOffsetStart() == js.getSourceOffsetStart()) {
                if (this.isReady(is) && this.isReady(js) || this.isNew(is) && this.isNew(js)) {
                    if (is.getSourceOffsetEnd() <= js.getSourceOffsetEnd()) {
                        tobe.remove(i);
                        continue;
                    }
                    tobe.remove(j);
                    continue;
                }
                if (this.isNew(is) && is.equals(newSegment)) {
                    tobe.remove(j);
                    continue;
                }
                if (js.equals(newSegment)) {
                    tobe.remove(i);
                    continue;
                }
            }
            if (is.getSourceOffsetEnd() <= js.getSourceOffsetStart()) {
                ++i;
                ++j;
                continue;
            }
            if (is.equals(newSegment)) {
                tobe.remove(j);
                continue;
            }
            ++i;
            ++j;
        }
        return tobe;
    }

    private boolean isReady(ISegment seg) {
        return seg.getStatus() == SegmentStatusEnum.READY;
    }

    private boolean isNew(ISegment seg) {
        return seg.getStatus() == SegmentStatusEnum.NEW || seg.getStatus() == SegmentStatusEnum.READY_PENDING;
    }

    @Override
    private T getLast() {
        assert (this.size() != 0);
        return (T)((ISegment)this.get(this.size() - 1));
    }

    @Override
    private T getFirst() {
        assert (this.size() != 0);
        return (T)((ISegment)this.get(0));
    }

    private Segments<T> getSubList(int from, int to) {
        Segments<T> result = new Segments<T>();
        for (ISegment seg : this.subList(from, to)) {
            result.add(seg);
        }
        return result;
    }
}

