/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

public class JoinsTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Map<String, Chain> tableChains = new LinkedHashMap<String, Chain>();

    public JoinsTree(TableRef rootTable, List<JoinDesc> joins) {
        for (JoinDesc join : joins) {
            for (TblColRef col : join.getForeignKeyColumns()) {
                Preconditions.checkState((boolean)col.isQualified());
            }
            for (TblColRef col : join.getPrimaryKeyColumns()) {
                Preconditions.checkState((boolean)col.isQualified());
            }
        }
        this.tableChains.put(rootTable.getAlias(), new Chain(rootTable, null, null));
        for (JoinDesc join : joins) {
            TableRef pkSide = join.getPKSide();
            Chain fkSide = this.tableChains.get(join.getFKSide().getAlias());
            this.tableChains.put(pkSide.getAlias(), new Chain(pkSide, join, fkSide));
        }
    }

    public Map<String, String> matches(JoinsTree another) {
        return this.matches(another, Collections.emptyMap());
    }

    public Map<String, String> matches(JoinsTree another, Map<String, String> constraints) {
        HashMap<String, String> matchUp = new HashMap<String, String>();
        for (Chain chain : this.tableChains.values()) {
            if (this.matchInTree(chain, another, constraints, matchUp)) continue;
            return null;
        }
        return matchUp;
    }

    public int matchNum(JoinsTree another) {
        HashMap<String, String> matchUp = new HashMap<String, String>();
        for (Chain chain : this.tableChains.values()) {
            this.matchInTree(chain, another, Collections.emptyMap(), matchUp);
        }
        return matchUp.size();
    }

    private boolean matchInTree(Chain chain, JoinsTree another, Map<String, String> constraints, Map<String, String> matchUp) {
        String thisAlias = chain.table.getAlias();
        if (matchUp.containsKey(thisAlias)) {
            return true;
        }
        String constraint = constraints.get(thisAlias);
        if (constraint != null) {
            return this.matchChain(chain, another.tableChains.get(constraint), matchUp);
        }
        for (Chain anotherChain : another.tableChains.values()) {
            if (!this.matchChain(chain, anotherChain, matchUp)) continue;
            return true;
        }
        return false;
    }

    private boolean matchChain(Chain chain, Chain anotherChain, Map<String, String> matchUp) {
        String thisAlias = chain.table.getAlias();
        String anotherAlias = anotherChain.table.getAlias();
        String curMatch = matchUp.get(thisAlias);
        if (curMatch != null) {
            return curMatch.equals(anotherAlias);
        }
        if (curMatch == null && matchUp.values().contains(anotherAlias)) {
            return false;
        }
        boolean matches = false;
        if (chain.join == null) {
            matches = anotherChain.join == null && chain.table.getTableDesc().getIdentity().equals(anotherChain.table.getTableDesc().getIdentity());
        } else {
            boolean bl = matches = chain.join.matches(anotherChain.join) && this.matchChain(chain.fkSide, anotherChain.fkSide, matchUp);
        }
        if (matches) {
            matchUp.put(thisAlias, anotherAlias);
        }
        return matches;
    }

    public JoinDesc getJoinByPKSide(TableRef table) {
        Chain chain = this.tableChains.get(table.getAlias());
        if (chain == null) {
            return null;
        }
        return chain.join;
    }

    public static class Chain
    implements Serializable {
        private static final long serialVersionUID = 1L;
        TableRef table;
        JoinDesc join;
        Chain fkSide;

        public Chain(TableRef table, JoinDesc join, Chain fkSide) {
            this.table = table;
            this.join = join;
            this.fkSide = fkSide;
            if (join != null) {
                Preconditions.checkArgument((table == join.getPKSide() ? 1 : 0) != 0);
                Preconditions.checkArgument((fkSide.table == join.getFKSide() ? 1 : 0) != 0);
            }
        }
    }
}

