/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.filter.function.Functions;
import org.apache.kylin.metadata.model.ISourceAware;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ExternalFilterDesc
extends RootPersistentEntity
implements ISourceAware {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="filter_resource_identifier")
    private String filterResourceIdentifier;
    @JsonProperty(value="filter_table_type")
    private Functions.FilterTableType filterTableType;
    @JsonProperty(value="source_type")
    private int sourceType = 7;
    @JsonProperty(value="description")
    private String description;

    public String getResourcePath() {
        return ExternalFilterDesc.concatResourcePath(this.getName());
    }

    public static String concatResourcePath(String name) {
        return "/ext_filter/" + name + ".json";
    }

    public String getFilterResourceIdentifier() {
        return this.filterResourceIdentifier;
    }

    public void setFilterResourceIdentifier(String filterResourceIdentifier) {
        this.filterResourceIdentifier = filterResourceIdentifier;
    }

    public Functions.FilterTableType getFilterTableType() {
        return this.filterTableType;
    }

    public void setFilterTableType(Functions.FilterTableType filterTableType) {
        this.filterTableType = filterTableType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void init() {
        if (this.name != null) {
            this.name = this.name.toUpperCase();
        }
    }

    public String toString() {
        return "ExternalFilterDesc [ name=" + this.name + " filter table resource identifier " + this.filterResourceIdentifier + "]";
    }

    public static ExternalFilterDesc mockup(String tableName) {
        ExternalFilterDesc mockup = new ExternalFilterDesc();
        mockup.setName(tableName);
        return mockup;
    }

    @Override
    public int getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

