/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.kylin.metadata.model.tool.CalciteParser;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ComputedColumnDesc
implements Serializable {
    @JsonProperty
    private String tableIdentity;
    @JsonProperty
    private String columnName;
    @JsonProperty
    private String expression;
    @JsonProperty
    private String datatype;
    @JsonProperty
    private String comment;

    public void init() {
        Preconditions.checkNotNull((Object)this.tableIdentity, (Object)"tableIdentity is null");
        Preconditions.checkNotNull((Object)this.columnName, (Object)"columnName is null");
        Preconditions.checkNotNull((Object)this.expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)this.datatype, (Object)"datatype is null");
        Preconditions.checkState((boolean)this.tableIdentity.equals(this.tableIdentity.trim()), (Object)"tableIdentity of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.columnName.equals(this.columnName.trim()), (Object)"columnName of ComputedColumnDesc has heading/tailing whitespace");
        Preconditions.checkState((boolean)this.datatype.equals(this.datatype.trim()), (Object)"datatype of ComputedColumnDesc has heading/tailing whitespace");
        this.tableIdentity = this.tableIdentity.toUpperCase();
        this.columnName = this.columnName.toUpperCase();
        if ("true".equals(System.getProperty("needCheckCC"))) {
            CalciteParser.ensureNoTableNameExists(this.expression);
        }
    }

    public String getFullName() {
        return this.tableIdentity + "." + this.columnName;
    }

    public String getTableIdentity() {
        return this.tableIdentity;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputedColumnDesc that = (ComputedColumnDesc)o;
        if (!this.tableIdentity.equals(that.tableIdentity)) {
            return false;
        }
        if (!this.columnName.equals(that.columnName)) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.datatype.equals(that.datatype);
    }

    public int hashCode() {
        int result = this.tableIdentity.hashCode();
        result = 31 * result + this.columnName.hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.datatype.hashCode();
        return result;
    }
}

