/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TupleFilter {
    static final Logger logger = LoggerFactory.getLogger(TupleFilter.class);
    public static final int BUFFER_SIZE = 10240;
    protected static final Map<FilterOperatorEnum, FilterOperatorEnum> REVERSE_OP_MAP = Maps.newHashMap();
    protected static final Map<FilterOperatorEnum, FilterOperatorEnum> SWAP_OP_MAP = Maps.newHashMap();
    protected final List<TupleFilter> children;
    protected FilterOperatorEnum operator;

    protected TupleFilter(List<TupleFilter> filters, FilterOperatorEnum op) {
        this.children = filters;
        this.operator = op;
    }

    public void addChild(TupleFilter child) {
        this.children.add(child);
    }

    public final void addChildren(List<? extends TupleFilter> children) {
        for (TupleFilter tupleFilter : children) {
            this.addChild(tupleFilter);
        }
    }

    public List<? extends TupleFilter> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public FilterOperatorEnum getOperator() {
        return this.operator;
    }

    public TupleFilter copy() {
        throw new UnsupportedOperationException();
    }

    public TupleFilter reverse() {
        logger.warn("Cannot reverse " + this + ", loosen the filter to true");
        return ConstantTupleFilter.TRUE;
    }

    public TupleFilter flatFilter() {
        return this.flattenInternal(this);
    }

    private TupleFilter flattenInternal(TupleFilter filter) {
        TupleFilter flatFilter = null;
        if (!(filter instanceof LogicalTupleFilter)) {
            flatFilter = new LogicalTupleFilter(FilterOperatorEnum.AND);
            flatFilter.addChild(filter);
            return flatFilter;
        }
        FilterOperatorEnum op = filter.getOperator();
        LinkedList<TupleFilter> andChildren = new LinkedList<TupleFilter>();
        LinkedList<TupleFilter> orChildren = new LinkedList<TupleFilter>();
        for (TupleFilter tupleFilter : filter.getChildren()) {
            TupleFilter flatChild = this.flattenInternal(tupleFilter);
            FilterOperatorEnum childOp = flatChild.getOperator();
            if (childOp == FilterOperatorEnum.AND) {
                andChildren.add(flatChild);
                continue;
            }
            if (childOp == FilterOperatorEnum.OR) {
                orChildren.add(flatChild);
                continue;
            }
            throw new IllegalStateException("Filter is " + filter + " and child is " + flatChild);
        }
        if (op == FilterOperatorEnum.AND) {
            flatFilter = new LogicalTupleFilter(FilterOperatorEnum.AND);
            for (TupleFilter tupleFilter : andChildren) {
                flatFilter.addChildren(tupleFilter.getChildren());
            }
            if (!orChildren.isEmpty()) {
                List<TupleFilter> fullAndFilters = this.cartesianProduct(orChildren, flatFilter);
                flatFilter = new LogicalTupleFilter(FilterOperatorEnum.OR);
                flatFilter.addChildren(fullAndFilters);
            }
        } else if (op == FilterOperatorEnum.OR) {
            flatFilter = new LogicalTupleFilter(FilterOperatorEnum.OR);
            for (TupleFilter tupleFilter : orChildren) {
                flatFilter.addChildren(tupleFilter.getChildren());
            }
            flatFilter.addChildren(andChildren);
        } else if (op == FilterOperatorEnum.NOT) {
            assert (filter.children.size() == 1);
            TupleFilter reverse = filter.children.get(0).reverse();
            flatFilter = this.flattenInternal(reverse);
        } else {
            throw new IllegalStateException("Filter is " + filter);
        }
        return flatFilter;
    }

    private List<TupleFilter> cartesianProduct(List<TupleFilter> leftOrFilters, TupleFilter partialAndFilter) {
        LinkedList<TupleFilter> oldProductFilters = new LinkedList<TupleFilter>();
        oldProductFilters.add(partialAndFilter);
        for (TupleFilter orFilter : leftOrFilters) {
            LinkedList<TupleFilter> newProductFilters = new LinkedList<TupleFilter>();
            for (TupleFilter tupleFilter : orFilter.getChildren()) {
                for (TupleFilter productFilter : oldProductFilters) {
                    TupleFilter fullAndFilter = productFilter.copy();
                    fullAndFilter.addChildren(tupleFilter.getChildren());
                    newProductFilters.add(fullAndFilter);
                }
            }
            oldProductFilters = newProductFilters;
        }
        return oldProductFilters;
    }

    public abstract boolean isEvaluable();

    public abstract boolean evaluate(IEvaluatableTuple var1, IFilterCodeSystem<?> var2);

    public abstract Collection<?> getValues();

    public abstract void serialize(IFilterCodeSystem<?> var1, ByteBuffer var2);

    public abstract void deserialize(IFilterCodeSystem<?> var1, ByteBuffer var2);

    public static boolean isEvaluableRecursively(TupleFilter filter) {
        if (filter == null) {
            return true;
        }
        if (!filter.isEvaluable()) {
            return false;
        }
        for (TupleFilter tupleFilter : filter.getChildren()) {
            if (TupleFilter.isEvaluableRecursively(tupleFilter)) continue;
            return false;
        }
        return true;
    }

    public static void collectColumns(TupleFilter filter, Set<TblColRef> collector) {
        if (filter == null || collector == null) {
            return;
        }
        if (filter instanceof ColumnTupleFilter) {
            ColumnTupleFilter columnTupleFilter = (ColumnTupleFilter)filter;
            collector.add(columnTupleFilter.getColumn());
        }
        for (TupleFilter tupleFilter : filter.getChildren()) {
            TupleFilter.collectColumns(tupleFilter, collector);
        }
    }

    public static TupleFilter and(TupleFilter f1, TupleFilter f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null) {
            return f1;
        }
        if (f1.getOperator() == FilterOperatorEnum.AND) {
            f1.addChild(f2);
            return f1;
        }
        if (f2.getOperator() == FilterOperatorEnum.AND) {
            f2.addChild(f1);
            return f2;
        }
        LogicalTupleFilter and = new LogicalTupleFilter(FilterOperatorEnum.AND);
        and.addChild(f1);
        and.addChild(f2);
        return and;
    }

    static {
        REVERSE_OP_MAP.put(FilterOperatorEnum.EQ, FilterOperatorEnum.NEQ);
        REVERSE_OP_MAP.put(FilterOperatorEnum.NEQ, FilterOperatorEnum.EQ);
        REVERSE_OP_MAP.put(FilterOperatorEnum.GT, FilterOperatorEnum.LTE);
        REVERSE_OP_MAP.put(FilterOperatorEnum.LTE, FilterOperatorEnum.GT);
        REVERSE_OP_MAP.put(FilterOperatorEnum.LT, FilterOperatorEnum.GTE);
        REVERSE_OP_MAP.put(FilterOperatorEnum.GTE, FilterOperatorEnum.LT);
        REVERSE_OP_MAP.put(FilterOperatorEnum.IN, FilterOperatorEnum.NOTIN);
        REVERSE_OP_MAP.put(FilterOperatorEnum.NOTIN, FilterOperatorEnum.IN);
        REVERSE_OP_MAP.put(FilterOperatorEnum.ISNULL, FilterOperatorEnum.ISNOTNULL);
        REVERSE_OP_MAP.put(FilterOperatorEnum.ISNOTNULL, FilterOperatorEnum.ISNULL);
        REVERSE_OP_MAP.put(FilterOperatorEnum.AND, FilterOperatorEnum.OR);
        REVERSE_OP_MAP.put(FilterOperatorEnum.OR, FilterOperatorEnum.AND);
        SWAP_OP_MAP.put(FilterOperatorEnum.EQ, FilterOperatorEnum.EQ);
        SWAP_OP_MAP.put(FilterOperatorEnum.NEQ, FilterOperatorEnum.NEQ);
        SWAP_OP_MAP.put(FilterOperatorEnum.GT, FilterOperatorEnum.LT);
        SWAP_OP_MAP.put(FilterOperatorEnum.LTE, FilterOperatorEnum.GTE);
        SWAP_OP_MAP.put(FilterOperatorEnum.LT, FilterOperatorEnum.GT);
        SWAP_OP_MAP.put(FilterOperatorEnum.GTE, FilterOperatorEnum.LTE);
    }

    public static enum FilterOperatorEnum {
        EQ(1),
        NEQ(2),
        GT(3),
        LT(4),
        GTE(5),
        LTE(6),
        ISNULL(7),
        ISNOTNULL(8),
        IN(9),
        NOTIN(10),
        AND(20),
        OR(21),
        NOT(22),
        COLUMN(30),
        CONSTANT(31),
        DYNAMIC(32),
        EXTRACT(33),
        CASE(34),
        FUNCTION(35),
        MASSIN(36),
        EVAL_FUNC(37),
        UNSUPPORTED(38);

        private final int value;

        private FilterOperatorEnum(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

