/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.draft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.metadata.draft.Draft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DraftManager {
    private static final Logger logger = LoggerFactory.getLogger(DraftManager.class);
    public static final Serializer<Draft> DRAFT_SERIALIZER = new JsonSerializer<Draft>(Draft.class);
    private static final ConcurrentMap<KylinConfig, DraftManager> CACHE = new ConcurrentHashMap<KylinConfig, DraftManager>();
    private KylinConfig config;

    public static DraftManager getInstance(KylinConfig config) {
        DraftManager r = (DraftManager)CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<DraftManager> clazz = DraftManager.class;
        synchronized (DraftManager.class) {
            r = (DraftManager)CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new DraftManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init DraftManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static void clearCache(KylinConfig kylinConfig) {
        if (kylinConfig != null) {
            CACHE.remove(kylinConfig);
        }
    }

    private DraftManager(KylinConfig config) throws IOException {
        this.config = config;
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public List<Draft> list(String project) throws IOException {
        ArrayList<Draft> result = new ArrayList<Draft>();
        ResourceStore store = this.getStore();
        NavigableSet<String> listPath = store.listResources("/draft");
        if (listPath == null) {
            return result;
        }
        for (String path : listPath) {
            Draft draft = store.getResource(path, Draft.class, DRAFT_SERIALIZER);
            if (draft == null || project != null && !project.equals(draft.getProject())) continue;
            result.add(draft);
        }
        return result;
    }

    public void save(String project, String uuid, RootPersistentEntity ... entities) throws IOException {
        Draft draft = new Draft();
        draft.setProject(project);
        draft.setUuid(uuid);
        draft.setEntities(entities);
        this.save(draft);
    }

    public void save(Draft draft) throws IOException {
        if (draft.getUuid() == null) {
            throw new IllegalArgumentException();
        }
        Draft youngerSelf = this.load(draft.getUuid());
        if (youngerSelf != null) {
            draft.setLastModified(youngerSelf.getLastModified());
        }
        ResourceStore store = this.getStore();
        store.putResource(draft.getResourcePath(), draft, DRAFT_SERIALIZER);
        logger.info("Saved " + draft);
    }

    public Draft load(String uuid) throws IOException {
        ResourceStore store = this.getStore();
        Draft draft = store.getResource(Draft.concatResourcePath(uuid), Draft.class, DRAFT_SERIALIZER);
        return draft;
    }

    public void delete(String uuid) throws IOException {
        ResourceStore store = this.getStore();
        store.deleteResource(Draft.concatResourcePath(uuid));
    }
}

