/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.percentile;

import java.nio.ByteBuffer;
import org.apache.kylin.measure.percentile.PercentileCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class PercentileSerializer
extends DataTypeSerializer<PercentileCounter> {
    private transient ThreadLocal<PercentileCounter> current = null;
    private double compression;

    public PercentileSerializer(DataType type) {
        this.compression = type.getPrecision();
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return this.current().peekLength(in);
    }

    @Override
    public int maxLength() {
        return this.current().maxLength();
    }

    @Override
    public int getStorageBytesEstimate() {
        return this.current().getBytesEstimate();
    }

    private PercentileCounter current() {
        PercentileCounter counter;
        if (this.current == null) {
            this.current = new ThreadLocal();
        }
        if ((counter = this.current.get()) == null) {
            counter = new PercentileCounter(this.compression);
            this.current.set(counter);
        }
        return counter;
    }

    @Override
    public void serialize(PercentileCounter value, ByteBuffer out) {
        value.writeRegisters(out);
    }

    @Override
    public PercentileCounter deserialize(ByteBuffer in) {
        PercentileCounter counter = this.current();
        counter.readRegisters(in);
        return counter;
    }
}

