/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.percentile;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.kylin.coprocessor.shaded.com.tdunning.math.stats.AVLTreeDigest;
import org.apache.kylin.coprocessor.shaded.com.tdunning.math.stats.TDigest;

public class PercentileCounter
implements Serializable {
    private static final double INVALID_QUANTILE_RATIO = -1.0;
    double compression;
    double quantileRatio;
    transient TDigest registers;

    public PercentileCounter(double compression) {
        this(compression, -1.0);
    }

    public PercentileCounter(PercentileCounter another) {
        this(another.compression, another.quantileRatio);
        this.merge(another);
    }

    public PercentileCounter(double compression, double quantileRatio) {
        this.compression = compression;
        this.quantileRatio = quantileRatio;
        this.reInitRegisters();
    }

    private void reInitRegisters() {
        this.registers = TDigest.createAvlTreeDigest(this.compression);
    }

    public void add(double v) {
        this.registers.add(v);
    }

    public void merge(PercentileCounter counter) {
        assert (this.compression == counter.compression);
        this.registers.add(counter.registers);
    }

    public double getResultEstimate() {
        return this.registers.quantile(this.quantileRatio);
    }

    public void writeRegisters(ByteBuffer out) {
        this.registers.compress();
        this.registers.asSmallBytes(out);
    }

    public void readRegisters(ByteBuffer in) {
        this.registers = AVLTreeDigest.fromBytes(in);
        this.compression = this.registers.compression();
    }

    public int getBytesEstimate() {
        return this.maxLength();
    }

    public int maxLength() {
        return 10240;
    }

    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        AVLTreeDigest.fromBytes(in);
        int total = in.position() - mark;
        in.position(mark);
        return total;
    }

    public void clear() {
        this.reInitRegisters();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.registers.compress();
        int bound = this.registers.byteSize();
        ByteBuffer buf = ByteBuffer.allocate(bound);
        this.registers.asSmallBytes(buf);
        out.defaultWriteObject();
        out.writeInt(bound);
        out.write(buf.array(), 0, bound);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int bound = in.readInt();
        ByteBuffer buf = ByteBuffer.allocate(bound);
        in.read(buf.array(), 0, bound);
        this.registers = AVLTreeDigest.fromBytes(buf);
    }
}

