/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.measure.ParamAsMeasureCount;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapCounterFactory;
import org.apache.kylin.measure.bitmap.RoaringBitmapCounterFactory;

public class BitmapIntersectDistinctCountAggFunc
implements ParamAsMeasureCount {
    private static final BitmapCounterFactory factory = RoaringBitmapCounterFactory.INSTANCE;

    @Override
    public int getParamAsMeasureCount() {
        return -2;
    }

    public static RetentionPartialResult init() {
        return new RetentionPartialResult();
    }

    public static RetentionPartialResult add(RetentionPartialResult result, Object value, Object key, List keyList) {
        result.add(key, keyList, value);
        return result;
    }

    public static RetentionPartialResult merge(RetentionPartialResult result, Object value, Object key, List keyList) {
        return BitmapIntersectDistinctCountAggFunc.add(result, value, key, keyList);
    }

    public static long result(RetentionPartialResult result) {
        return result.result();
    }

    public static class RetentionPartialResult {
        Map<Object, BitmapCounter> map = new LinkedHashMap<Object, BitmapCounter>();
        List keyList;

        public void add(Object key, List keyList, Object value) {
            if (this.keyList == null) {
                this.keyList = keyList;
            }
            if (this.keyList != null && this.keyList.contains(key)) {
                BitmapCounter counter = this.map.get(key);
                if (counter == null) {
                    counter = factory.newBitmap();
                    this.map.put(key, counter);
                }
                counter.orWith((BitmapCounter)value);
            }
        }

        public long result() {
            if (this.keyList == null || this.keyList.isEmpty()) {
                return 0L;
            }
            for (Object key : this.keyList) {
                if (this.map.containsKey(key)) continue;
                return 0L;
            }
            BitmapCounter counter = null;
            for (Object key : this.keyList) {
                BitmapCounter c = this.map.get(key);
                if (counter == null) {
                    counter = factory.newBitmap();
                    counter.orWith(c);
                    continue;
                }
                counter.andWith(c);
            }
            return counter.getCount();
        }
    }
}

