/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable.memstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStore;
import org.apache.kylin.gridtable.IGTWriter;

public class GTSimpleMemStore
implements IGTStore {
    protected final GTInfo info;
    protected final List<byte[]> rowList;

    protected GTSimpleMemStore(GTInfo info, List<byte[]> rowList) {
        this.info = info;
        this.rowList = rowList;
    }

    public GTSimpleMemStore(GTInfo info) {
        this.info = info;
        this.rowList = new ArrayList<byte[]>();
    }

    public List<byte[]> getRowList() {
        return this.rowList;
    }

    @Override
    public GTInfo getInfo() {
        return this.info;
    }

    public long memoryUsage() {
        long sum = 0L;
        for (byte[] bytes : this.rowList) {
            sum += (long)bytes.length;
        }
        return sum;
    }

    @Override
    public IGTWriter rebuild() {
        this.rowList.clear();
        return new Writer();
    }

    @Override
    public IGTWriter append() {
        return new Writer();
    }

    protected ImmutableBitSet getColumns() {
        return this.info.getAllColumns();
    }

    @Override
    public IGTScanner scan(GTScanRequest scanRequest) {
        return new IGTScanner(){
            long count;

            @Override
            public GTInfo getInfo() {
                return GTSimpleMemStore.this.info;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public Iterator<GTRecord> iterator() {
                this.count = 0L;
                return new Iterator<GTRecord>(){
                    Iterator<byte[]> it;
                    GTRecord oneRecord;
                    {
                        this.it = GTSimpleMemStore.this.rowList.iterator();
                        this.oneRecord = new GTRecord(GTSimpleMemStore.this.info);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public GTRecord next() {
                        byte[] bytes = this.it.next();
                        this.oneRecord.loadColumns(GTSimpleMemStore.this.getColumns(), ByteBuffer.wrap(bytes));
                        ++count;
                        return this.oneRecord;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void drop() throws IOException {
        this.rowList.clear();
    }

    private class Writer
    implements IGTWriter {
        private Writer() {
        }

        @Override
        public void write(GTRecord r) throws IOException {
            ByteArray byteArray = r.exportColumns(GTSimpleMemStore.this.info.getAllColumns()).copy();
            assert (byteArray.offset() == 0);
            assert (byteArray.array().length == byteArray.length());
            GTSimpleMemStore.this.rowList.add(byteArray.array());
        }

        @Override
        public void close() throws IOException {
        }
    }
}

