/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.util.BitSet;
import java.util.List;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTScanRange;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.StorageSideBehavior;
import org.apache.kylin.metadata.filter.TupleFilter;

public class GTScanRequestBuilder {
    private GTInfo info;
    private List<GTScanRange> ranges;
    private TupleFilter filterPushDown;
    private TupleFilter havingFilterPushDown;
    private ImmutableBitSet dimensions;
    private ImmutableBitSet aggrGroupBy = null;
    private ImmutableBitSet aggrMetrics = null;
    private String[] aggrMetricsFuncs = null;
    private boolean allowStorageAggregation = true;
    private double aggCacheMemThreshold = 0.0;
    private int storageScanRowNumThreshold = Integer.MAX_VALUE;
    private int storagePushDownLimit = Integer.MAX_VALUE;
    private long startTime = -1L;
    private long timeout = -1L;
    private String storageBehavior = null;

    public GTScanRequestBuilder setInfo(GTInfo info) {
        this.info = info;
        return this;
    }

    public GTScanRequestBuilder setRanges(List<GTScanRange> ranges) {
        this.ranges = ranges;
        return this;
    }

    public GTScanRequestBuilder setFilterPushDown(TupleFilter filterPushDown) {
        this.filterPushDown = filterPushDown;
        return this;
    }

    public GTScanRequestBuilder setHavingFilterPushDown(TupleFilter havingFilterPushDown) {
        this.havingFilterPushDown = havingFilterPushDown;
        return this;
    }

    public GTScanRequestBuilder setDimensions(ImmutableBitSet dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public GTScanRequestBuilder setAggrGroupBy(ImmutableBitSet aggrGroupBy) {
        this.aggrGroupBy = aggrGroupBy;
        return this;
    }

    public GTScanRequestBuilder setAggrMetrics(ImmutableBitSet aggrMetrics) {
        this.aggrMetrics = aggrMetrics;
        return this;
    }

    public GTScanRequestBuilder setAggrMetricsFuncs(String[] aggrMetricsFuncs) {
        this.aggrMetricsFuncs = aggrMetricsFuncs;
        return this;
    }

    public GTScanRequestBuilder setAllowStorageAggregation(boolean allowStorageAggregation) {
        this.allowStorageAggregation = allowStorageAggregation;
        return this;
    }

    public GTScanRequestBuilder setAggCacheMemThreshold(double aggCacheMemThreshold) {
        this.aggCacheMemThreshold = aggCacheMemThreshold;
        return this;
    }

    public GTScanRequestBuilder setStorageScanRowNumThreshold(int storageScanRowNumThreshold) {
        this.storageScanRowNumThreshold = storageScanRowNumThreshold;
        return this;
    }

    public GTScanRequestBuilder setStoragePushDownLimit(int storagePushDownLimit) {
        this.storagePushDownLimit = storagePushDownLimit;
        return this;
    }

    public GTScanRequestBuilder setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public GTScanRequestBuilder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public GTScanRequestBuilder setStorageBehavior(String storageBehavior) {
        this.storageBehavior = storageBehavior;
        return this;
    }

    public GTScanRequest createGTScanRequest() {
        if (this.aggrGroupBy == null) {
            this.aggrGroupBy = new ImmutableBitSet(new BitSet());
        }
        if (this.aggrMetrics == null) {
            this.aggrMetrics = new ImmutableBitSet(new BitSet());
        }
        if (this.aggrMetricsFuncs == null) {
            this.aggrMetricsFuncs = new String[0];
        }
        if (this.storageBehavior == null) {
            this.storageBehavior = BackdoorToggles.getCoprocessorBehavior() == null ? StorageSideBehavior.SCAN_FILTER_AGGR_CHECKMEM.toString() : BackdoorToggles.getCoprocessorBehavior();
        }
        this.startTime = this.startTime == -1L ? System.currentTimeMillis() : this.startTime;
        this.timeout = this.timeout == -1L ? 300000L : this.timeout;
        return new GTScanRequest(this.info, this.ranges, this.dimensions, this.aggrGroupBy, this.aggrMetrics, this.aggrMetricsFuncs, this.filterPushDown, this.havingFilterPushDown, this.allowStorageAggregation, this.aggCacheMemThreshold, this.storageScanRowNumThreshold, this.storagePushDownLimit, this.storageBehavior, this.startTime, this.timeout);
    }
}

