/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.gridtable.DefaultGTComparator;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.gridtable.IGTComparator;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class GTSampleCodeSystem
implements IGTCodeSystem {
    private GTInfo info;
    private DataTypeSerializer[] serializers;
    private IGTComparator comparator;
    public static final BytesSerializer<IGTCodeSystem> serializer = new BytesSerializer<IGTCodeSystem>(){

        @Override
        public void serialize(IGTCodeSystem value, ByteBuffer out) {
        }

        @Override
        public IGTCodeSystem deserialize(ByteBuffer in) {
            return new GTSampleCodeSystem();
        }
    };

    @Override
    public void init(GTInfo info) {
        this.info = info;
        this.serializers = new DataTypeSerializer[info.getColumnCount()];
        for (int i = 0; i < info.getColumnCount(); ++i) {
            this.serializers[i] = DataTypeSerializer.create(info.colTypes[i]);
        }
        this.comparator = new DefaultGTComparator();
    }

    @Override
    public int codeLength(int col, ByteBuffer buf) {
        return this.serializers[col].peekLength(buf);
    }

    @Override
    public int maxCodeLength(int col) {
        return this.serializers[col].maxLength();
    }

    @Override
    public DimensionEncoding getDimEnc(int col) {
        return null;
    }

    @Override
    public IGTComparator getComparator() {
        return this.comparator;
    }

    @Override
    public MeasureAggregator<?>[] newMetricsAggregators(ImmutableBitSet columns, String[] aggrFunctions) {
        assert (columns.trueBitCount() == aggrFunctions.length);
        MeasureAggregator[] result = new MeasureAggregator[aggrFunctions.length];
        for (int i = 0; i < result.length; ++i) {
            int col = columns.trueBitAt(i);
            result[i] = MeasureAggregator.create(aggrFunctions[i], this.info.getColumnType(col));
        }
        return result;
    }

    @Override
    public void encodeColumnValue(int col, Object value, ByteBuffer buf) {
        this.serializers[col].serialize(value, buf);
    }

    @Override
    public void encodeColumnValue(int col, Object value, int roundingFlag, ByteBuffer buf) {
        this.encodeColumnValue(col, value, buf);
    }

    @Override
    public Object decodeColumnValue(int col, ByteBuffer buf) {
        return this.serializers[col].deserialize(buf);
    }
}

