/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.global;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.dict.global.AppendDictNode;
import org.apache.kylin.dict.global.AppendDictSlice;
import org.apache.kylin.dict.global.AppendDictSliceKey;
import org.apache.kylin.dict.global.GlobalDictMetadata;

public abstract class GlobalDictStore {
    protected final String baseDir;
    protected final int maxVersions;
    protected final int versionTTL;

    protected GlobalDictStore(String baseDir) {
        this.baseDir = (String)Preconditions.checkNotNull((Object)baseDir, (Object)"baseDir");
        this.maxVersions = KylinConfig.getInstanceFromEnv().getAppendDictMaxVersions();
        this.versionTTL = KylinConfig.getInstanceFromEnv().getAppendDictVersionTTL();
    }

    abstract void prepareForWrite(String var1) throws IOException;

    public abstract Long[] listAllVersions() throws IOException;

    public abstract Path getVersionDir(long var1);

    public abstract GlobalDictMetadata getMetadata(long var1) throws IOException;

    public abstract AppendDictSlice readSlice(String var1, String var2) throws IOException;

    public abstract String writeSlice(String var1, AppendDictSliceKey var2, AppendDictNode var3) throws IOException;

    public abstract void deleteSlice(String var1, String var2) throws IOException;

    public abstract void commit(String var1, GlobalDictMetadata var2) throws IOException;

    public abstract String copyToAnotherMeta(KylinConfig var1, KylinConfig var2) throws IOException;
}

