/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryValueEnumerator;

public class MultipleDictionaryValueEnumerator
implements IDictionaryValueEnumerator {
    private int curDictIndex = 0;
    private Dictionary<String> curDict;
    private int curKey;
    private String curValue = null;
    private List<Dictionary<String>> dictionaryList;

    public MultipleDictionaryValueEnumerator(List<DictionaryInfo> dictionaryInfoList) {
        this.dictionaryList = Lists.newArrayListWithCapacity((int)dictionaryInfoList.size());
        for (DictionaryInfo dictInfo : dictionaryInfoList) {
            this.dictionaryList.add(dictInfo.getDictionaryObject());
        }
        if (!this.dictionaryList.isEmpty()) {
            this.curDict = this.dictionaryList.get(0);
            this.curKey = this.curDict.getMinId();
        }
    }

    @Override
    public String current() throws IOException {
        return this.curValue;
    }

    @Override
    public boolean moveNext() throws IOException {
        while (this.curDictIndex < this.dictionaryList.size()) {
            if (this.curKey <= this.curDict.getMaxId()) {
                this.curValue = this.curDict.getValueFromId(this.curKey);
                ++this.curKey;
                return true;
            }
            if (++this.curDictIndex >= this.dictionaryList.size()) continue;
            this.curDict = this.dictionaryList.get(this.curDictIndex);
            this.curKey = this.curDict.getMinId();
        }
        this.curValue = null;
        return false;
    }

    @Override
    public void close() throws IOException {
    }
}

