/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.BytesConverter;

public abstract class CacheDictionary<T>
extends Dictionary<T> {
    private static final long serialVersionUID = 1L;
    private transient SoftReference<ConcurrentHashMap> valueToIdCache;
    private transient SoftReference<Object[]> idToValueCache;
    protected transient int baseId;
    protected BytesConverter<T> bytesConvert;

    @Override
    protected final int getIdFromValueImpl(T value, int roundingFlag) {
        Map cache;
        if (this.valueToIdCache != null && roundingFlag == 0 && (cache = (Map)this.valueToIdCache.get()) != null) {
            Integer id = (Integer)cache.get(value);
            if (id != null) {
                return id;
            }
            byte[] valueBytes = this.bytesConvert.convertToBytes(value);
            id = this.getIdFromValueBytesWithoutCache(valueBytes, 0, valueBytes.length, roundingFlag);
            cache.put(value, id);
            return id;
        }
        byte[] valueBytes = this.bytesConvert.convertToBytes(value);
        return this.getIdFromValueBytesWithoutCache(valueBytes, 0, valueBytes.length, roundingFlag);
    }

    @Override
    protected final T getValueFromIdImpl(int id) {
        Object[] cache;
        if (this.idToValueCache != null && (cache = this.idToValueCache.get()) != null) {
            int seq = this.calcSeqNoFromId(id);
            if (cache[seq] != null) {
                return (T)cache[seq];
            }
            byte[] valueBytes = this.getValueBytesFromIdWithoutCache(id);
            T value = this.bytesConvert.convertFromBytes(valueBytes, 0, valueBytes.length);
            cache[seq] = value;
            return value;
        }
        byte[] valueBytes = this.getValueBytesFromIdWithoutCache(id);
        return this.bytesConvert.convertFromBytes(valueBytes, 0, valueBytes.length);
    }

    protected final int calcSeqNoFromId(int id) {
        int seq = id - this.baseId;
        if (seq < 0 || seq >= this.getSize()) {
            throw new IllegalArgumentException("Not a valid ID: " + id);
        }
        return seq;
    }

    public final void enableCache() {
        if (this.valueToIdCache == null) {
            this.valueToIdCache = new SoftReference(new ConcurrentHashMap());
        }
        if (this.idToValueCache == null) {
            this.idToValueCache = new SoftReference<Object[]>(new Object[this.getSize()]);
        }
    }

    public final void disableCache() {
        this.valueToIdCache = null;
        this.idToValueCache = null;
    }

    protected abstract byte[] getValueBytesFromIdWithoutCache(int var1);

    protected abstract int getIdFromValueBytesWithoutCache(byte[] var1, int var2, int var3, int var4);
}

