/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.dict.GlobalDictionaryBuilder;
import org.apache.kylin.metadata.model.TblColRef;

public class DictionaryRule
implements IValidatorRule<CubeDesc> {
    static final String ERROR_DUPLICATE_DICTIONARY_COLUMN = "Duplicated dictionary specification for column: ";
    static final String ERROR_REUSE_BUILDER_BOTH_SET = "REUSE and BUILDER both set on dictionary for column: ";
    static final String ERROR_REUSE_BUILDER_BOTH_EMPTY = "REUSE and BUILDER both empty on dictionary for column: ";
    static final String ERROR_TRANSITIVE_REUSE = "Transitive REUSE is not allowed for dictionary: ";
    static final String ERROR_GLOBAL_DICTIONNARY_ONLY_MEASURE = "Global dictionary couldn't be used for dimension column: ";

    @Override
    public void validate(CubeDesc cubeDesc, ValidateContext context) {
        List<DictionaryDesc> dictDescs = cubeDesc.getDictionaries();
        Set<TblColRef> dimensionColumns = cubeDesc.listDimensionColumnsIncludingDerived();
        if (dictDescs == null || dictDescs.isEmpty()) {
            return;
        }
        HashSet<TblColRef> allDictCols = new HashSet<TblColRef>();
        HashSet<TblColRef> baseCols = new HashSet<TblColRef>();
        ArrayList<DictionaryDesc> reuseDictionaries = new ArrayList<DictionaryDesc>();
        for (DictionaryDesc dictDesc : dictDescs) {
            TblColRef dictCol = dictDesc.getColumnRef();
            TblColRef reuseCol = dictDesc.getResuseColumnRef();
            String builderClass = dictDesc.getBuilderClass();
            if (!allDictCols.add(dictCol)) {
                context.addResult(ResultLevel.ERROR, ERROR_DUPLICATE_DICTIONARY_COLUMN + dictCol);
                return;
            }
            if (reuseCol != null && StringUtils.isNotEmpty((String)builderClass)) {
                context.addResult(ResultLevel.ERROR, ERROR_REUSE_BUILDER_BOTH_SET + dictCol);
                return;
            }
            if (reuseCol == null && StringUtils.isEmpty((String)builderClass)) {
                context.addResult(ResultLevel.ERROR, ERROR_REUSE_BUILDER_BOTH_EMPTY + dictCol);
                return;
            }
            if (StringUtils.isNotEmpty((String)builderClass) && builderClass.equalsIgnoreCase(GlobalDictionaryBuilder.class.getName()) && dimensionColumns.contains(dictCol)) {
                context.addResult(ResultLevel.ERROR, ERROR_GLOBAL_DICTIONNARY_ONLY_MEASURE + dictCol);
                return;
            }
            if (reuseCol != null) {
                reuseDictionaries.add(dictDesc);
                continue;
            }
            baseCols.add(dictCol);
        }
        for (DictionaryDesc dictDesc : reuseDictionaries) {
            if (baseCols.contains(dictDesc.getResuseColumnRef())) continue;
            context.addResult(ResultLevel.ERROR, ERROR_TRANSITIVE_REUSE + dictDesc.getColumnRef());
            return;
        }
    }
}

