/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCubeBuilderInputConverter {
    private static final Logger logger = LoggerFactory.getLogger(InMemCubeBuilderInputConverter.class);
    public static final byte[] HIVE_NULL = Bytes.toBytes("\\N");
    private final CubeJoinedFlatTableEnrich flatDesc;
    private final MeasureDesc[] measureDescs;
    private final MeasureIngester<?>[] measureIngesters;
    private final int measureCount;
    private final Map<TblColRef, Dictionary<String>> dictionaryMap;
    private final GTInfo gtInfo;
    protected List<byte[]> nullBytes;

    public InMemCubeBuilderInputConverter(CubeDesc cubeDesc, IJoinedFlatTableDesc flatDesc, Map<TblColRef, Dictionary<String>> dictionaryMap, GTInfo gtInfo) {
        this.gtInfo = gtInfo;
        this.flatDesc = new CubeJoinedFlatTableEnrich(flatDesc, cubeDesc);
        this.measureCount = cubeDesc.getMeasures().size();
        this.measureDescs = cubeDesc.getMeasures().toArray(new MeasureDesc[this.measureCount]);
        this.measureIngesters = MeasureIngester.create(cubeDesc.getMeasures());
        this.dictionaryMap = dictionaryMap;
        this.initNullBytes(cubeDesc);
    }

    public final GTRecord convert(List<String> row) {
        GTRecord record = new GTRecord(this.gtInfo);
        this.convert(row, record);
        return record;
    }

    public final void convert(List<String> row, GTRecord record) {
        Object[] dimensions = this.buildKey(row);
        Object[] metricsValues = this.buildValue(row);
        Object[] recordValues = new Object[dimensions.length + metricsValues.length];
        System.arraycopy(dimensions, 0, recordValues, 0, dimensions.length);
        System.arraycopy(metricsValues, 0, recordValues, dimensions.length, metricsValues.length);
        record.setValues(recordValues);
    }

    private Object[] buildKey(List<String> row) {
        int keySize = this.flatDesc.getRowKeyColumnIndexes().length;
        Object[] key = new Object[keySize];
        for (int i = 0; i < keySize; ++i) {
            key[i] = row.get(this.flatDesc.getRowKeyColumnIndexes()[i]);
            if (key[i] == null || !this.isNull(Bytes.toBytes((String)key[i]))) continue;
            key[i] = null;
        }
        return key;
    }

    private Object[] buildValue(List<String> row) {
        Object[] values = new Object[this.measureCount];
        for (int i = 0; i < this.measureCount; ++i) {
            values[i] = this.buildValueOf(i, row);
        }
        return values;
    }

    private Object buildValueOf(int idxOfMeasure, List<String> row) {
        MeasureDesc measure = this.measureDescs[idxOfMeasure];
        FunctionDesc function = measure.getFunction();
        int[] colIdxOnFlatTable = this.flatDesc.getMeasureColumnIndexes()[idxOfMeasure];
        int paramCount = function.getParameterCount();
        String[] inputToMeasure = new String[paramCount];
        ParameterDesc param = function.getParameter();
        int paramColIdx = 0;
        int i = 0;
        while (i < paramCount) {
            String value = function.isCount() ? "1" : (param.isColumnType() ? row.get(colIdxOnFlatTable[paramColIdx++]) : param.getValue());
            inputToMeasure[i] = value;
            ++i;
            param = param.getNextParameter();
        }
        return this.measureIngesters[idxOfMeasure].valueOf(inputToMeasure, measure, this.dictionaryMap);
    }

    private void initNullBytes(CubeDesc cubeDesc) {
        this.nullBytes = Lists.newArrayList();
        this.nullBytes.add(HIVE_NULL);
        String[] nullStrings = cubeDesc.getNullStrings();
        if (nullStrings != null) {
            for (String s : nullStrings) {
                this.nullBytes.add(Bytes.toBytes(s));
            }
        }
    }

    private boolean isNull(byte[] v) {
        for (byte[] nullByte : this.nullBytes) {
            if (!Bytes.equals(v, nullByte)) continue;
            return true;
        }
        return false;
    }
}

