/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.cube.inmemcubing.MemDiskStore;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStore;
import org.apache.kylin.gridtable.IGTWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentDiskStore
implements IGTStore,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MemDiskStore.class);
    private static final boolean debug = true;
    private static final int STREAM_BUFFER_SIZE = 8192;
    private final GTInfo info;
    private final Object lock;
    private final File diskFile;
    private final boolean delOnClose;
    private Writer activeWriter;
    private HashSet<Reader> activeReaders = new HashSet();
    private FileChannel writeChannel;
    private FileChannel readChannel;

    public ConcurrentDiskStore(GTInfo info) throws IOException {
        this(info, File.createTempFile("ConcurrentDiskStore", ""), true);
    }

    public ConcurrentDiskStore(GTInfo info, File diskFile) throws IOException {
        this(info, diskFile, false);
    }

    private ConcurrentDiskStore(GTInfo info, File diskFile, boolean delOnClose) throws IOException {
        this.info = info;
        this.lock = this;
        this.diskFile = diskFile;
        this.delOnClose = delOnClose;
        if (delOnClose) {
            diskFile.deleteOnExit();
        }
        logger.debug(this + " disk file " + diskFile.getAbsolutePath());
    }

    @Override
    public GTInfo getInfo() {
        return this.info;
    }

    @Override
    public IGTWriter rebuild() throws IOException {
        return this.newWriter(0L);
    }

    @Override
    public IGTWriter append() throws IOException {
        return this.newWriter(this.diskFile.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGTWriter newWriter(long startOffset) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeWriter != null || !this.activeReaders.isEmpty()) {
                throw new IllegalStateException();
            }
            this.openWriteChannel(startOffset);
            this.activeWriter = new Writer(startOffset);
            return this.activeWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWriter(Writer w) {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeWriter != w) {
                throw new IllegalStateException();
            }
            this.activeWriter = null;
            this.closeWriteChannel();
        }
    }

    @Override
    public IGTScanner scan(GTScanRequest scanRequest) throws IOException {
        return this.newReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGTScanner newReader() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeWriter != null) {
                throw new IllegalStateException();
            }
            this.openReadChannel();
            Reader r = new Reader(0L);
            this.activeReaders.add(r);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeReader(Reader r) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.activeReaders.contains(r)) {
                throw new IllegalStateException();
            }
            this.activeReaders.remove(r);
            if (this.activeReaders.isEmpty()) {
                this.closeReadChannel();
            }
        }
    }

    private void openWriteChannel(long startOffset) throws IOException {
        if (startOffset > 0L) {
            this.writeChannel = FileChannel.open(this.diskFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        } else {
            this.diskFile.delete();
            this.writeChannel = FileChannel.open(this.diskFile.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
    }

    private void closeWriteChannel() {
        IOUtils.closeQuietly((Closeable)this.writeChannel);
        this.writeChannel = null;
    }

    private void openReadChannel() throws IOException {
        if (this.readChannel == null) {
            this.readChannel = FileChannel.open(this.diskFile.toPath(), StandardOpenOption.READ);
        }
    }

    private void closeReadChannel() throws IOException {
        IOUtils.closeQuietly((Closeable)this.readChannel);
        this.readChannel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeWriter != null || !this.activeReaders.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.delOnClose) {
                this.diskFile.delete();
            }
            logger.debug(this + " closed");
        }
    }

    public String toString() {
        return "ConcurrentDiskStore@" + (this.info.getTableName() == null ? Integer.valueOf(this.hashCode()) : this.info.getTableName());
    }

    private class Writer
    implements IGTWriter {
        final DataOutputStream dout;
        final ByteBuffer buf;
        long writeOffset;

        Writer(long startOffset) {
            this.writeOffset = startOffset;
            this.buf = ByteBuffer.allocate(ConcurrentDiskStore.this.info.getMaxRecordLength());
            logger.debug(ConcurrentDiskStore.this + " write start @ " + this.writeOffset);
            OutputStream out = new OutputStream(){
                byte[] tmp = new byte[1];

                @Override
                public void write(int b) throws IOException {
                    this.tmp[0] = (byte)b;
                    this.write(this.tmp, 0, 1);
                }

                @Override
                public void write(byte[] bytes, int offset, int length) throws IOException {
                    while (length > 0) {
                        int n = ConcurrentDiskStore.this.writeChannel.write(ByteBuffer.wrap(bytes, offset, length), Writer.this.writeOffset);
                        offset += n;
                        length -= n;
                        Writer.this.writeOffset += (long)n;
                    }
                }
            };
            this.dout = new DataOutputStream(new BufferedOutputStream(out, 8192));
        }

        @Override
        public void write(GTRecord rec) throws IOException {
            this.buf.clear();
            rec.exportColumns(ConcurrentDiskStore.this.info.getAllColumns(), this.buf);
            int len = this.buf.position();
            this.dout.writeInt(len);
            this.dout.write(this.buf.array(), this.buf.arrayOffset(), len);
        }

        @Override
        public void close() throws IOException {
            this.dout.close();
            ConcurrentDiskStore.this.closeWriter(this);
            logger.debug(ConcurrentDiskStore.this + " write end @ " + this.writeOffset);
        }
    }

    private class Reader
    implements IGTScanner {
        final DataInputStream din;
        long fileLen;
        long readOffset;
        long count;

        Reader(long startOffset) throws IOException {
            this.fileLen = ConcurrentDiskStore.this.diskFile.length();
            this.readOffset = startOffset;
            logger.debug(ConcurrentDiskStore.this + " read start @ " + this.readOffset);
            InputStream in = new InputStream(){
                byte[] tmp = new byte[1];

                @Override
                public int read() throws IOException {
                    int n = this.read(this.tmp, 0, 1);
                    if (n <= 0) {
                        return -1;
                    }
                    return this.tmp[0];
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    if (this.available() <= 0) {
                        return -1;
                    }
                    int lenToGo = Math.min(this.available(), len);
                    int nRead = 0;
                    while (lenToGo > 0) {
                        int n = ConcurrentDiskStore.this.readChannel.read(ByteBuffer.wrap(b, off, lenToGo), Reader.this.readOffset);
                        lenToGo -= n;
                        nRead += n;
                        off += n;
                        Reader.this.readOffset += (long)n;
                    }
                    return nRead;
                }

                @Override
                public int available() throws IOException {
                    return (int)(Reader.this.fileLen - Reader.this.readOffset);
                }
            };
            this.din = new DataInputStream(new BufferedInputStream(in, 8192));
        }

        @Override
        public void close() throws IOException {
            this.din.close();
            ConcurrentDiskStore.this.closeReader(this);
            logger.debug(ConcurrentDiskStore.this + " read end @ " + this.readOffset);
        }

        @Override
        public Iterator<GTRecord> iterator() {
            this.count = 0L;
            return new Iterator<GTRecord>(){
                GTRecord record;
                GTRecord next;
                ByteBuffer buf;
                {
                    this.record = new GTRecord(ConcurrentDiskStore.this.info);
                    this.buf = ByteBuffer.allocate(ConcurrentDiskStore.this.info.getMaxRecordLength());
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        if (Reader.this.din.available() > 0) {
                            int len = Reader.this.din.readInt();
                            Reader.this.din.read(this.buf.array(), this.buf.arrayOffset(), len);
                            this.buf.clear();
                            this.buf.limit(len);
                            this.record.loadColumns(ConcurrentDiskStore.this.info.getAllColumns(), this.buf);
                            this.next = this.record;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.next != null;
                }

                @Override
                public GTRecord next() {
                    if (this.next == null) {
                        this.hasNext();
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                    }
                    GTRecord r = this.next;
                    this.next = null;
                    ++Reader.this.count;
                    return r;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public GTInfo getInfo() {
            return ConcurrentDiskStore.this.info;
        }
    }
}

