/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.cuboid.AggregationGroupScheduler;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;

public class DefaultCuboidScheduler
extends CuboidScheduler {
    private final long max;
    private final Set<Long> allCuboidIds;
    private final Map<Long, List<Long>> parent2child;

    public DefaultCuboidScheduler(CubeDesc cubeDesc) {
        super(cubeDesc);
        int size = this.cubeDesc.getRowkey().getRowKeyColumns().length;
        this.max = (long)Math.pow(2.0, size) - 1L;
        Pair<Set<Long>, Map<Long, List<Long>>> pair = this.buildTreeBottomUp();
        this.allCuboidIds = pair.getFirst();
        this.parent2child = pair.getSecond();
    }

    @Override
    public int getCuboidCount() {
        return this.allCuboidIds.size();
    }

    @Override
    public List<Long> getSpanningCuboid(long cuboid) {
        if (cuboid > this.max || cuboid < 0L) {
            throw new IllegalArgumentException("Cuboid " + cuboid + " is out of scope 0-" + this.max);
        }
        List<Long> spanning = this.parent2child.get(cuboid);
        if (spanning == null) {
            return Collections.EMPTY_LIST;
        }
        return spanning;
    }

    @Override
    public Set<Long> getAllCuboidIds() {
        return Sets.newHashSet(this.allCuboidIds);
    }

    private Pair<Set<Long>, Map<Long, List<Long>>> buildTreeBottomUp() {
        int forward = this.cubeDesc.getParentForward();
        KylinConfig config = this.cubeDesc.getConfig();
        HashSet cuboidHolder = new HashSet();
        Set<Long> children = this.getLowestCuboids();
        long maxCombination = config.getCubeAggrGroupMaxCombination() * 10L;
        long l = maxCombination = maxCombination < 0L ? Long.MAX_VALUE : maxCombination;
        while (!children.isEmpty()) {
            if ((long)cuboidHolder.size() > maxCombination) {
                throw new IllegalStateException("Too many cuboids for the cube. Cuboid combination reached " + cuboidHolder.size() + " and limit is " + maxCombination + ". Abort calculation.");
            }
            cuboidHolder.addAll(children);
            children = this.getOnTreeParentsByLayer(children);
        }
        cuboidHolder.add(Cuboid.getBaseCuboidId(this.cubeDesc));
        cuboidHolder = Sets.newHashSet((Iterator)Iterators.filter(cuboidHolder.iterator(), (Predicate)new Predicate<Long>(){

            public boolean apply(@Nullable Long cuboidId) {
                return !DefaultCuboidScheduler.this.cubeDesc.isBlackedCuboid(cuboidId);
            }
        }));
        HashMap parent2Child = Maps.newHashMap();
        ArrayDeque<Long> cuboidScan = new ArrayDeque<Long>();
        cuboidScan.addAll(cuboidHolder);
        while (!cuboidScan.isEmpty()) {
            long current = (Long)cuboidScan.poll();
            long parent = this.getParentOnPromise(current, cuboidHolder, forward);
            if (parent <= 0L) continue;
            if (!cuboidHolder.contains(parent)) {
                cuboidScan.add(parent);
                cuboidHolder.add(parent);
            }
            if (parent2Child.containsKey(parent)) {
                ((List)parent2Child.get(parent)).add(current);
                continue;
            }
            parent2Child.put(parent, Lists.newArrayList((Object[])new Long[]{current}));
        }
        return Pair.newPair(cuboidHolder, parent2Child);
    }

    private long getParentOnPromise(long child, Set<Long> coll, int forward) {
        long parent = this.getOnTreeParent(child);
        if (parent < 0L) {
            return -1L;
        }
        if (coll.contains(parent) || forward == 0) {
            return parent;
        }
        return this.getParentOnPromise(parent, coll, forward - 1);
    }

    @Override
    public long findBestMatchCuboid(long child) {
        long parent = this.getOnTreeParent(child);
        while (parent > 0L && !this.cubeDesc.getAllCuboids().contains(parent)) {
            parent = this.getOnTreeParent(parent);
        }
        if (parent <= 0L) {
            throw new IllegalStateException("Can't find valid parent for Cuboid " + child);
        }
        return parent;
    }

    private long getOnTreeParent(long child) {
        Set<Long> candidates = this.getOnTreeParents(child);
        if (candidates == null || candidates.isEmpty()) {
            return -1L;
        }
        return Collections.min(candidates, Cuboid.cuboidSelectComparator);
    }

    private Set<Long> getOnTreeParentsByLayer(Collection<Long> children) {
        HashSet parents = new HashSet();
        for (long child : children) {
            parents.addAll(this.getOnTreeParents(child));
        }
        parents = Sets.newHashSet((Iterator)Iterators.filter(parents.iterator(), (Predicate)new Predicate<Long>(){

            public boolean apply(@Nullable Long cuboidId) {
                if (cuboidId == Cuboid.getBaseCuboidId(DefaultCuboidScheduler.this.cubeDesc)) {
                    return true;
                }
                for (AggregationGroup agg : DefaultCuboidScheduler.this.cubeDesc.getAggregationGroups()) {
                    if (!agg.isOnTree(cuboidId) || !agg.checkDimCap(cuboidId)) continue;
                    return true;
                }
                return false;
            }
        }));
        return parents;
    }

    private Set<Long> getOnTreeParents(long child) {
        ArrayList aggrs = Lists.newArrayList();
        for (AggregationGroup agg : this.cubeDesc.getAggregationGroups()) {
            if (!agg.isOnTree(child)) continue;
            aggrs.add(agg);
        }
        return this.getOnTreeParents(child, aggrs);
    }

    private Set<Long> getLowestCuboids() {
        return this.getOnTreeParents(0L, this.cubeDesc.getAggregationGroups());
    }

    private Set<Long> getOnTreeParents(long child, Collection<AggregationGroup> groups) {
        HashSet<Long> parentCandidate = new HashSet<Long>();
        if (child == Cuboid.getBaseCuboidId(this.cubeDesc)) {
            return parentCandidate;
        }
        for (AggregationGroup agg : groups) {
            if (child == agg.getPartialCubeFullMask()) {
                parentCandidate.add(Cuboid.getBaseCuboidId(this.cubeDesc));
                return parentCandidate;
            }
            parentCandidate.addAll(AggregationGroupScheduler.getOnTreeParents(child, agg));
        }
        return parentCandidate;
    }
}

