/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;

public abstract class CuboidScheduler {
    protected final CubeDesc cubeDesc;
    private transient List<List<Long>> cuboidsByLayer;

    public static CuboidScheduler getInstance(CubeDesc cubeDesc) {
        String clzName = cubeDesc.getConfig().getCuboidScheduler();
        try {
            Class<CuboidScheduler> clz = ClassUtil.forName(clzName, CuboidScheduler.class);
            return clz.getConstructor(CubeDesc.class).newInstance(cubeDesc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected CuboidScheduler(CubeDesc cubeDesc) {
        this.cubeDesc = cubeDesc;
    }

    public abstract Set<Long> getAllCuboidIds();

    public abstract int getCuboidCount();

    public abstract List<Long> getSpanningCuboid(long var1);

    public abstract long findBestMatchCuboid(long var1);

    public List<List<Long>> getCuboidsByLayer() {
        int size;
        if (this.cuboidsByLayer != null) {
            return this.cuboidsByLayer;
        }
        int totalNum = 0;
        this.cuboidsByLayer = Lists.newArrayList();
        this.cuboidsByLayer.add(Collections.singletonList(Cuboid.getBaseCuboidId(this.cubeDesc)));
        ++totalNum;
        ArrayList lastLayer = this.cuboidsByLayer.get(this.cuboidsByLayer.size() - 1);
        while (!lastLayer.isEmpty()) {
            ArrayList newLayer = Lists.newArrayList();
            for (Long parent : lastLayer) {
                newLayer.addAll(this.getSpanningCuboid(parent));
            }
            if (newLayer.isEmpty()) break;
            this.cuboidsByLayer.add(newLayer);
            totalNum += newLayer.size();
            lastLayer = newLayer;
        }
        Preconditions.checkState((totalNum == (size = this.getAllCuboidIds().size()) ? 1 : 0) != 0, (Object)("total Num: " + totalNum + " actual size: " + size));
        return this.cuboidsByLayer;
    }
}

