/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;

public class CuboidCLI {
    public static void main(String[] args) throws IOException {
        CubeDescManager cubeDescMgr = CubeDescManager.getInstance(KylinConfig.getInstanceFromEnv());
        if ("test".equals(args[0])) {
            CubeDesc cubeDesc = cubeDescMgr.getCubeDesc(args[1]);
            CuboidCLI.simulateCuboidGeneration(cubeDesc, true);
        }
    }

    public static int simulateCuboidGeneration(CubeDesc cubeDesc, boolean validate) {
        CuboidScheduler scheduler = cubeDesc.getCuboidScheduler();
        long baseCuboid = Cuboid.getBaseCuboidId(cubeDesc);
        TreeSet<Long> cuboidSet = new TreeSet<Long>();
        cuboidSet.add(baseCuboid);
        LinkedList<Long> cuboidQueue = new LinkedList<Long>();
        cuboidQueue.push(baseCuboid);
        while (!cuboidQueue.isEmpty()) {
            long cuboid = (Long)cuboidQueue.pop();
            List<Long> spnanningCuboids = scheduler.getSpanningCuboid(cuboid);
            for (Long sc : spnanningCuboids) {
                boolean notfound = cuboidSet.add(sc);
                if (!notfound) {
                    throw new IllegalStateException("Find duplicate spanning cuboid " + sc + " from cuboid " + cuboid);
                }
                cuboidQueue.push(sc);
            }
        }
        boolean enableDimCap = false;
        for (AggregationGroup agg : cubeDesc.getAggregationGroups()) {
            if (agg.getDimCap() <= 0) continue;
            enableDimCap = true;
            break;
        }
        if (validate) {
            if (enableDimCap) {
                if (cubeDesc.getAllCuboids().size() != cuboidSet.size()) {
                    throw new IllegalStateException("Expected cuboid set " + cubeDesc.getAllCuboids() + "; but actual cuboid set " + cuboidSet);
                }
            } else {
                TreeSet<Long> enumCuboids = CuboidCLI.enumCalcCuboidCount(cubeDesc);
                System.out.println(Arrays.toString((Object[])enumCuboids.toArray(new Long[enumCuboids.size()])));
                if (!enumCuboids.equals(cuboidSet)) {
                    throw new IllegalStateException("Expected cuboid set " + enumCuboids + "; but actual cuboid set " + cuboidSet);
                }
                for (long i = 0L; i < baseCuboid; ++i) {
                    if (cuboidSet.contains(i)) {
                        if (!Cuboid.isValid(cubeDesc, i)) {
                            throw new RuntimeException();
                        }
                        if (Cuboid.translateToValidCuboid(cubeDesc, i) == i) continue;
                        throw new RuntimeException();
                    }
                    if (Cuboid.isValid(cubeDesc, i)) {
                        throw new RuntimeException();
                    }
                    long corrected = Cuboid.translateToValidCuboid(cubeDesc, i);
                    if (corrected == i) {
                        throw new RuntimeException();
                    }
                    if (!Cuboid.isValid(cubeDesc, corrected)) {
                        throw new RuntimeException();
                    }
                    if (Cuboid.translateToValidCuboid(cubeDesc, corrected) == corrected) continue;
                    throw new RuntimeException();
                }
            }
        }
        return cuboidSet.size();
    }

    public static TreeSet<Long> enumCalcCuboidCount(CubeDesc cube) {
        long baseCuboid = Cuboid.getBaseCuboidId(cube);
        TreeSet<Long> expectedCuboids = new TreeSet<Long>();
        for (long cuboid = 0L; cuboid <= baseCuboid; ++cuboid) {
            if (!Cuboid.isValid(cube, cuboid)) continue;
            expectedCuboids.add(cuboid);
        }
        return expectedCuboids;
    }

    public static int[] calculateAllLevelCount(CubeDesc cube) {
        int levels = cube.getBuildLevel();
        int[] allLevelCounts = new int[levels + 1];
        CuboidScheduler scheduler = cube.getCuboidScheduler();
        LinkedList<Long> nextQueue = new LinkedList<Long>();
        LinkedList<Long> currentQueue = new LinkedList<Long>();
        long baseCuboid = Cuboid.getBaseCuboidId(cube);
        currentQueue.push(baseCuboid);
        for (int i = 0; i <= levels; ++i) {
            allLevelCounts[i] = currentQueue.size();
            while (!currentQueue.isEmpty()) {
                long cuboid = (Long)currentQueue.pop();
                List<Long> spnanningCuboids = scheduler.getSpanningCuboid(cuboid);
                nextQueue.addAll(spnanningCuboids);
            }
            currentQueue = nextQueue;
            nextQueue = new LinkedList();
            if (i != levels || currentQueue.isEmpty()) continue;
            throw new IllegalStateException();
        }
        return allLevelCounts;
    }
}

