/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class Cuboid
implements Comparable<Cuboid>,
Serializable {
    private static final Map<String, Map<Long, Cuboid>> CUBOID_CACHE = new ConcurrentHashMap<String, Map<Long, Cuboid>>();
    public static final Comparator<Long> cuboidSelectComparator = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            return ComparisonChain.start().compare(Long.bitCount(o1), Long.bitCount(o2)).compare((Comparable)o1, (Comparable)o2).result();
        }
    };
    private CubeDesc cubeDesc;
    private final long inputID;
    private final long id;
    private final byte[] idBytes;
    private final boolean requirePostAggregation;
    private List<TblColRef> dimensionColumns;
    private volatile CuboidToGridTableMapping cuboidToGridTableMapping = null;

    public static Cuboid identifyCuboid(CubeDesc cubeDesc, Set<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        long cuboidID = Cuboid.identifyCuboidId(cubeDesc, dimensions, metrics);
        return Cuboid.findById(cubeDesc, cuboidID);
    }

    public static long identifyCuboidId(CubeDesc cubeDesc, Set<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        for (FunctionDesc metric : metrics) {
            if (!metric.getMeasureType().onlyAggrInBaseCuboid()) continue;
            return Cuboid.getBaseCuboidId(cubeDesc);
        }
        long cuboidID = 0L;
        for (TblColRef column : dimensions) {
            int index = cubeDesc.getRowkey().getColumnBitIndex(column);
            cuboidID |= 1L << index;
        }
        return cuboidID;
    }

    public static Cuboid findForFullCube(CubeDesc cube, long cuboidID) {
        return new Cuboid(cube, cuboidID, cuboidID);
    }

    public static Cuboid findById(CubeDesc cube, byte[] cuboidID) {
        return Cuboid.findById(cube, Bytes.toLong(cuboidID));
    }

    public static Cuboid findById(CubeDesc cube, long cuboidID) {
        Cuboid cuboid;
        Map<Long, Cuboid> cubeCache = CUBOID_CACHE.get(cube.getName());
        if (cubeCache == null) {
            cubeCache = new ConcurrentHashMap<Long, Cuboid>();
            CUBOID_CACHE.put(cube.getName(), cubeCache);
        }
        if ((cuboid = cubeCache.get(cuboidID)) == null) {
            long validCuboidID = Cuboid.translateToValidCuboid(cube, cuboidID);
            cuboid = new Cuboid(cube, cuboidID, validCuboidID);
            cubeCache.put(cuboidID, cuboid);
        }
        return cuboid;
    }

    public static boolean isValid(CubeDesc cube, long cuboidID) {
        return cube.getAllCuboids().contains(cuboidID);
    }

    public static long getBaseCuboidId(CubeDesc cube) {
        return cube.getRowkey().getFullMask();
    }

    public static Cuboid getBaseCuboid(CubeDesc cube) {
        return Cuboid.findById(cube, Cuboid.getBaseCuboidId(cube));
    }

    static long translateToValidCuboid(CubeDesc cubeDesc, long cuboidID) {
        long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
        if (cubeDesc.getAllCuboids().contains(cuboidID)) {
            return cuboidID;
        }
        ArrayList onTreeCandidates = Lists.newArrayList();
        for (AggregationGroup agg : cubeDesc.getAggregationGroups()) {
            Long candidate = Cuboid.translateToOnTreeCuboid(agg, cuboidID);
            if (candidate == null) continue;
            onTreeCandidates.add(candidate);
        }
        if (onTreeCandidates.size() == 0) {
            return baseCuboidId;
        }
        long onTreeCandi = Collections.min(onTreeCandidates, cuboidSelectComparator);
        if (Cuboid.isValid(cubeDesc, onTreeCandi)) {
            return onTreeCandi;
        }
        return cubeDesc.getCuboidScheduler().findBestMatchCuboid(onTreeCandi);
    }

    private static Long translateToOnTreeCuboid(AggregationGroup agg, long cuboidID) {
        if ((cuboidID & (agg.getPartialCubeFullMask() ^ 0xFFFFFFFFFFFFFFFFL)) > 0L) {
            return null;
        }
        cuboidID |= agg.getMandatoryColumnMask();
        for (AggregationGroup.HierarchyMask hierarchyMask : agg.getHierarchyMasks()) {
            long fullMask = hierarchyMask.fullMask;
            long intersect = cuboidID & fullMask;
            if (intersect == 0L || intersect == fullMask) continue;
            boolean startToFill = false;
            for (int i = hierarchyMask.dims.length - 1; i >= 0; --i) {
                if (startToFill) {
                    cuboidID |= hierarchyMask.dims[i];
                    continue;
                }
                if ((cuboidID & hierarchyMask.dims[i]) == 0L) continue;
                startToFill = true;
                cuboidID |= hierarchyMask.dims[i];
            }
        }
        for (Long joint : agg.getJoints()) {
            if ((cuboidID | joint) == cuboidID || (cuboidID & (joint ^ 0xFFFFFFFFFFFFFFFFL)) == cuboidID) continue;
            cuboidID |= joint.longValue();
        }
        if (!agg.isOnTree(cuboidID)) {
            long nonJointDims = Cuboid.removeBits(agg.getPartialCubeFullMask() ^ agg.getMandatoryColumnMask(), agg.getJoints());
            if (nonJointDims != 0L) {
                long nonJointNonHierarchy = Cuboid.removeBits(nonJointDims, Collections2.transform(agg.getHierarchyMasks(), (Function)new Function<AggregationGroup.HierarchyMask, Long>(){

                    public Long apply(AggregationGroup.HierarchyMask input) {
                        return input.fullMask;
                    }
                }));
                if (nonJointNonHierarchy != 0L) {
                    return cuboidID | Long.lowestOneBit(nonJointNonHierarchy);
                }
                long allJointDims = agg.getJointDimsMask();
                for (AggregationGroup.HierarchyMask hierarchyMask : agg.getHierarchyMasks()) {
                    long dim = hierarchyMask.allMasks[0];
                    if ((dim & allJointDims) != 0L) continue;
                    return cuboidID | dim;
                }
            }
            Preconditions.checkState((boolean)agg.isOnTree(cuboidID |= Collections.min(agg.getJoints(), cuboidSelectComparator).longValue()));
        }
        return cuboidID;
    }

    private static long removeBits(long original, Collection<Long> toRemove) {
        long ret = original;
        for (Long joint : toRemove) {
            ret &= joint ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return ret;
    }

    private Cuboid(CubeDesc cubeDesc, long originalID, long validID) {
        this.cubeDesc = cubeDesc;
        this.inputID = originalID;
        this.id = validID;
        this.idBytes = Bytes.toBytes(this.id);
        this.dimensionColumns = this.translateIdToColumns(this.id);
        this.requirePostAggregation = this.calcExtraAggregation(this.inputID, this.id) != 0L;
    }

    private List<TblColRef> translateIdToColumns(long cuboidID) {
        ArrayList<TblColRef> dimesnions = new ArrayList<TblColRef>();
        RowKeyColDesc[] allColumns = this.cubeDesc.getRowkey().getRowKeyColumns();
        for (int i = 0; i < allColumns.length; ++i) {
            long bitmask = 1L << allColumns[i].getBitIndex();
            if ((cuboidID & bitmask) == 0L) continue;
            TblColRef colRef = allColumns[i].getColRef();
            dimesnions.add(colRef);
        }
        return dimesnions;
    }

    private long calcExtraAggregation(long inputID, long id) {
        long diff = id ^ inputID;
        return this.eliminateHierarchyAggregation(diff);
    }

    private long eliminateHierarchyAggregation(long id) {
        long finalId = id;
        for (AggregationGroup agg : this.cubeDesc.getAggregationGroups()) {
            long temp = id;
            List<AggregationGroup.HierarchyMask> hierarchyMaskList = agg.getHierarchyMasks();
            if (hierarchyMaskList == null || hierarchyMaskList.size() <= 0) continue;
            for (AggregationGroup.HierarchyMask hierMask : hierarchyMaskList) {
                long[] allMasks = hierMask.allMasks;
                for (int i = allMasks.length - 1; i > 0; --i) {
                    long bit = allMasks[i] ^ allMasks[i - 1];
                    if ((this.inputID & bit) == 0L || (temp &= allMasks[i - 1] ^ 0xFFFFFFFFFFFFFFFFL) >= finalId) continue;
                    finalId = temp;
                }
            }
        }
        return finalId;
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public List<TblColRef> getColumns() {
        return this.dimensionColumns;
    }

    public List<TblColRef> getAggregationColumns() {
        long aggrColsID = this.eliminateHierarchyAggregation(this.id);
        return this.translateIdToColumns(aggrColsID);
    }

    public long getId() {
        return this.id;
    }

    public byte[] getBytes() {
        return this.idBytes;
    }

    public long getInputID() {
        return this.inputID;
    }

    public boolean requirePostAggregation() {
        return this.requirePostAggregation;
    }

    public static void clearCache() {
        CUBOID_CACHE.clear();
    }

    public static void reloadCache(String cubeDescName) {
        CUBOID_CACHE.remove(cubeDescName);
    }

    public String toString() {
        return "Cuboid [id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cuboid other = (Cuboid)obj;
        return this.id == other.id;
    }

    @Override
    public int compareTo(Cuboid o) {
        if (this.id < o.id) {
            return -1;
        }
        if (this.id > o.id) {
            return 1;
        }
        return 0;
    }

    public CuboidToGridTableMapping getCuboidToGridTableMapping() {
        if (this.cuboidToGridTableMapping == null) {
            this.cuboidToGridTableMapping = new CuboidToGridTableMapping(this);
        }
        return this.cuboidToGridTableMapping;
    }

    public static String getDisplayName(long cuboidID, int dimensionCount) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensionCount; ++i) {
            if ((cuboidID & 1L << i) == 0L) {
                sb.append('0');
                continue;
            }
            sb.append('1');
        }
        return StringUtils.reverse((String)sb.toString());
    }
}

