/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;

public class AggregationGroupScheduler {
    public static List<Long> getCuboidsForAgg(final CubeDesc cubeDesc, AggregationGroup agg) {
        HashSet<Long> cuboidHolder = new HashSet<Long>();
        Set<Long> children = AggregationGroupScheduler.getLowestCuboids(agg);
        while (!children.isEmpty()) {
            if ((long)cuboidHolder.size() > cubeDesc.getConfig().getCubeAggrGroupMaxCombination()) {
                throw new IllegalStateException("too many combination for the aggregation group");
            }
            cuboidHolder.addAll(children);
            children = AggregationGroupScheduler.getOnTreeParentsByLayer(children, agg);
        }
        return Lists.newArrayList((Iterator)Iterators.filter(cuboidHolder.iterator(), (Predicate)new Predicate<Long>(){

            public boolean apply(@Nullable Long cuboidId) {
                return !cubeDesc.isBlackedCuboid(cuboidId);
            }
        }));
    }

    private static Set<Long> getOnTreeParentsByLayer(Collection<Long> children, final AggregationGroup agg) {
        HashSet parents = new HashSet();
        for (long child : children) {
            parents.addAll(AggregationGroupScheduler.getOnTreeParents(child, agg));
        }
        parents = Sets.newHashSet((Iterator)Iterators.filter(parents.iterator(), (Predicate)new Predicate<Long>(){

            public boolean apply(@Nullable Long cuboidId) {
                return agg.checkDimCap(cuboidId);
            }
        }));
        return parents;
    }

    private static Set<Long> getLowestCuboids(AggregationGroup agg) {
        return AggregationGroupScheduler.getOnTreeParents(0L, agg);
    }

    public static Set<Long> getOnTreeParents(long child, AggregationGroup agg) {
        HashSet<Long> parentCandidate = new HashSet<Long>();
        long tmpChild = child;
        if (tmpChild == agg.getPartialCubeFullMask()) {
            return parentCandidate;
        }
        if (agg.getMandatoryColumnMask() != 0L) {
            if (agg.isMandatoryOnlyValid()) {
                if (AggregationGroupScheduler.fillBit(tmpChild, agg.getMandatoryColumnMask(), parentCandidate)) {
                    return parentCandidate;
                }
            } else {
                tmpChild |= agg.getMandatoryColumnMask();
            }
        }
        for (Long normal : agg.getNormalDims()) {
            AggregationGroupScheduler.fillBit(tmpChild, normal, parentCandidate);
        }
        for (Long joint : agg.getJoints()) {
            AggregationGroupScheduler.fillBit(tmpChild, joint, parentCandidate);
        }
        for (AggregationGroup.HierarchyMask hierarchy : agg.getHierarchyMasks()) {
            for (long mask : hierarchy.allMasks) {
                if (AggregationGroupScheduler.fillBit(tmpChild, mask, parentCandidate)) break;
            }
        }
        return parentCandidate;
    }

    private static boolean fillBit(long origin, long other, Set<Long> coll) {
        if ((origin & other) != other) {
            coll.add(origin | other);
            return true;
        }
        return false;
    }
}

